/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.report.ReportGeneratorConfiguration;
import com.xceptance.xlt.report.providers.CustomLogReport;
import com.xceptance.xlt.report.providers.CustomLogsReport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;

public class CustomLogsReportProvider
extends AbstractReportProvider {
    public static final String CUSTOM_DATA_HEADER_MARKER = "# Header inserted by XLT ====================";
    private static final String CUSTOM_DATA = "custom_data_logs";
    private Set<String> foundScopes = new HashSet<String>();
    private Map<String, ZipOutputStream> zipStreamsForScopes = new HashMap<String, ZipOutputStream>();
    private Map<String, List<Path>> foundScopeFiles = new HashMap<String, List<Path>>();
    private String baseDir;
    private Path targetDir = null;

    @Override
    public Object createReportFragment() {
        CustomLogsReport report = new CustomLogsReport();
        FileObject results = ((ReportGeneratorConfiguration)this.getConfiguration()).getResultsDirectory();
        this.baseDir = results.getName().getBaseName();
        this.targetDir = Paths.get(String.valueOf(this.getConfiguration().getReportDirectory()) + File.separator + CUSTOM_DATA, new String[0]);
        boolean collectCustomDataInOneFile = ((ReportGeneratorConfiguration)this.getConfiguration()).aggregateCustomData();
        if (collectCustomDataInOneFile) {
            this.findLogsAggregated(results);
        } else {
            this.findLogsNonAggregated(results);
        }
        for (String scope : this.foundScopes) {
            CustomLogReport clr = new CustomLogReport();
            clr.scope = scope;
            Path targetPath = Paths.get(String.valueOf(this.targetDir) + File.separator + scope + ".zip", new String[0]);
            try {
                clr.size = Files.size(targetPath);
                clr.path = CUSTOM_DATA + File.separator + scope + ".zip";
            }
            catch (IOException e) {
                XltLogger.runTimeLogger.error("Unable to collect information for custom data logs for " + scope + ". Cause: " + e.getMessage());
            }
            report.customLogs.add(clr);
        }
        return report;
    }

    @Override
    public void processDataRecord(Data data) {
    }

    @Override
    public boolean wantsDataRecords() {
        return false;
    }

    private void findLogsAggregated(FileObject results) {
        try {
            this.findLogs(results, null, true);
        }
        catch (IOException e) {
            XltLogger.runTimeLogger.error("Failed to walk file tree searching for custom data logs. Cause: " + e.getMessage());
        }
        finally {
            this.writeAggregatedDataToZip();
        }
    }

    private void findLogsNonAggregated(FileObject results) {
        try {
            this.findLogs(results, null, false);
        }
        catch (IOException e) {
            XltLogger.runTimeLogger.error("Failed to walk file tree searching for custom data logs. Cause: " + e.getMessage());
        }
        finally {
            this.finishZipStreams();
        }
    }

    private void findLogs(FileObject file, String currentPath, boolean aggregated) throws IOException {
        String filename = file.getName().getBaseName();
        if (file.getType() == FileType.FOLDER) {
            if (!"config".equals(filename)) {
                for (FileObject fo : file.getChildren()) {
                    this.findLogs(fo, this.makePath(currentPath, filename), aggregated);
                }
            }
        } else if (file.getType() == FileType.FILE && file.getName().getBaseName().toString().startsWith("custom_log_")) {
            String scopeName = filename.substring("custom_log_".length(), filename.lastIndexOf(46));
            if (this.foundScopes.isEmpty()) {
                this.targetDir.toFile().mkdirs();
            }
            if (aggregated) {
                this.aggregateDataForScope(file, scopeName);
            } else {
                this.copyCustomDataFileToZip(file, currentPath, filename.substring("custom_log_".length()), scopeName);
            }
        }
    }

    private void copyCustomDataFileToZip(FileObject file, String currentPath, String filename, String scopeName) throws IOException {
        ZipOutputStream scopeStream = this.zipStreamsForScopes.get(scopeName);
        if (scopeStream == null) {
            FileOutputStream fos = new FileOutputStream(this.targetDir.toString() + File.separator + scopeName + ".zip");
            scopeStream = new ZipOutputStream(fos);
            this.zipStreamsForScopes.put(scopeName, scopeStream);
            this.foundScopes.add(scopeName);
        }
        scopeStream.putNextEntry(new ZipEntry(this.makePath(currentPath, filename)));
        this.writeDataToZip(file, scopeStream);
        scopeStream.closeEntry();
    }

    private void aggregateDataForScope(FileObject file, String scopeName) {
        Path scopePath;
        String scopeFile = scopeName + "." + file.getName().getExtension();
        List<Path> scopePaths = this.foundScopeFiles.get(scopeName);
        if (scopePaths == null) {
            scopePaths = new ArrayList<Path>();
            this.foundScopeFiles.put(scopeName, scopePaths);
        }
        if (!scopePaths.contains(scopePath = this.targetDir.resolve(scopeFile).toAbsolutePath().normalize())) {
            scopePaths.add(scopePath);
        }
        try {
            if (!Files.exists(scopePath, new LinkOption[0])) {
                Files.createFile(scopePath, new FileAttribute[0]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (BufferedWriter scopeWriter = Files.newBufferedWriter(scopePath, StandardOpenOption.APPEND);
             BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContent().getInputStream(), StandardCharsets.UTF_8));){
            String line;
            boolean first = true;
            while ((line = reader.readLine()) != null) {
                if (first) {
                    first = false;
                    if (CUSTOM_DATA_HEADER_MARKER.equals(line)) {
                        line = reader.readLine();
                        if (Files.size(scopePath) > 0L) continue;
                    }
                }
                scopeWriter.write(line);
                scopeWriter.newLine();
            }
        }
        catch (IOException e) {
            XltLogger.runTimeLogger.error("Error reading or writing file: " + e.getMessage() + String.valueOf(e.getClass()));
        }
    }

    private void writeAggregatedDataToZip() {
        for (String scopeName : this.foundScopeFiles.keySet()) {
            try (FileOutputStream fos = new FileOutputStream(this.targetDir.toString() + File.separator + scopeName + ".zip");
                 ZipOutputStream zos = new ZipOutputStream(fos);){
                for (Path fileForScope : this.foundScopeFiles.get(scopeName)) {
                    ZipEntry zipEntry = new ZipEntry(fileForScope.getFileName().toString());
                    zos.putNextEntry(zipEntry);
                    Files.copy(fileForScope, zos);
                    zos.closeEntry();
                    Files.deleteIfExists(fileForScope);
                }
                this.foundScopes.add(scopeName);
            }
            catch (IOException e) {
                XltLogger.runTimeLogger.error("Error zipping custom data file for scope " + scopeName + ": " + e.getMessage());
            }
        }
    }

    private String makePath(String currentPath, String currentFileName) {
        if (currentPath != null) {
            return currentPath + "/" + currentFileName;
        }
        if (this.baseDir.equals(currentFileName)) {
            return null;
        }
        return currentFileName;
    }

    private void writeDataToZip(FileObject file, ZipOutputStream scopeStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContent().getInputStream(), StandardCharsets.UTF_8));){
            String line;
            boolean first = true;
            while ((line = reader.readLine()) != null) {
                if (first) {
                    first = false;
                    if (CUSTOM_DATA_HEADER_MARKER.equals(line)) continue;
                }
                scopeStream.write((line + System.lineSeparator()).getBytes("UTF-8"));
            }
        }
    }

    private void finishZipStreams() {
        for (ZipOutputStream zos : this.zipStreamsForScopes.values()) {
            try {
                zos.close();
            }
            catch (IOException e) {
                XltLogger.runTimeLogger.error("Unable to zip custom data logs to report. Cause: " + e.getMessage());
            }
        }
    }
}

