/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.mergerules.url;

import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.report.mergerules.Condition;
import com.xceptance.xlt.report.mergerules.url.UrlConditionAndText;
import com.xceptance.xlt.report.mergerules.url.UrlConditionText;
import com.xceptance.xlt.report.mergerules.url.UrlEmptyCondition;
import org.apache.commons.lang3.StringUtils;

public class UrlCondition
extends Condition {
    public UrlCondition(String regex) {
        super(regex, 2500);
    }

    @Override
    protected CharSequence getText(RequestData requestData) {
        return requestData.getUrl();
    }

    @Override
    protected String getTypeCode() {
        return "u";
    }

    public static Condition build(String regex, String text) {
        if (!StringUtils.isBlank((CharSequence)text) && !StringUtils.isBlank((CharSequence)regex)) {
            return new UrlConditionAndText(regex, text);
        }
        if (!StringUtils.isBlank((CharSequence)text)) {
            return new UrlConditionText(text);
        }
        if (!StringUtils.isBlank((CharSequence)regex)) {
            return new UrlCondition(regex);
        }
        return new UrlEmptyCondition();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{ type: '");
        sb.append(this.getTypeCode()).append("', ");
        sb.append("pattern: '").append(this.getPattern());
        sb.append("'}");
        return sb.toString();
    }
}

