/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.mergerules;

import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.report.mergerules.MergeRule;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MergeRuleProcessor {
    private static final Log LOG = LogFactory.getLog(MergeRuleProcessor.class);
    private final MergeRule[] mergeRules;
    private final boolean removeIndexesFromRequestNames;

    public MergeRuleProcessor(List<MergeRule> requestProcessingRules, boolean removeIndexesFromRequestNames) {
        this.mergeRules = requestProcessingRules.toArray(new MergeRule[requestProcessingRules.size()]);
        this.removeIndexesFromRequestNames = removeIndexesFromRequestNames;
        int lastId = -1;
        for (MergeRule rule : this.mergeRules) {
            if (rule.getId() <= lastId) {
                throw new IllegalArgumentException("Request processing rules must be sorted by ID in ascending order.");
            }
            lastId = rule.getId();
        }
    }

    public RequestData postprocess(RequestData requestData) {
        int firstDotPos;
        String requestName = requestData.getName();
        if (this.removeIndexesFromRequestNames && (firstDotPos = requestName.indexOf(".")) > 0) {
            requestName = requestName.substring(0, firstDotPos);
            requestData.setName(requestName);
        }
        int nextId = 0;
        MergeRule mergeRule = null;
        try {
            for (int i = 0; i < this.mergeRules.length; ++i) {
                mergeRule = this.mergeRules[i];
                if (nextId > mergeRule.getId() || (nextId = mergeRule.process(requestData)) >= 0) continue;
                if (nextId == -2) break;
                return null;
            }
            requestData.getName().hashCode();
        }
        catch (Throwable t) {
            String msg = String.format("Failed to apply request merge rule: %s\n%s", mergeRule, t);
            LOG.error((Object)msg);
            requestData.setName(requestName);
        }
        return requestData;
    }
}

