/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.mergerules;

import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.report.mergerules.Condition;
import com.xceptance.xlt.report.mergerules.InvalidMergeRuleException;
import com.xceptance.xlt.report.mergerules.PlaceholderPosition;
import com.xceptance.xlt.report.mergerules.agent.AgentNameCondition;
import com.xceptance.xlt.report.mergerules.contenttype.ContentTypeCondition;
import com.xceptance.xlt.report.mergerules.httpmethod.HttpMethodCondition;
import com.xceptance.xlt.report.mergerules.requestname.RequestNameCondition;
import com.xceptance.xlt.report.mergerules.responsetime.ResponseTimeCondition;
import com.xceptance.xlt.report.mergerules.statuscode.StatusCodeCondition;
import com.xceptance.xlt.report.mergerules.transaction.TransactionNameCondition;
import com.xceptance.xlt.report.mergerules.url.UrlCondition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class MergeRule {
    public static final int STOP = -2;
    public static final int DROP = -1;
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{([acmnrstu])(?::(.+?))?\\}");
    private final String newName;
    private final boolean stopOnMatch;
    private final boolean dropOnMatch;
    private final Condition[] includeConditions;
    private final Condition[] excludeConditions;
    private final PlaceholderPosition[] newNamePlaceholders;
    private final int id;
    private final int continueOnMatchAtId;
    private final int continueOnNoMatchAtId;

    public MergeRule(int id, NewName newName, NamePattern requestNamePattern, UrlPattern urlPattern, ContentTypePattern contentTypePattern, StatusCodePattern statusCodePattern, AgentNamePattern agentNamePattern, TransactionNamePattern transactionNamePattern, HttpMethodPattern httpMethodPattern, RunTimeRanges responseTimeRanges, StopOnMatch stopOnMatch, NameExcludePattern requestNameExcludePattern, UrlExcludePattern urlExcludePattern, ContentTypeExcludePattern contentTypeExcludePattern, StatusCodeExcludePattern statusCodeExcludePattern, AgentNameExcludePattern agentNameExcludePattern, TransactionNameExcludePattern transactionNameExcludePattern, HttpMethodExcludePattern httpMethodExcludePattern, ContinueOnMatchAtId continueOnMatchAtId, ContinueOnNoMatchAtId continueOnNoMatchAtId, DropOnMatch dropOnMatch, UrlText urlText, UrlTextExclude urlTextExclude) throws InvalidMergeRuleException {
        this.id = id;
        this.stopOnMatch = stopOnMatch.value;
        this.dropOnMatch = dropOnMatch.value;
        this.continueOnMatchAtId = continueOnMatchAtId.value;
        this.continueOnNoMatchAtId = continueOnNoMatchAtId.value;
        if (this.continueOnMatchAtId < this.id) {
            throw new InvalidMergeRuleException(String.format("Continue on match rule ID (%s) must be greater or same than the rule ID (%s)", this.continueOnMatchAtId, this.id));
        }
        if (this.continueOnNoMatchAtId < this.id) {
            throw new InvalidMergeRuleException(String.format("Continue on no match rule ID (%s) must be greater or same than the rule ID (%s)", this.continueOnNoMatchAtId, this.id));
        }
        List<PlaceholderPosition> tempPlaceHolderPositions = this.parsePlaceholderPositions(newName.value);
        List<Condition> includeConditions = new ArrayList<Condition>();
        List<Condition> excludeConditions = new ArrayList<Condition>();
        try {
            includeConditions.add(RequestNameCondition.build(requestNamePattern.value));
            excludeConditions.add(RequestNameCondition.build(requestNameExcludePattern.value));
            includeConditions.add(UrlCondition.build(urlPattern.value, urlText.value));
            excludeConditions.add(UrlCondition.build(urlExcludePattern.value, urlTextExclude.value));
            includeConditions.add(ContentTypeCondition.build(contentTypePattern.value));
            excludeConditions.add(ContentTypeCondition.build(contentTypeExcludePattern.value));
            includeConditions.add(StatusCodeCondition.build(statusCodePattern.value));
            excludeConditions.add(StatusCodeCondition.build(statusCodeExcludePattern.value));
            includeConditions.add(AgentNameCondition.build(agentNamePattern.value));
            excludeConditions.add(AgentNameCondition.build(agentNameExcludePattern.value));
            includeConditions.add(TransactionNameCondition.build(transactionNamePattern.value));
            excludeConditions.add(TransactionNameCondition.build(transactionNameExcludePattern.value));
            includeConditions.add(HttpMethodCondition.build(httpMethodPattern.value));
            excludeConditions.add(HttpMethodCondition.build(httpMethodExcludePattern.value));
            includeConditions.add(new ResponseTimeCondition(responseTimeRanges.value));
        }
        catch (PatternSyntaxException pse) {
            throw new InvalidMergeRuleException("Invalid regular expression: " + pse.getPattern());
        }
        includeConditions = this.cleanUpIncludeConditions(tempPlaceHolderPositions, includeConditions);
        excludeConditions = this.cleanUpExcludeConditions(excludeConditions);
        this.includeConditions = includeConditions.toArray(new Condition[includeConditions.size()]);
        this.excludeConditions = excludeConditions.toArray(new Condition[excludeConditions.size()]);
        this.newName = MergeRule.adjustNewName(newName.value, tempPlaceHolderPositions);
        this.newNamePlaceholders = tempPlaceHolderPositions.toArray(new PlaceholderPosition[tempPlaceHolderPositions.size()]);
        this.resolveRequestFilter(this.newNamePlaceholders);
        this.validateRule();
    }

    private List<Condition> cleanUpIncludeConditions(List<PlaceholderPosition> positions, List<Condition> conditions) {
        return conditions.stream().filter(c -> {
            for (PlaceholderPosition pos : positions) {
                if (!pos.typeCode.equals(c.getTypeCode())) continue;
                return true;
            }
            return !c.isEmpty();
        }).toList();
    }

    private List<Condition> cleanUpExcludeConditions(List<Condition> conditions) {
        return conditions.stream().filter(c -> !c.isEmpty()).toList();
    }

    private void resolveRequestFilter(PlaceholderPosition[] positions) {
        block0: for (PlaceholderPosition pos : positions) {
            for (Condition condition : this.includeConditions) {
                if (!condition.getTypeCode().equals(pos.typeCode)) continue;
                pos.condition = condition;
                continue block0;
            }
        }
    }

    private List<PlaceholderPosition> parsePlaceholderPositions(String nameWithPlaceholders) throws InvalidMergeRuleException {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(nameWithPlaceholders);
        ArrayList<PlaceholderPosition> positions = new ArrayList<PlaceholderPosition>();
        while (matcher.find()) {
            int matchingGroupIndex = -1;
            String matchingGroupIndexString = matcher.group(2);
            if (matchingGroupIndexString != null) {
                try {
                    matchingGroupIndex = Integer.valueOf(matchingGroupIndexString);
                }
                catch (NumberFormatException e) {
                    throw new InvalidMergeRuleException(String.format("Failed to parse the matching group index '%s' as integer", matchingGroupIndexString));
                }
            }
            PlaceholderPosition position = new PlaceholderPosition(matcher.group(1), matchingGroupIndex, matcher.start(), matcher.end(), matcher.group().length());
            positions.add(position);
        }
        Collections.reverse(positions);
        return positions;
    }

    public static String adjustNewName(String nameWithPlaceholders, List<PlaceholderPosition> positions) {
        StringBuilder name = new StringBuilder(nameWithPlaceholders);
        int displacement = 0;
        for (int i = positions.size() - 1; i >= 0; --i) {
            PlaceholderPosition pos = positions.get(i);
            name.delete(pos.start - displacement, pos.end - displacement);
            positions.set(i, new PlaceholderPosition(pos.typeCode, pos.capturingGroupIndex, pos.start - displacement));
            displacement += pos.length;
        }
        return name.toString();
    }

    public int process(RequestData requestData) {
        boolean state;
        for (Condition condition : this.excludeConditions) {
            state = condition.apply(requestData);
            if (!state) continue;
            return this.continueOnNoMatchAtId;
        }
        for (Condition condition : this.includeConditions) {
            state = condition.apply(requestData);
            if (state) continue;
            return this.continueOnNoMatchAtId;
        }
        if (this.dropOnMatch) {
            return -1;
        }
        if (this.newNamePlaceholders.length > 0) {
            StringBuilder result = new StringBuilder(50);
            result.append(this.newName);
            for (PlaceholderPosition placeholder : this.newNamePlaceholders) {
                Condition requestFilter = placeholder.condition;
                CharSequence replacement = requestFilter.getReplacementText(requestData, placeholder.capturingGroupIndex);
                result.insert(placeholder.start, replacement);
            }
            requestData.setName(result.toString());
        } else {
            requestData.setName(this.newName);
        }
        return this.stopOnMatch ? -2 : this.continueOnMatchAtId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Naming rule: '").append(this.newName).append("', filters:  [");
        boolean appendComma = false;
        ArrayList conditions = new ArrayList();
        Arrays.stream(this.includeConditions).forEach(conditions::add);
        Arrays.stream(this.excludeConditions).forEach(conditions::add);
        for (Condition condition : conditions) {
            if (appendComma) {
                sb.append(", ");
            }
            switch (condition.getTypeCode()) {
                case "a": {
                    sb.append("agentName: ").append(condition.toString());
                    break;
                }
                case "c": {
                    sb.append("contentType: ").append(condition.toString());
                    break;
                }
                case "n": {
                    sb.append("requestName: ").append(condition.toString());
                    break;
                }
                case "r": {
                    sb.append("responseTime: ").append(condition.toString());
                    break;
                }
                case "s": {
                    sb.append("statusCode: ").append(condition.toString());
                    break;
                }
                case "t": {
                    sb.append("txnName: ").append(condition.toString());
                    break;
                }
                case "m": {
                    sb.append("httpMethod: ").append(condition.toString());
                    break;
                }
                case "u": {
                    sb.append("url: ").append(condition.toString());
                    break;
                }
                default: {
                    sb.append("unknown");
                }
            }
            appendComma = true;
        }
        sb.append("]");
        return sb.toString();
    }

    public int getId() {
        return this.id;
    }

    public Condition[] getIncludeConditions() {
        return this.includeConditions;
    }

    public Condition[] getExcludeConditions() {
        return this.excludeConditions;
    }

    private void validateRule() throws InvalidMergeRuleException {
        block0: for (PlaceholderPosition placeholderPosition : this.newNamePlaceholders) {
            for (Condition c : this.includeConditions) {
                String pattern;
                int nbCaptureGroups;
                if (!c.getTypeCode().equals(placeholderPosition.typeCode)) continue;
                if (placeholderPosition.capturingGroupIndex <= 0 || placeholderPosition.capturingGroupIndex <= (nbCaptureGroups = RegExUtils.getCaptureGroupCount(pattern = c.getPattern()))) continue block0;
                throw new InvalidMergeRuleException(String.format("Pattern '%s' has no matching group '%d'. Important: You can only capture in include rules.", pattern, placeholderPosition.capturingGroupIndex));
            }
        }
    }

    public record StopOnMatch(boolean value) {
    }

    public record DropOnMatch(boolean value) {
    }

    public record ContinueOnMatchAtId(int value) {
    }

    public record ContinueOnNoMatchAtId(int value) {
    }

    public record NewName(String value) {
    }

    public record NamePattern(String value) {
    }

    public record NameExcludePattern(String value) {
    }

    public record UrlPattern(String value) {
    }

    public record UrlText(String value) {
    }

    public record UrlExcludePattern(String value) {
    }

    public record UrlTextExclude(String value) {
    }

    public record ContentTypePattern(String value) {
    }

    public record ContentTypeExcludePattern(String value) {
    }

    public record StatusCodePattern(String value) {
    }

    public record StatusCodeExcludePattern(String value) {
    }

    public record AgentNamePattern(String value) {
    }

    public record AgentNameExcludePattern(String value) {
    }

    public record TransactionNamePattern(String value) {
    }

    public record TransactionNameExcludePattern(String value) {
    }

    public record HttpMethodPattern(String value) {
    }

    public record HttpMethodExcludePattern(String value) {
    }

    public record RunTimeRanges(String value) {
    }
}

