/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.mergerules;

import com.xceptance.common.collection.LRUClockMap;
import com.xceptance.common.lang.ThrowableUtils;
import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.api.engine.RequestData;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class Condition {
    private static final MatchResult NULL = Pattern.compile(".*").matcher("null").toMatchResult();
    private final LRUClockMap<CharSequence, MatchResult> cache;
    private final Matcher matcher;
    private MatchResult lastFilterState;

    public Condition(String regex, int cacheSize) {
        Matcher matcher = this.matcher = StringUtils.isBlank((CharSequence)regex) ? null : RegExUtils.getPattern(regex, 0).matcher("any");
        if (cacheSize <= 0) {
            throw new IllegalArgumentException("Cache size must be larger than 0");
        }
        this.cache = new LRUClockMap(cacheSize);
    }

    public MatchResult getLastFilterState() {
        return this.lastFilterState;
    }

    protected abstract CharSequence getText(RequestData var1);

    protected boolean apply(RequestData requestData) {
        CharSequence text = this.getText(requestData);
        MatchResult result = this.cache.get(text);
        if (result != null) {
            if (result == NULL) {
                this.lastFilterState = null;
                return false;
            }
            this.lastFilterState = result;
            return true;
        }
        Matcher m = this.matcher.reset(text);
        if (m.find()) {
            result = m.toMatchResult();
            this.cache.put(text, result);
            this.lastFilterState = result;
            return true;
        }
        this.cache.put(text, NULL);
        this.lastFilterState = null;
        return false;
    }

    protected CharSequence getReplacementText(RequestData requestData, int capturingGroupIndex) {
        try {
            return capturingGroupIndex == -1 ? this.getText(requestData) : this.getLastFilterState().group(capturingGroupIndex);
        }
        catch (IndexOutOfBoundsException ioobe) {
            String format = "No matching group %d for input string '%s' and pattern '%s'";
            ThrowableUtils.setMessage(ioobe, String.format("No matching group %d for input string '%s' and pattern '%s'", capturingGroupIndex, this.getText(requestData), this.getPattern()));
            throw ioobe;
        }
    }

    protected String getPattern() {
        return this.matcher == null ? "" : this.matcher.pattern().pattern();
    }

    protected boolean isEmpty() {
        return this.matcher == null;
    }

    protected abstract String getTypeCode();

    public String toString() {
        StringBuilder sb = new StringBuilder("{ type: '");
        sb.append(this.getTypeCode()).append("', ");
        sb.append("pattern: '").append(this.getPattern()).append("'}");
        return sb.toString();
    }
}

