/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report;

import com.xceptance.common.util.Console;
import com.xceptance.common.util.ProductInformation;
import com.xceptance.xlt.api.report.ReportProvider;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.engine.XltEngine;
import com.xceptance.xlt.engine.util.TimerUtils;
import com.xceptance.xlt.mastercontroller.TestCaseLoadProfileConfiguration;
import com.xceptance.xlt.mastercontroller.TestLoadProfileConfiguration;
import com.xceptance.xlt.report.DataProcessor;
import com.xceptance.xlt.report.DataRecordFactory;
import com.xceptance.xlt.report.ReportGeneratorConfiguration;
import com.xceptance.xlt.report.ReportTransformer;
import com.xceptance.xlt.report.XmlReportGenerator;
import com.xceptance.xlt.report.external.ExternalReportGenerator;
import com.xceptance.xlt.report.scorecard.Evaluator;
import com.xceptance.xlt.report.scorecard.Scorecard;
import com.xceptance.xlt.report.util.ConcurrentUsersTable;
import com.xceptance.xlt.report.util.JFreeChartUtils;
import com.xceptance.xlt.report.util.ReportUtils;
import com.xceptance.xlt.report.util.TaskManager;
import com.xceptance.xlt.util.Timer;
import com.xceptance.xlt.util.XltPropertiesImpl;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VFS;

public class ReportGenerator {
    private final ReportGeneratorConfiguration config;
    private final FileObject inputDir;
    private final File outputDir;
    private final List<ReportProvider> reportProviders;
    private final ExternalReportGenerator repGen;
    private final String testCaseIncludePatternList;
    private final String testCaseExcludePatternList;
    private final String agentIncludePatternList;
    private final String agentExcludePatternList;

    public ReportGenerator(FileObject inputDir, File outputDir, boolean noCharts) throws Exception {
        this(inputDir, outputDir, noCharts, false, null, null, null, null, null, null);
    }

    public ReportGenerator(FileObject inputDir, File outputDir, boolean noCharts, boolean noAgentCharts, File overridePropertyFile, Properties commandLineProperties, String testCaseIncludePatternList, String testCaseExcludePatternList, String agentIncludePatternList, String agentExcludePatternList) throws Exception {
        XltPropertiesImpl props;
        FileObject configDir = inputDir.resolveFile("config");
        try {
            props = new XltPropertiesImpl(inputDir, configDir, false, false);
            XltEngine.reset(props);
        }
        catch (Exception e) {
            XltLogger.reportLogger.warn("One or more configuration files seem to be missing or corrupt! Check log trace.");
            props = new XltPropertiesImpl(inputDir, configDir, false, true);
        }
        this.config = new ReportGeneratorConfiguration(props.getProperties(), overridePropertyFile, commandLineProperties);
        this.testCaseIncludePatternList = testCaseIncludePatternList;
        this.testCaseExcludePatternList = testCaseExcludePatternList;
        this.agentIncludePatternList = agentIncludePatternList;
        this.agentExcludePatternList = agentExcludePatternList;
        if (noCharts) {
            this.config.disableChartsGeneration();
        }
        if (noAgentCharts) {
            this.config.disableAgentCharts();
        }
        this.inputDir = inputDir;
        this.config.setResultsDirectory(this.inputDir);
        String resultsDirectoryName = this.getResultsDirName(inputDir);
        this.config.setResultsDirectoryName(resultsDirectoryName);
        this.outputDir = outputDir == null ? new File(this.config.getTestReportsRootDirectory(), resultsDirectoryName) : outputDir;
        this.config.setReportDirectory(this.outputDir);
        TaskManager.getInstance().setMaximumThreadCount(Runtime.getRuntime().availableProcessors());
        JFreeChartUtils.setWebpCompressionFactor(this.config.getChartCompressionFactor());
        this.reportProviders = new ArrayList<ReportProvider>();
        this.repGen = new ExternalReportGenerator();
    }

    public static void ensureOutputDirAndClean(File dir) throws IOException {
        if (!dir.exists()) {
            XltLogger.reportLogger.info("Creating output directory: {}", (Object)dir);
            FileUtils.forceMkdir((File)dir);
        } else {
            XltLogger.reportLogger.info("Cleaning output directory: {}", (Object)dir);
            FileUtils.cleanDirectory((File)dir);
        }
    }

    public void generateReport(boolean noRampUp) throws Exception {
        this.generateReport(0L, Long.MAX_VALUE, -1L, noRampUp, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateReport(long fromTime, long toTime, long duration, boolean noRampUp, boolean fromTimeRel, boolean toTimeRel) throws Exception {
        try {
            ReportGenerator.ensureOutputDirAndClean(this.outputDir);
            for (Class<? extends ReportProvider> c : this.config.getReportProviderClasses()) {
                try {
                    ReportProvider processor = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    processor.setConfiguration(this.config);
                    this.reportProviders.add(processor);
                }
                catch (Throwable t) {
                    XltLogger.reportLogger.error("Failed to instantiate and initialize report provider instance of class '{}'", (Object)c.getCanonicalName(), (Object)t);
                }
            }
            this.readLogs(fromTime, toTime, duration, noRampUp, fromTimeRel, toTimeRel);
            File xmlReport = this.createReport(this.outputDir);
            this.reportProviders.clear();
            File scorecardXml = this.evaluateReport(xmlReport);
            this.transformReport(xmlReport, this.outputDir, scorecardXml != null);
            if (scorecardXml != null) {
                this.transformScorecard(scorecardXml);
            }
            File reportFile = new File(this.outputDir, "index.html");
            String reportPath = ReportUtils.toString(reportFile);
            XltLogger.reportLogger.info("Report: {}", (Object)reportPath);
        }
        finally {
            ConcurrentUsersTable.getInstance().clear();
        }
    }

    public void readLogs(long fromTime, long toTime, long duration, boolean noRampUp, boolean fromTimeRel, boolean toTimeRel) {
        XltLogger.reportLogger.info(Console.horizontalBar());
        XltLogger.reportLogger.info(Console.startSection("Reading Log Files..."));
        long testStartTime = this.config.getLongProperty("com.xceptance.xlt.loadtest.start", 0L);
        long elapsedTime = this.config.getLongProperty("com.xceptance.xlt.loadtest.elapsed", 0L);
        long[] timeBoundaries = this.getTimeBoundaries(fromTime, toTime, duration, noRampUp, fromTimeRel, toTimeRel, testStartTime, elapsedTime);
        fromTime = timeBoundaries[0];
        toTime = timeBoundaries[1];
        this.printStartAndEndTime(fromTime, toTime);
        if (toTime <= fromTime) {
            throw new IllegalArgumentException("Specified start must not be after specified end.");
        }
        this.read(fromTime, toTime);
        XltLogger.reportLogger.info(Console.endSection());
    }

    private long[] getTimeBoundaries(long fromTime, long toTime, long duration, boolean noRampUp, boolean fromTimeRel, boolean toTimeRel, long testStartDate, long elapsedTime) {
        if (fromTimeRel) {
            fromTime = this.recalculateOffsetTimeValue(fromTime, testStartDate, elapsedTime);
        }
        if (toTimeRel && (toTime = this.recalculateOffsetTimeValue(toTime, testStartDate, elapsedTime)) == 0L) {
            toTime = Long.MAX_VALUE;
        }
        if (duration >= 0L) {
            if (toTime == Long.MAX_VALUE) {
                toTime = fromTime + duration;
            } else {
                fromTime = toTime - duration;
            }
        }
        if (noRampUp) {
            fromTime = this.excludeRampup(fromTime);
        }
        long[] boundaries = new long[]{fromTime, toTime};
        return boundaries;
    }

    private long excludeRampup(long fromTime) {
        long startTime = this.config.getLongProperty("com.xceptance.xlt.loadtest.start", 0L);
        if (startTime > 0L) {
            File configDir = new File(this.inputDir.getName().getPath(), "config");
            XltPropertiesImpl properties = TestLoadProfileConfiguration.readProperties(configDir.getParentFile(), configDir);
            TestLoadProfileConfiguration loadProfileConfig = new TestLoadProfileConfiguration(properties);
            long endOfRampUpTime = startTime + ReportGenerator.computeRampUpOffset(loadProfileConfig.getLoadTestConfiguration()) * 1000L;
            fromTime = Math.max(fromTime, endOfRampUpTime);
        } else {
            XltLogger.reportLogger.warn("PLEASE NOTE: Ramp-up could not be excluded since no value could be found for property '{}'.", (Object)"com.xceptance.xlt.loadtest.start");
        }
        return fromTime;
    }

    private void read(long fromTime, long toTime) {
        DataRecordFactory dataRecordFactory = new DataRecordFactory(this.config.getDataRecordClasses());
        DataProcessor logReader = new DataProcessor(this.config, this.inputDir, dataRecordFactory, fromTime, toTime, this.reportProviders, this.testCaseIncludePatternList, this.testCaseExcludePatternList, this.agentIncludePatternList, this.agentExcludePatternList);
        logReader.readDataRecords();
        XltLogger.reportLogger.info(Console.endSection());
        long minTime = logReader.getMinimumTime();
        long maxTime = logReader.getMaximumTime();
        this.config.setChartStartTime(minTime);
        this.config.setChartEndTime(maxTime);
        try {
            XltLogger.reportLogger.info(Console.horizontalBar());
            XltLogger.reportLogger.info(Console.startSection("Processing External Data Files..."));
            Timer timer = Timer.start();
            File externalChartsDir = new File(this.config.getChartDirectory(), "external");
            externalChartsDir.mkdirs();
            this.repGen.init(minTime, maxTime, this.inputDir.getName().getPath(), externalChartsDir, this.config.shouldChartsGenerated());
            this.repGen.parse();
            XltLogger.reportLogger.info(timer.stop().get("...finished"));
        }
        catch (Exception e) {
            XltLogger.reportLogger.error("Failed to process external data", (Throwable)e);
        }
    }

    private long recalculateOffsetTimeValue(long offsetTimeValue, long testStartDate, long elapsedTime) {
        long timeValue = 0L;
        long endTime = testStartDate + elapsedTime;
        if (offsetTimeValue < 0L) {
            if (testStartDate == 0L || elapsedTime == 0L) {
                XltLogger.reportLogger.warn("PLEASE NOTE: The specified offset '{}' could not be used since no value could be found for properties '{}' and '{}'", new Object[]{offsetTimeValue, "com.xceptance.xlt.loadtest.start", "com.xceptance.xlt.loadtest.elapsed"});
            } else {
                timeValue = endTime + offsetTimeValue;
            }
        } else if (testStartDate == 0L) {
            XltLogger.reportLogger.warn("PLEASE NOTE: The specified offset '{}' could not be used since no value could be found for property '{}'", (Object)offsetTimeValue, (Object)"com.xceptance.xlt.loadtest.start");
        } else {
            timeValue = testStartDate + offsetTimeValue;
        }
        return timeValue;
    }

    private void printStartAndEndTime(long fromTime, long toTime) {
        if (fromTime > 0L && toTime == Long.MAX_VALUE) {
            XltLogger.reportLogger.info("Data start: {}", (Object)new Date(fromTime));
        } else if (fromTime == 0L && toTime != Long.MAX_VALUE) {
            XltLogger.reportLogger.info("Data end: {}", (Object)new Date(toTime));
        } else if (fromTime > 0L && toTime != Long.MAX_VALUE) {
            XltLogger.reportLogger.info("Data start: {}", (Object)new Date(fromTime));
            XltLogger.reportLogger.info("Data end  : {}", (Object)new Date(toTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createReport(File outputDir) throws Exception {
        File file;
        XltLogger.reportLogger.info(Console.horizontalBar());
        XltLogger.reportLogger.info(Console.startSection("Creating Artifacts..."));
        this.copyConfiguration(outputDir);
        XmlReportGenerator xmlReportGenerator = new XmlReportGenerator();
        xmlReportGenerator.registerStatisticsProviders(this.reportProviders);
        xmlReportGenerator.registerStatisticsProviders(this.repGen.getReportCreators());
        long start = TimerUtils.get().getStartTime();
        try {
            TaskManager.getInstance().startProgress("Creating");
            File xmlReport = new File(outputDir, "testreport.xml");
            xmlReportGenerator.createReport(xmlReport);
            file = xmlReport;
        }
        catch (Throwable throwable) {
            TaskManager.getInstance().waitForAllTasksToComplete();
            TaskManager.getInstance().stopProgress();
            XltLogger.reportLogger.info(String.format("...finished - %,d ms", TimerUtils.get().getElapsedTime(start)));
            XltLogger.reportLogger.info(Console.endSection());
            throw throwable;
        }
        TaskManager.getInstance().waitForAllTasksToComplete();
        TaskManager.getInstance().stopProgress();
        XltLogger.reportLogger.info(String.format("...finished - %,d ms", TimerUtils.get().getElapsedTime(start)));
        XltLogger.reportLogger.info(Console.endSection());
        return file;
    }

    private void copyConfiguration(File outputDir) throws FileSystemException {
        FileObject reportConfigDir = VFS.getManager().resolveFile(outputDir, "config");
        FileObject resultsConfigDir = this.inputDir.getChild("config");
        if (resultsConfigDir != null) {
            try {
                reportConfigDir.copyFrom(resultsConfigDir, Selectors.SELECT_ALL);
            }
            catch (FileSystemException e) {
                XltLogger.reportLogger.error("Issue while copying original properties from {}", (Object)reportConfigDir.getPublicURIString(), (Object)e);
            }
        } else {
            XltLogger.reportLogger.warn("There is not config directory with property files avaialble. Skipping.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformReport(File inputXmlFile, File outputDir, boolean scorecardPresent) throws Exception {
        XltLogger.reportLogger.info(Console.horizontalBar());
        XltLogger.reportLogger.info(Console.startSection("Creating HTML Report..."));
        FileUtils.forceMkdir((File)outputDir);
        File resourcesDir = new File(this.config.getConfigDirectory(), "testreport");
        FileUtils.copyDirectory((File)resourcesDir, (File)outputDir, (FileFilter)FileFilterUtils.makeSVNAware(null), (boolean)false);
        ArrayList<File> outputFiles = new ArrayList<File>();
        ArrayList<File> styleSheetFiles = new ArrayList<File>();
        List<String> styleSheetFileNames = this.config.getStyleSheetFileNames();
        List<String> outputFileNames = this.config.getOutputFileNames();
        for (int i = 0; i < styleSheetFileNames.size(); ++i) {
            File outputFile = new File(outputDir, outputFileNames.get(i));
            outputFiles.add(outputFile);
            File styleSheetFile = new File(new File(this.config.getConfigDirectory(), "xsl/loadreport"), styleSheetFileNames.get(i));
            styleSheetFiles.add(styleSheetFile);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("productName", ProductInformation.getProductInformation().getProductName());
        parameters.put("productVersion", ProductInformation.getProductInformation().getVersion());
        parameters.put("productUrl", ProductInformation.getProductInformation().getProductURL());
        parameters.put("scorecardPresent", scorecardPresent);
        ReportTransformer reportTransformer = new ReportTransformer(outputFiles, styleSheetFiles, parameters);
        long start = TimerUtils.get().getStartTime();
        try {
            XltLogger.reportLogger.info("XML data file: {}", (Object)inputXmlFile);
            TaskManager.getInstance().setMaximumThreadCount(1);
            TaskManager.getInstance().startProgress("Creating");
            reportTransformer.run(inputXmlFile, outputDir);
        }
        catch (Throwable throwable) {
            TaskManager.getInstance().waitForAllTasksToComplete();
            TaskManager.getInstance().stopProgress();
            XltLogger.reportLogger.info(String.format("...finished - %,d ms", TimerUtils.get().getElapsedTime(start)));
            XltLogger.reportLogger.info(Console.endSection());
            throw throwable;
        }
        TaskManager.getInstance().waitForAllTasksToComplete();
        TaskManager.getInstance().stopProgress();
        XltLogger.reportLogger.info(String.format("...finished - %,d ms", TimerUtils.get().getElapsedTime(start)));
        XltLogger.reportLogger.info(Console.endSection());
    }

    public void updateScorecard() throws Exception {
        File xmlReport;
        File scorecardXml;
        try {
            this.inputDir.resolveFile("testreport.xml", NameScope.CHILD);
        }
        catch (FileSystemException fse) {
            XltLogger.reportLogger.error("Could not find '{}' in directory '{}'.", (Object)"testreport.xml", (Object)this.inputDir.getName().getPathDecoded());
            return;
        }
        FileObject targetDir = VFS.getManager().toFileObject(this.outputDir);
        if (this.inputDir.getName() != targetDir.getName()) {
            ReportGenerator.ensureOutputDirAndClean(this.outputDir);
            targetDir.copyFrom(this.inputDir, Selectors.SELECT_ALL);
        }
        if ((scorecardXml = this.evaluateReport(xmlReport = new File(this.outputDir, "testreport.xml"))) != null) {
            this.transformScorecard(scorecardXml);
        }
        File reportFile = new File(this.outputDir, "index.html");
        String reportPath = ReportUtils.toString(reportFile);
        XltLogger.reportLogger.info("Report: {}", (Object)reportPath);
    }

    private String getResultsDirName(FileObject input) {
        String inputDirName;
        FileName inputName = input.getName();
        boolean isPlainDirectory = inputName.getScheme().equals("file");
        if (isPlainDirectory) {
            inputDirName = inputName.getBaseName();
        } else if (inputName.getPath().equals("/")) {
            String archivePathName = StringUtils.substringBefore((String)inputName.getRoot().toString(), (String)"!");
            inputDirName = FilenameUtils.getBaseName((String)archivePathName);
        } else {
            inputDirName = inputName.getBaseName();
        }
        return inputDirName;
    }

    private File evaluateReport(File reportXMLFile) {
        File scorecardConfigFile;
        String scorecardConfig = this.config.getStringProperty("com.xceptance.xlt.scorecard.config", null);
        File file = scorecardConfigFile = scorecardConfig != null ? new File(new File(this.outputDir, "config"), scorecardConfig) : null;
        if (scorecardConfigFile != null) {
            XltLogger.reportLogger.debug("Evaluating test report using configuration file '{}'", (Object)scorecardConfigFile.getAbsolutePath());
            String errMessage = "Failed to evaluate test report";
            try {
                File scorecardXMLFile = new File(this.outputDir, "scorecard.xml");
                Evaluator evaluator = new Evaluator(scorecardConfigFile);
                Scorecard outcome = evaluator.evaluate(reportXMLFile);
                String error = outcome.result.getError();
                if (StringUtils.isNotBlank((CharSequence)error)) {
                    XltLogger.reportLogger.error("{}: {}", (Object)"Failed to evaluate test report", (Object)error);
                }
                evaluator.writeScorecardToFile(outcome, scorecardXMLFile);
                return scorecardXMLFile;
            }
            catch (Throwable t) {
                XltLogger.reportLogger.error("Failed to evaluate test report", t);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformScorecard(File inputXmlFile) throws Exception {
        XltLogger.reportLogger.info(Console.horizontalBar());
        XltLogger.reportLogger.info(Console.startSection("Creating Scorecard..."));
        File styleSheetFile = new File(new File(this.config.getConfigDirectory(), "xsl/scorecard"), "index.xsl");
        File outputFile = new File(this.outputDir, "scorecard.html");
        String projectNamePropValue = this.config.getStringProperty("com.xceptance.xlt.projectName", null);
        String projectName = StringUtils.trimToEmpty((String)projectNamePropValue);
        String organizationPropValue = this.config.getStringProperty("com.xceptance.xtc.organization", null);
        String organization = StringUtils.trimToEmpty((String)organizationPropValue);
        String projectPropValue = this.config.getStringProperty("com.xceptance.xtc.project", null);
        String project = StringUtils.trimToEmpty((String)projectPropValue);
        String loadTestIdPropValue = this.config.getStringProperty("com.xceptance.xtc.loadtest.run.id", null);
        String loadTestId = StringUtils.trimToEmpty((String)loadTestIdPropValue);
        String resultIdPropValue = this.config.getStringProperty("com.xceptance.xtc.loadtest.result.id", null);
        String resultId = StringUtils.trimToEmpty((String)resultIdPropValue);
        String reportIdPropValue = this.config.getStringProperty("com.xceptance.xtc.loadtest.report.id", null);
        String reportId = StringUtils.trimToEmpty((String)reportIdPropValue);
        Map<String, Object> parameters = Map.of("productName", ProductInformation.getProductInformation().getProductName(), "productVersion", ProductInformation.getProductInformation().getVersion(), "productUrl", ProductInformation.getProductInformation().getProductURL(), "projectName", projectName, "scorecardPresent", Boolean.TRUE, "xtcOrganization", organization, "xtcProject", project, "xtcLoadTestId", loadTestId, "xtcResultId", resultId, "xtcReportId", reportId);
        ReportTransformer reportTransformer = new ReportTransformer(List.of(outputFile), List.of(styleSheetFile), parameters);
        long start = TimerUtils.get().getStartTime();
        try {
            TaskManager.getInstance().setMaximumThreadCount(1);
            TaskManager.getInstance().startProgress("Creating");
            reportTransformer.run(inputXmlFile, this.outputDir);
        }
        catch (Throwable throwable) {
            TaskManager.getInstance().waitForAllTasksToComplete();
            TaskManager.getInstance().stopProgress();
            XltLogger.reportLogger.info(String.format("...finished - %,d ms", TimerUtils.get().getElapsedTime(start)));
            XltLogger.reportLogger.info(Console.endSection());
            throw throwable;
        }
        TaskManager.getInstance().waitForAllTasksToComplete();
        TaskManager.getInstance().stopProgress();
        XltLogger.reportLogger.info(String.format("...finished - %,d ms", TimerUtils.get().getElapsedTime(start)));
        XltLogger.reportLogger.info(Console.endSection());
    }

    static long computeRampUpOffset(List<TestCaseLoadProfileConfiguration> profiles) {
        long maxRampUpOffset = 0L;
        long smallestInitialDelay = Long.MAX_VALUE;
        for (TestCaseLoadProfileConfiguration profile : profiles) {
            int initialDelay = profile.getInitialDelay();
            int rampUpPeriod = profile.getRampUpPeriod();
            if (rampUpPeriod > 0) {
                maxRampUpOffset = Math.max(maxRampUpOffset, (long)(initialDelay + rampUpPeriod));
            }
            smallestInitialDelay = Math.min(smallestInitialDelay, (long)initialDelay);
        }
        return Math.max(0L, maxRampUpOffset - smallestInitialDelay);
    }
}

