/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.util.XltCharBuffer;
import com.xceptance.xlt.api.util.XltException;
import java.lang.reflect.Constructor;
import java.util.Map;

public class DataRecordFactory {
    private final Constructor<? extends Data>[] constructors;
    private final int offset;

    public DataRecordFactory(Map<String, Class<? extends Data>> dataClasses) {
        if (dataClasses == null || dataClasses.size() == 0) {
            throw new XltException("No Data classes configured");
        }
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (Map.Entry<String, Class<? extends Data>> entry : dataClasses.entrySet()) {
            char c = entry.getKey().charAt(0);
            min = Math.min(min, c);
            max = Math.max(max, c);
        }
        this.offset = min;
        this.constructors = new Constructor[max - this.offset + 1];
        for (Map.Entry<String, Class<? extends Data>> entry : dataClasses.entrySet()) {
            char typeCode = entry.getKey().charAt(0);
            Class<? extends Data> clazz = entry.getValue();
            try {
                Constructor<? extends Data> constructor = clazz.getConstructor(new Class[0]);
                this.constructors[typeCode - this.offset] = constructor;
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new XltException("Could not determine default constructor of class " + clazz.getName(), e);
            }
        }
    }

    public Data createStatistics(XltCharBuffer src) throws Exception {
        Constructor<? extends Data> c = this.constructors[src.charAt(0) - this.offset];
        Data data = c.newInstance(new Object[0]);
        return data;
    }
}

