/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report;

import com.xceptance.common.util.CsvLineDecoder;
import com.xceptance.xlt.api.engine.ActionData;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.PageLoadTimingData;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.engine.TransactionData;
import com.xceptance.xlt.api.report.PostProcessedDataContainer;
import com.xceptance.xlt.api.util.SimpleArrayList;
import com.xceptance.xlt.api.util.XltCharBuffer;
import com.xceptance.xlt.report.DataChunk;
import com.xceptance.xlt.report.DataRecordFactory;
import com.xceptance.xlt.report.Dispatcher;
import com.xceptance.xlt.report.ReportGeneratorConfiguration;
import com.xceptance.xlt.report.mergerules.MergeRule;
import com.xceptance.xlt.report.mergerules.MergeRuleProcessor;
import com.zaxxer.sparsebits.SparseBitSet;
import it.unimi.dsi.util.FastRandom;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileObject;

class DataParserThread
implements Runnable {
    private static final Log LOG = LogFactory.getLog(DataParserThread.class);
    private static final Pattern WD_TIMER_NAME_PATTERN = Pattern.compile("page_\\d+");
    private final DataRecordFactory dataRecordFactory;
    private final Dispatcher dispatcher;
    private final long fromTime;
    private final long toTime;
    private final ReportGeneratorConfiguration config;
    private final List<MergeRule> mergeRules;

    public DataParserThread(Dispatcher dispatcher, DataRecordFactory dataRecordFactory, long fromTime, long toTime, ReportGeneratorConfiguration config) {
        this.dataRecordFactory = dataRecordFactory;
        this.fromTime = fromTime;
        this.toTime = toTime;
        this.dispatcher = dispatcher;
        this.config = config;
        this.mergeRules = config.getMergeRules();
    }

    @Override
    public void run() {
        double SAMPLELIMIT = 1.0 / (double)this.config.dataSampleFactor;
        int SAMPLEFACTOR = this.config.dataSampleFactor;
        FastRandom random = new FastRandom(98765111L);
        SparseBitSet allTimeIndex = new SparseBitSet();
        SparseBitSet actionTimeIndex = new SparseBitSet();
        SimpleArrayList<XltCharBuffer> csvParseResultBuffer = new SimpleArrayList<XltCharBuffer>(50);
        MergeRuleProcessor requestProcessing = new MergeRuleProcessor(this.mergeRules, this.config.getRemoveIndexesFromRequestNames());
        try {
            while (true) {
                DataChunk chunk = this.dispatcher.retrieveReadData();
                List<XltCharBuffer> lines = chunk.getLines();
                String agentName = chunk.getAgentName();
                String testCaseName = chunk.getTestCaseName();
                String userNumber = chunk.getUserNumber();
                boolean collectActionNames = chunk.getCollectActionNames();
                boolean adjustTimerName = chunk.getAdjustTimerNames();
                FileObject file = chunk.getFile();
                long _fromTime = this.fromTime;
                long _toTime = this.toTime;
                int droppedLines = 0;
                PostProcessedDataContainer postProcessedData = new PostProcessedDataContainer(lines.size(), SAMPLEFACTOR);
                int lineNumber = chunk.getBaseLineNumber();
                int size = lines.size();
                for (int i = 0; i < size; ++i) {
                    Data data = null;
                    try {
                        XltCharBuffer line = lines.get(i);
                        csvParseResultBuffer.clear();
                        CsvLineDecoder.parse(csvParseResultBuffer, line);
                        data = this.dataRecordFactory.createStatistics(line);
                        data.setBaseValues(csvParseResultBuffer);
                        long time = data.getTime();
                        if (time < _fromTime || time > _toTime) continue;
                        if (SAMPLEFACTOR > 1 && !(data instanceof TransactionData)) {
                            int sec;
                            SparseBitSet timeIndex = data instanceof ActionData ? actionTimeIndex : allTimeIndex;
                            if (timeIndex.get(sec = (int)((double)data.getTime() * 0.001))) {
                                if (random.nextDoubleFast() > SAMPLELIMIT) {
                                    ++droppedLines;
                                    continue;
                                }
                            } else {
                                timeIndex.set(sec);
                            }
                        }
                        data.setRemainingValues(csvParseResultBuffer);
                    }
                    catch (Exception ex) {
                        String msg = String.format("Failed to parse data record at line %,d in file '%s': %s\nLine is: ", lineNumber, file, ex, lines.get(i).toString());
                        LOG.error((Object)msg, (Throwable)ex);
                        continue;
                    }
                    data.setAgentName(agentName);
                    data.setTransactionName(testCaseName);
                    data = this.applyDataAdjustments(data, userNumber, collectActionNames, chunk, adjustTimerName);
                    if (data instanceof RequestData) {
                        RequestData result = requestProcessing.postprocess((RequestData)data);
                        if (result != null) {
                            postProcessedData.add(result);
                        }
                    } else {
                        data.getName().hashCode();
                        postProcessedData.add(data);
                    }
                    ++lineNumber;
                }
                postProcessedData.droppedLines = droppedLines;
                this.dispatcher.addPostprocessedData(postProcessedData);
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    private Data applyDataAdjustments(Data data, String userNumber, boolean collectActionNames, DataChunk lineChunk, boolean adjustTimerName) {
        if (data instanceof TransactionData) {
            TransactionData td = (TransactionData)data;
            td.setTestUserNumber(userNumber);
        } else if (collectActionNames && data instanceof ActionData) {
            lineChunk.getActionNames().put(data.getTime(), data.getName());
        } else if (adjustTimerName && (data instanceof RequestData || data instanceof PageLoadTimingData)) {
            Map.Entry<Long, String> entry = lineChunk.getActionNames().floorEntry(data.getTime());
            String actionName = entry != null ? entry.getValue() : "UnknownAction";
            Matcher m = WD_TIMER_NAME_PATTERN.matcher(data.getName());
            data.setName(m.replaceFirst(actionName));
        }
        return data;
    }
}

