/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.mastercontroller;

import com.xceptance.common.util.AbsoluteOrRelativeNumber;
import com.xceptance.common.util.ParseUtils;
import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.mastercontroller.LoadFunctionUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.regex.Matcher;

public abstract class AbstractLoadFunctionParser {
    private static final String RE_RECORD_SEP = "[,;\\s]*";
    private static final String RE_TIME = "[^/]+";
    private static final String RE_FIELD_SEP = "[/\\s]+";
    private static final String RE_VALUE = "([+-]\\s*)?[^,;\\s]+";

    public int[][] parse(String loadFunction) throws ParseException {
        ArrayList<int[]> pairs = new ArrayList<int[]>();
        Matcher recordSeparatorMatcher = RegExUtils.getPattern(RE_RECORD_SEP).matcher(loadFunction);
        Matcher timeMatcher = RegExUtils.getPattern(RE_TIME).matcher(loadFunction);
        Matcher fieldSeparatorMatcher = RegExUtils.getPattern(RE_FIELD_SEP).matcher(loadFunction);
        Matcher valueMatcher = RegExUtils.getPattern(RE_VALUE).matcher(loadFunction);
        int l = loadFunction.length();
        int i = 0;
        while (!(i >= l || recordSeparatorMatcher.find(i) && recordSeparatorMatcher.start() == i && (i = recordSeparatorMatcher.end()) == l)) {
            if (!timeMatcher.find(i) || timeMatcher.start() != i) {
                throw new ParseException("Expected a time at index " + i, i);
            }
            i = timeMatcher.end();
            AbsoluteOrRelativeNumber<Integer> time = ParseUtils.parseAbsoluteOrRelative(ParseUtils::parseTimePeriod, timeMatcher.group());
            if (!fieldSeparatorMatcher.find(i) || fieldSeparatorMatcher.start() != i) {
                throw new ParseException("Expected a '/' at index " + i, i);
            }
            i = fieldSeparatorMatcher.end();
            if (valueMatcher.find(i) && valueMatcher.start() == i) {
                i = valueMatcher.end();
                AbsoluteOrRelativeNumber<Integer> value = ParseUtils.parseAbsoluteOrRelative(this::parseValue, valueMatcher.group());
                if (pairs.isEmpty() && !LoadFunctionUtils.isValidStartingPoint(time, value)) {
                    pairs.add(new int[]{0, 1});
                }
                int effectiveTime = time.isRelativeNumber() ? ((int[])pairs.getLast())[0] + time.getValue() : time.getValue();
                int effectiveValue = value.isRelativeNumber() ? ((int[])pairs.getLast())[1] + value.getValue() : value.getValue();
                pairs.add(new int[]{effectiveTime, effectiveValue});
                continue;
            }
            throw new ParseException("Expected a value at index " + i, i);
        }
        int size = pairs.size();
        if (size == 0) {
            throw new IllegalArgumentException("The load function must specify at least one time/value pair.");
        }
        int[][] result = (int[][])pairs.toArray((T[])new int[size][]);
        return result;
    }

    abstract int parseValue(String var1) throws ParseException;
}

