/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.gce;

import com.google.cloud.compute.v1.Instance;
import com.google.cloud.compute.v1.InstanceGroup;
import com.google.cloud.compute.v1.Region;
import com.xceptance.common.util.ConsoleUiUtils;
import com.xceptance.xlt.gce.GceAdminUtils;
import com.xceptance.xlt.gce.GceClient;
import com.xceptance.xlt.gce.MachineInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class OpDeleteInstanceGroup {
    private final GceClient gceClient;

    OpDeleteInstanceGroup(GceClient gceClient) {
        this.gceClient = gceClient;
    }

    void execute() throws IOException {
        List<Region> regions = this.gceClient.getRegions();
        List<Region> selectedRegions = GceAdminUtils.multiSelectRegions(regions);
        System.out.println();
        List<InstanceGroup> instanceGroups = this.getInstanceGroupsInRegions(selectedRegions);
        System.out.println();
        if (instanceGroups.isEmpty()) {
            System.out.println("No managed instance groups found.");
        } else {
            List<InstanceGroup> selectedInstanceGroups = GceAdminUtils.multiSelectInstanceGroups(instanceGroups);
            System.out.print("\nYou selected to terminate ");
            if (selectedInstanceGroups.size() == instanceGroups.size()) {
                System.out.print("*all* ");
            }
            this.listInstanceDetails(selectedInstanceGroups);
            if (ConsoleUiUtils.confirm("\nAre you sure?")) {
                System.out.println();
                selectedInstanceGroups.forEach(this::deleteInstanceGroup);
            }
        }
    }

    private void listInstanceDetails(List<InstanceGroup> groups) {
        StringBuilder sb = new StringBuilder();
        String indentStr = StringUtils.repeat((char)' ', (int)2);
        String indent2Str = StringUtils.repeat((char)' ', (int)4);
        int groupSize = groups.size();
        sb.append("managed instances of group");
        if (groupSize == 1) {
            sb.append(" '").append(groups.get(0).getName()).append("'\n");
        } else {
            sb.append("s\n");
            for (InstanceGroup instanceGroup : groups) {
                sb.append(indent2Str).append(instanceGroup.getName()).append('\n');
            }
        }
        sb.append('\n').append(indentStr);
        HashMap<String, LinkedList<InstanceGroup>> groupsPerRegion = new HashMap<String, LinkedList<InstanceGroup>>();
        for (InstanceGroup group : groups) {
            String regionOfGroup = OpDeleteInstanceGroup.getRegionName(group);
            LinkedList<InstanceGroup> groupsOfRegion = (LinkedList<InstanceGroup>)groupsPerRegion.get(regionOfGroup);
            if (groupsOfRegion == null) {
                groupsOfRegion = new LinkedList<InstanceGroup>();
                groupsPerRegion.put(regionOfGroup, groupsOfRegion);
            }
            groupsOfRegion.add(group);
        }
        sb.append("in region");
        if (groupsPerRegion.size() > 1) {
            sb.append("s:\n");
        } else {
            sb.append(": ");
        }
        System.out.print(sb.toString());
        if (groupsPerRegion.size() == 1) {
            String string = OpDeleteInstanceGroup.getRegionName(groups.get(0));
            System.out.printf("%s ... ", string);
            try {
                String s = this.prettyPrintInstances(groups, indent2Str, true);
                System.out.println("OK\n");
                System.out.println(s);
            }
            catch (Exception e) {
                System.out.println("Failed: " + e.getMessage());
            }
        } else {
            for (Map.Entry entry : groupsPerRegion.entrySet()) {
                System.out.printf("\n%s%s ... ", indentStr, entry.getKey());
                try {
                    String s = this.prettyPrintInstances((List)entry.getValue(), indent2Str, true);
                    System.out.println("OK\n");
                    System.out.println(s);
                }
                catch (Exception e) {
                    System.out.println("Failed: " + e.getMessage());
                }
            }
        }
    }

    private String prettyPrintInstances(List<InstanceGroup> groups, String lineOffset, boolean excludeStopped) throws Exception {
        StringBuilder output = new StringBuilder();
        int pendingInstanceCount = 0;
        int runningInstanceCount = 0;
        int stoppedInstanceCount = 0;
        LinkedList<MachineInfo> runningMachines = new LinkedList<MachineInfo>();
        for (InstanceGroup group : groups) {
            for (Instance instance : this.gceClient.getInstancesInGroup(group)) {
                String state = StringUtils.defaultString((String)instance.getStatus());
                if (state.equals("RUNNING")) {
                    ++runningInstanceCount;
                } else if (state.equals("PROVISIONING")) {
                    ++pendingInstanceCount;
                } else {
                    if (!state.equals("STOPPED") && !state.equals("STOPPING") || excludeStopped) continue;
                    ++stoppedInstanceCount;
                }
                MachineInfo currentMachineInfo = MachineInfo.createMachineInfo(instance);
                runningMachines.add(currentMachineInfo);
            }
        }
        output.append(lineOffset);
        if (runningInstanceCount + pendingInstanceCount + stoppedInstanceCount > 0) {
            if (excludeStopped) {
                output.append(String.format("%d running and %d pending instance(s) found.\n", runningInstanceCount, pendingInstanceCount));
            } else {
                output.append(String.format("%d running, %d pending and %d stopped instance(s) found.\n", runningInstanceCount, pendingInstanceCount, stoppedInstanceCount));
            }
            output.append(MachineInfo.Printer.prettyPrint(runningMachines, lineOffset));
        } else if (excludeStopped) {
            output.append("No running or pending instance(s) found.\n");
        } else {
            output.append("No running, pending or stopped instance(s) found.\n");
        }
        return output.toString();
    }

    private List<InstanceGroup> getInstanceGroupsInRegions(List<Region> regions) throws IOException {
        ArrayList<InstanceGroup> allInstanceGroups = new ArrayList<InstanceGroup>();
        for (Region region : regions) {
            System.out.printf("Retrieving all managed instance groups in region '%s' ... ", region.getName());
            List<InstanceGroup> instanceGroups = this.gceClient.getAllInstanceGroups(region);
            System.out.println("OK");
            allInstanceGroups.addAll(instanceGroups);
        }
        return allInstanceGroups;
    }

    private void deleteInstanceGroup(InstanceGroup instanceGroup) {
        try {
            System.out.printf("Deleting instance group '%s' ... ", instanceGroup.getName());
            this.gceClient.deleteInstanceGroup(instanceGroup);
            System.out.println("OK");
        }
        catch (Exception e) {
            GceAdminUtils.logError(String.format("Failed to delete instance group '%s'", instanceGroup.getName()), e);
        }
    }

    private static String getRegionName(InstanceGroup group) {
        String s = GceAdminUtils.getRegionName(group.getRegion());
        if (s == null) {
            s = StringUtils.substringBeforeLast((String)GceAdminUtils.getZoneName(group.getZone()), (String)"-");
        }
        return StringUtils.defaultString((String)s, (String)"<unknown region>");
    }
}

