/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.gce;

import com.google.cloud.compute.v1.Instance;
import com.xceptance.xlt.gce.GceAdminUtils;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

class MachineInfo {
    private static final DateTimeFormatter TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm").toFormatter();
    private final String host;
    private final String launchTime;
    private final String name;
    private final String type;
    private final long runtime;
    private final String upTime;
    private final String state;

    private MachineInfo(String name, String host, String launchTime, long runtime, String type, String state) {
        this.name = name;
        this.host = host;
        this.launchTime = launchTime;
        this.runtime = runtime;
        this.type = type;
        this.state = state;
        this.upTime = MachineInfo.getUptimeStr(runtime);
    }

    public String getHost() {
        return this.host;
    }

    public String getLaunchTime() {
        return this.launchTime;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public long getRuntime() {
        return this.runtime;
    }

    public String getUpTime() {
        return this.upTime;
    }

    public String getState() {
        return this.state;
    }

    static MachineInfo createMachineInfo(Instance instance) {
        String name = instance.getName();
        String address = GceAdminUtils.getIpAddress(instance);
        OffsetDateTime oTime = OffsetDateTime.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(instance.getCreationTimestamp()));
        Duration diffToNow = Duration.between(oTime, OffsetDateTime.now());
        long runtime = diffToNow.toMinutes();
        return new MachineInfo(name, address, oTime.withOffsetSameInstant(ZoneOffset.of("Z")).format(TIME_FORMATTER), runtime, GceAdminUtils.getMachineType(instance.getMachineType()), instance.getStatus());
    }

    private static String getUptimeStr(long runtimeInMinutes) {
        StringBuilder sb = new StringBuilder();
        if (runtimeInMinutes > 0L) {
            long min = runtimeInMinutes % 60L;
            long hrs = runtimeInMinutes / 60L;
            long days = hrs / 24L;
            hrs %= 24L;
            if (days > 0L) {
                sb.append(days).append("d ");
            }
            if (hrs < 10L) {
                sb.append(0);
            }
            sb.append(hrs).append(":");
            if (min < 10L) {
                sb.append(0);
            }
            sb.append(min);
        }
        return sb.toString();
    }

    static class Printer {
        Printer() {
        }

        static String prettyPrint(List<MachineInfo> machineInformation, String offset) {
            StringBuilder sb = new StringBuilder();
            String nameHeading = "Name";
            String hostHeading = "Host";
            String typeHeading = "Type";
            String stateHeading = "State";
            String startTimeHeading = "Launch Time (UTC)";
            String uptimeHeading = "Uptime (h:mm)";
            int maxName = "Host".length();
            int maxHost = "Name".length();
            int maxType = "Type".length();
            int maxState = "State".length();
            int maxStartTime = "Launch Time (UTC)".length();
            int maxUptime = "Uptime (h:mm)".length();
            ArrayList<MachineInfo> machinesSortedByUptime = new ArrayList<MachineInfo>();
            for (MachineInfo info : machineInformation) {
                maxHost = Math.max(maxHost, info.getHost().length());
                maxName = Math.max(maxName, info.getName().length());
                maxStartTime = Math.max(maxStartTime, info.getLaunchTime().length());
                maxUptime = Math.max(maxUptime, info.getUpTime().length());
                maxType = Math.max(maxType, info.getType().length());
                maxState = Math.max(maxState, info.getState().length());
                machinesSortedByUptime.add(info);
            }
            Collections.sort(machinesSortedByUptime, new Comparator<MachineInfo>(){

                @Override
                public int compare(MachineInfo o1, MachineInfo o2) {
                    return Long.compare(o2.getRuntime(), o1.getRuntime());
                }
            });
            String colSep = " | ";
            int maxLineLength = maxHost + maxName + maxStartTime + maxUptime + maxType + maxState + 5 * " | ".length();
            String dashLine = offset + StringUtils.repeat((char)'-', (int)maxLineLength) + "\n";
            sb.append(dashLine);
            sb.append(offset).append(StringUtils.center((String)"Name", (int)maxName)).append(" | ").append(StringUtils.center((String)"Host", (int)maxHost)).append(" | ").append(StringUtils.center((String)"Type", (int)maxType)).append(" | ").append(StringUtils.center((String)"State", (int)maxState)).append(" | ").append(StringUtils.center((String)"Launch Time (UTC)", (int)maxStartTime)).append(" | ").append(StringUtils.center((String)"Uptime (h:mm)", (int)maxUptime)).append('\n');
            sb.append(dashLine);
            String lineFormat = String.format("%s%%-%ds | %%-%ds | %%-%ds | %%-%ds | %%%ds | %%%ds\n", offset, maxName, maxHost, maxType, maxState, maxStartTime, maxUptime);
            for (MachineInfo info : machinesSortedByUptime) {
                sb.append(String.format(lineFormat, info.getName(), info.getHost(), info.getType(), info.getState(), info.getLaunchTime(), info.getUpTime()));
            }
            sb.append(dashLine);
            return sb.toString();
        }
    }
}

