/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.gce;

import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.compute.v1.Instance;
import com.google.cloud.compute.v1.InstanceGroup;
import com.google.cloud.compute.v1.InstanceGroupManager;
import com.google.cloud.compute.v1.InstanceGroupManagersClient;
import com.google.cloud.compute.v1.InstanceGroupsClient;
import com.google.cloud.compute.v1.InstanceGroupsListInstancesRequest;
import com.google.cloud.compute.v1.InstanceTemplate;
import com.google.cloud.compute.v1.InstanceTemplatesClient;
import com.google.cloud.compute.v1.InstanceWithNamedPorts;
import com.google.cloud.compute.v1.InstancesClient;
import com.google.cloud.compute.v1.ManagedInstance;
import com.google.cloud.compute.v1.Region;
import com.google.cloud.compute.v1.RegionInstanceGroupManagersClient;
import com.google.cloud.compute.v1.RegionInstanceGroupsClient;
import com.google.cloud.compute.v1.RegionInstanceGroupsListInstancesRequest;
import com.google.cloud.compute.v1.RegionsClient;
import com.google.common.collect.Lists;
import com.xceptance.common.lang.ThreadUtils;
import com.xceptance.xlt.gce.GceAdminUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

class GceClient {
    private static final String STATE_RUNNING = "RUNNING";
    private static final long INSTANCE_STATE_POLLING_INTERVAL = 1000L;
    private final RegionsClient regionsClient;
    private final InstancesClient instancesClient;
    private final InstanceTemplatesClient instanceTemplatesClient;
    private final InstanceGroupManagersClient instanceGroupManagersClient;
    private final RegionInstanceGroupManagersClient regionInstanceGroupManagersClient;
    private final InstanceGroupsClient instanceGroupsClient;
    private final RegionInstanceGroupsClient regionInstanceGroupsClient;
    private final String projectId;
    private final long instanceConnectTimeout;
    private final List<Region> regions;
    private final Map<String, Region> regionsByName;

    GceClient(String projectId, long instanceConnectTimeout) throws ApiException, IOException {
        this.projectId = projectId;
        this.instanceConnectTimeout = Math.max(instanceConnectTimeout, 0L);
        this.regionsClient = RegionsClient.create();
        this.instanceTemplatesClient = InstanceTemplatesClient.create();
        this.instancesClient = InstancesClient.create();
        this.instanceGroupsClient = InstanceGroupsClient.create();
        this.instanceGroupManagersClient = InstanceGroupManagersClient.create();
        this.regionInstanceGroupsClient = RegionInstanceGroupsClient.create();
        this.regionInstanceGroupManagersClient = RegionInstanceGroupManagersClient.create();
        this.regionsByName = this.loadRegions();
        this.regions = new ArrayList<Region>(this.regionsByName.values());
    }

    private Map<String, Region> loadRegions() throws ApiException {
        TreeMap<String, Region> regions = new TreeMap<String, Region>();
        RegionsClient.ListPagedResponse response = this.regionsClient.list(this.projectId);
        for (Region region : response.iterateAll()) {
            regions.put(region.getName(), region);
        }
        return regions;
    }

    List<Region> getRegions() {
        return this.regions;
    }

    Region getRegion(String regionName) {
        Region region = this.regionsByName.get(regionName);
        if (region == null) {
            throw new IllegalArgumentException("Unknown region: " + regionName);
        }
        return region;
    }

    void createInstanceGroup(String regionName, String instanceGroupName, String instanceTemplateName, int instanceCount) throws ApiException, InterruptedException, ExecutionException {
        InstanceGroupManager.Builder instanceGroupManagerBuilder = InstanceGroupManager.newBuilder();
        instanceGroupManagerBuilder.setBaseInstanceName(instanceGroupName);
        instanceGroupManagerBuilder.setName(instanceGroupName);
        instanceGroupManagerBuilder.setInstanceTemplate("global/instanceTemplates/" + instanceTemplateName);
        instanceGroupManagerBuilder.setTargetSize(instanceCount);
        this.regionInstanceGroupManagersClient.insertAsync(this.projectId, regionName, instanceGroupManagerBuilder.build()).get();
    }

    List<Instance> waitForInstancesAreRunning(String regionName, String instanceGroupName, int instanceCount) throws ApiException, TimeoutException {
        long timeout = this.instanceConnectTimeout;
        long deadline = System.currentTimeMillis() + timeout;
        List<Instance> instances = this.waitForInstancesToExist(regionName, instanceGroupName, instanceCount, timeout);
        long remainingTimeout = deadline - System.currentTimeMillis();
        instances = this.waitForInstanceState(instances, STATE_RUNNING, remainingTimeout);
        return instances;
    }

    List<Instance> waitForInstancesToExist(String regionName, String instanceGroupName, int instanceCount, long timeout) throws ApiException, TimeoutException {
        long deadline = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < deadline) {
            List<ManagedInstance> managedInstances = this.getManagedInstances(regionName, instanceGroupName);
            if (managedInstances != null && managedInstances.size() == instanceCount) {
                boolean ok = true;
                for (ManagedInstance managedInstance : managedInstances) {
                    String status = managedInstance.getInstanceStatus();
                    if (status != null && !status.isEmpty()) continue;
                    ok = false;
                    break;
                }
                if (ok) {
                    return this.getInstances(managedInstances);
                }
            }
            ThreadUtils.sleep(1000L);
        }
        throw new TimeoutException(String.format("One or more of the %d instances did not exist within %d seconds", instanceCount, timeout));
    }

    private List<ManagedInstance> getManagedInstances(String regionName, String instanceGroupName) throws ApiException {
        return Lists.newArrayList((Iterable)this.regionInstanceGroupManagersClient.listManagedInstances(this.projectId, regionName, instanceGroupName).iterateAll());
    }

    private List<Instance> getInstances(List<ManagedInstance> managedInstances) throws ApiException {
        ArrayList<Instance> instances = new ArrayList<Instance>();
        for (ManagedInstance managedInstance : managedInstances) {
            instances.add(this.getInstance(managedInstance));
        }
        return instances;
    }

    private Instance getInstance(ManagedInstance managedInstance) throws ApiException {
        String zoneName = GceAdminUtils.getZoneName(managedInstance.getInstance());
        String instanceName = GceAdminUtils.getInstanceName(managedInstance.getInstance());
        return this.instancesClient.get(this.projectId, zoneName, instanceName);
    }

    List<Instance> waitForInstanceState(List<Instance> instances, String state, long timeout) throws ApiException, TimeoutException {
        ArrayList<Instance> updatedInstances = new ArrayList<Instance>();
        long deadline = System.currentTimeMillis() + timeout;
        for (Instance instance : instances) {
            long remainingTimeout = deadline - System.currentTimeMillis();
            Instance updatedInstance = this.waitForInstanceState(instance, state, remainingTimeout);
            updatedInstances.add(updatedInstance);
        }
        return updatedInstances;
    }

    Instance waitForInstanceState(Instance instance, String state, long timeout) throws ApiException, TimeoutException {
        long deadline = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < deadline) {
            if ((instance = this.getInstance(instance.getSelfLink())) != null && instance.getStatus().equals(state)) {
                return instance;
            }
            ThreadUtils.sleep(1000L);
        }
        throw new TimeoutException(String.format("Instance '%s' did not reach state '%s' within %d seconds. Current state is '%s'.", instance.getName(), state, timeout / 1000L, instance.getStatus()));
    }

    Instance getInstance(String instanceUrl) throws ApiException {
        String zoneName = GceAdminUtils.getZoneName(instanceUrl);
        String instanceName = GceAdminUtils.getInstanceName(instanceUrl);
        return this.instancesClient.get(this.projectId, zoneName, instanceName);
    }

    List<InstanceTemplate> getInstanceTemplates() throws ApiException {
        ArrayList instanceTemplates = Lists.newArrayList((Iterable)this.instanceTemplatesClient.list(this.projectId).iterateAll());
        Collections.sort(instanceTemplates, new Comparator<InstanceTemplate>(this){

            @Override
            public int compare(InstanceTemplate t1, InstanceTemplate t2) {
                String s1 = StringUtils.defaultString((String)t1.getName());
                String s2 = StringUtils.defaultString((String)t2.getName());
                return s1.compareTo(s2);
            }
        });
        return instanceTemplates;
    }

    InstanceGroup getInstanceGroup(String regionOrZoneName, String instanceGroupName) throws ApiException {
        if (this.regionsByName.containsKey(regionOrZoneName)) {
            try {
                return this.regionInstanceGroupsClient.get(this.projectId, regionOrZoneName, instanceGroupName);
            }
            catch (ApiException ex) {
                if (GceClient.isNotFound(ex)) {
                    for (String zone : this.getZoneNamesFromRegion(this.getRegion(regionOrZoneName))) {
                        InstanceGroup group = this.instanceGroupsClient.get(this.projectId, zone, instanceGroupName);
                        if (group == null) continue;
                        return group;
                    }
                }
                throw ex;
            }
        }
        return this.instanceGroupsClient.get(this.projectId, regionOrZoneName, instanceGroupName);
    }

    List<InstanceGroup> getAllInstanceGroups(Region region) throws ApiException {
        ArrayList<InstanceGroup> groupList = new ArrayList<InstanceGroup>();
        String regionName = region.getName();
        groupList.addAll(this.getMultiZoneInstanceGroups(regionName));
        List<String> zoneNames = this.getZoneNamesFromRegion(region);
        for (String zoneName : zoneNames) {
            groupList.addAll(this.getSingleZoneInstanceGroups(zoneName));
        }
        return groupList;
    }

    List<InstanceGroup> getMultiZoneInstanceGroups(String regionName) throws ApiException {
        return Lists.newArrayList((Iterable)this.regionInstanceGroupsClient.list(this.projectId, regionName).iterateAll());
    }

    List<InstanceGroup> getSingleZoneInstanceGroups(String zoneName) throws ApiException {
        return Lists.newArrayList((Iterable)this.instanceGroupsClient.list(this.projectId, zoneName).iterateAll());
    }

    List<Instance> getInstancesInRegion(Region region) throws ApiException {
        ArrayList<Instance> instances = new ArrayList<Instance>();
        List<String> zoneNames = this.getZoneNamesFromRegion(region);
        for (String zoneName : zoneNames) {
            instances.addAll(this.getInstancesInZone(zoneName));
        }
        return instances;
    }

    private List<String> getZoneNamesFromRegion(Region region) {
        Object zones = region.getZonesList();
        if (zones != null) {
            zones = zones.stream().map(GceAdminUtils::getZoneName).collect(Collectors.toList());
        }
        return zones;
    }

    List<Instance> getInstancesInZone(String zoneName) throws ApiException {
        return Lists.newArrayList((Iterable)this.instancesClient.list(this.projectId, zoneName).iterateAll());
    }

    List<Instance> getInstancesInGroup(InstanceGroup instanceGroup) throws ApiException {
        ArrayList<Instance> instances;
        block3: {
            String groupName;
            block2: {
                instances = new ArrayList<Instance>();
                groupName = instanceGroup.getName();
                if (!instanceGroup.getSelfLink().contains("regions")) break block2;
                String regionName = GceAdminUtils.getRegionName(instanceGroup.getRegion());
                RegionInstanceGroupsListInstancesRequest request = RegionInstanceGroupsListInstancesRequest.newBuilder().build();
                Iterable instancesWithNamedPorts = this.regionInstanceGroupsClient.listInstances(this.projectId, regionName, groupName, request).iterateAll();
                for (InstanceWithNamedPorts instanceWithNamedPorts : instancesWithNamedPorts) {
                    String instanceUrl = instanceWithNamedPorts.getInstance();
                    String zoneName = GceAdminUtils.getZoneName(instanceUrl);
                    String instanceName = GceAdminUtils.getInstanceName(instanceUrl);
                    Instance instance = this.instancesClient.get(this.projectId, zoneName, instanceName);
                    instances.add(instance);
                }
                break block3;
            }
            if (!instanceGroup.getSelfLink().contains("zones")) break block3;
            String zoneName = GceAdminUtils.getZoneName(instanceGroup.getZone());
            InstanceGroupsListInstancesRequest request = InstanceGroupsListInstancesRequest.newBuilder().build();
            Iterable instancesWithNamedPorts = this.instanceGroupsClient.listInstances(this.projectId, zoneName, groupName, request).iterateAll();
            for (InstanceWithNamedPorts instanceWithNamedPorts : instancesWithNamedPorts) {
                String instanceUrl = instanceWithNamedPorts.getInstance();
                String instanceName = GceAdminUtils.getInstanceName(instanceUrl);
                Instance instance = this.instancesClient.get(this.projectId, zoneName, instanceName);
                instances.add(instance);
            }
        }
        return instances;
    }

    void deleteInstanceGroup(InstanceGroup instanceGroup) throws ApiException, InterruptedException, ExecutionException {
        String regionUrl = instanceGroup.getRegion();
        if (regionUrl != null) {
            String regionName = GceAdminUtils.getRegionName(regionUrl);
            this.regionInstanceGroupManagersClient.deleteAsync(this.projectId, regionName, instanceGroup.getName()).get();
        } else {
            String zoneName = GceAdminUtils.getZoneName(instanceGroup.getZone());
            this.instanceGroupManagersClient.deleteAsync(this.projectId, zoneName, instanceGroup.getName()).get();
        }
    }

    private static boolean isNotFound(ApiException ex) {
        return ex.getStatusCode().getCode() == StatusCode.Code.NOT_FOUND;
    }
}

