/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.xltdriver;

import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.SessionImpl;
import com.xceptance.xlt.engine.WebDriverActionDirector;
import com.xceptance.xlt.engine.XltWebClient;
import com.xceptance.xlt.engine.resultbrowser.RequestHistory;
import org.htmlunit.BrowserVersion;
import org.htmlunit.Page;
import org.htmlunit.html.HtmlPage;

public class WebDriverXltWebClient
extends XltWebClient {
    private static final long serialVersionUID = 1L;
    private static final String WAITINGTIME_PROPERTY = "com.xceptance.xlt.js.backgroundActivity.waitingTime";
    private final long waitingTime;
    private boolean quit = false;

    public WebDriverXltWebClient(BrowserVersion browserVersion) {
        super(browserVersion);
        this.setTimerName("UnsetTimerName");
        this.waitingTime = XltProperties.getInstance().getProperty(WAITINGTIME_PROPERTY, -1);
        Session.getCurrent().removeShutdownListener(this);
        XltDriverActionDirector actionDirector = new XltDriverActionDirector();
        ((SessionImpl)Session.getCurrent()).setWebDriverActionDirector(actionDirector);
    }

    public void quit() {
        if (!this.quit) {
            this.quit = true;
            this.shutdown();
        }
    }

    public boolean isQuit() {
        return this.quit;
    }

    private void finishPotentialPageLoad(boolean waitForBackgroundJSJobs) {
        SessionImpl session = SessionImpl.getCurrent();
        session.checkState();
        Page page = this.getCurrentWindow().getTopWindow().getEnclosedPage();
        if (waitForBackgroundJSJobs) {
            this.waitForBackgroundThreads(page, this.waitingTime);
            page = this.getCurrentWindow().getTopWindow().getEnclosedPage();
        }
        HtmlPage htmlPage = null;
        if (page instanceof HtmlPage) {
            htmlPage = (HtmlPage)page;
            this.loadNewStaticContent(htmlPage);
        }
    }

    private void dumpCurrentPage() {
        SessionImpl session = SessionImpl.getCurrent();
        RequestHistory requestHistory = session.getRequestHistory();
        String timerName = this.getTimerName();
        Page page = this.getCurrentWindow().getTopWindow().getEnclosedPage();
        if (page instanceof HtmlPage) {
            requestHistory.add(timerName, (HtmlPage)page);
        } else {
            requestHistory.add(timerName);
        }
        session.getNetworkDataManager().clear();
    }

    private final class XltDriverActionDirector
    extends WebDriverActionDirector {
        private XltDriverActionDirector() {
        }

        @Override
        protected void setTimerName(String timerName) {
            WebDriverXltWebClient.this.setTimerName(timerName);
        }

        @Override
        protected void doWaitForPageLoad() {
            if (!WebDriverXltWebClient.this.isQuit()) {
                WebDriverXltWebClient.this.finishPotentialPageLoad(true);
            }
        }

        @Override
        protected void takeScreenshot() {
            WebDriverXltWebClient.this.dumpCurrentPage();
        }

        @Override
        protected void preQuit() {
        }
    }
}

