/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.socket;

import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.util.XltException;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.socket.InstrumentedSocketImplFactory;
import java.net.Socket;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XltSockets {
    private static final Logger LOG = LoggerFactory.getLogger(XltSockets.class);
    private static final String PROP_COLLECT_NETWORK_DATA = "com.xceptance.xlt.socket.collectNetworkData";

    public static void initialize() {
    }

    private XltSockets() {
    }

    static {
        if (XltProperties.getInstance().getProperty(PROP_COLLECT_NETWORK_DATA, true)) {
            try {
                Socket.setSocketImplFactory(new InstrumentedSocketImplFactory());
            }
            catch (Throwable ex) {
                if (Session.getCurrent().isLoadTest()) {
                    throw new XltException("Failed to initialize XLT sockets", ex);
                }
                LOG.warn("Failed to initialize XLT sockets: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)ex));
            }
        }
    }
}

