/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.webdriver;

import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.api.webdriver.XltDriver;
import com.xceptance.xlt.engine.TimeoutException;
import com.xceptance.xlt.engine.scripting.CookieConstants;
import com.xceptance.xlt.engine.scripting.PageLoadTimeoutException;
import com.xceptance.xlt.engine.scripting.TestContext;
import com.xceptance.xlt.engine.scripting.util.AbstractCommandAdapter;
import com.xceptance.xlt.engine.scripting.util.Condition;
import com.xceptance.xlt.engine.scripting.util.ReplayUtils;
import com.xceptance.xlt.engine.scripting.webdriver.WebDriverFinder;
import com.xceptance.xlt.engine.scripting.webdriver.WebDriverScriptCommands;
import com.xceptance.xlt.engine.scripting.webdriver.WebDriverScriptCommandsInvocationHandler;
import com.xceptance.xlt.engine.scripting.webdriver.WebDriverUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.util.UrlUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.Interactive;
import org.openqa.selenium.interactions.Locatable;

public final class WebDriverCommandAdapter
extends AbstractCommandAdapter
implements WebDriverScriptCommands {
    private static final String EVAL_SCRIPT = "var r = null; try { r = eval(arguments[0]); } catch(e){ throw new Error(String(e)) } return String(r)";
    private static final String PROP_SET_PAGE_LOAD_TIMEOUT = "com.xceptance.xlt.scripting.setPageLoadTimeoutAtDriver";
    private final WebDriverFinder finder = new WebDriverFinder();
    private final String originalWindowHandle;
    private final WebDriver webDriver;
    private final String baseUrl;
    private final boolean driverWaitsForPageLoad;
    private final boolean pageLoadTimeoutAtDriverEnabled;

    public static WebDriverScriptCommands createInstance(WebDriver webDriver, String baseUrl) {
        WebDriverCommandAdapter adapter = new WebDriverCommandAdapter(webDriver, baseUrl);
        WebDriverScriptCommandsInvocationHandler handler = new WebDriverScriptCommandsInvocationHandler(adapter, AbstractCommandAdapter.LOGGER);
        Class[] proxiedInterfaces = new Class[]{WebDriverScriptCommands.class};
        return (WebDriverScriptCommands)Proxy.newProxyInstance(WebDriverCommandAdapter.class.getClassLoader(), proxiedInterfaces, (InvocationHandler)handler);
    }

    private WebDriverCommandAdapter(WebDriver webDriver, String baseUrl) {
        this.webDriver = webDriver;
        this.baseUrl = baseUrl;
        this.originalWindowHandle = webDriver.getWindowHandle();
        this.driverWaitsForPageLoad = WebDriverCommandAdapter.isDriverWaitingForPageLoad(webDriver);
        if (!this.driverWaitsForPageLoad) {
            LOGGER.info("Driver will *not* wait for page loads, but the XLT scripting layer will");
        }
        this.pageLoadTimeoutAtDriverEnabled = XltProperties.getInstance().getProperty(PROP_SET_PAGE_LOAD_TIMEOUT, true);
        if (!this.pageLoadTimeoutAtDriverEnabled) {
            LOGGER.info("Script timeout will *not* be set as page load timeout at the driver");
        }
        this.setTimeout(TestContext.getDefaultTimeout());
    }

    @Override
    public WebDriver getUnderlyingWebDriver() {
        return this.webDriver;
    }

    @Override
    public WebElement findElement(String elementLocator) {
        return this.finder.findElement(this.webDriver, elementLocator);
    }

    @Override
    public List<WebElement> findElements(String elementLocator) {
        return this.finder.findElements(this.webDriver, elementLocator);
    }

    @Override
    public void addSelection(String selectLocator, String optionLocator) {
        this.checkElementLocator(selectLocator);
        WebElement select = this.finder.findElement(this.webDriver, selectLocator);
        this.checkIsEqual("Element '" + selectLocator + "' is not an HTML select element", "select", select.getTagName());
        this.checkIsTrue("Select '" + selectLocator + "' does not support multiple selection", this.isMultipleSelect(select));
        this.checkIsTrue("Select '" + selectLocator + "' is disabled", select.isEnabled());
        List<WebElement> options = this.finder.findOptions(select, optionLocator);
        for (WebElement option : options) {
            this.setSelected(select, option);
        }
    }

    @Override
    public void check(String elementLocator) {
        this.checkElementLocator(elementLocator);
        WebElement input = this.finder.findElement(this.webDriver, elementLocator);
        this.checkIsEqual("Element '" + elementLocator + "' is not a HTML input element", "input", input.getTagName());
        String typeAttribute = input.getAttribute("type");
        this.checkIsTrue("Check is only allowed on radio/checkbox input elements", typeAttribute.equals("radio") || typeAttribute.equals("checkbox"));
        this.checkIsTrue("Radio/checkbox '" + elementLocator + "' is disabled", input.isEnabled());
        WebDriverUtils.assumeOkOnAlertOrConfirm(this.webDriver);
        if (!input.isSelected()) {
            if (WebDriverUtils.isClickable(this.webDriver, input)) {
                input.click();
            } else {
                WebDriverUtils.setAttribute(this.webDriver, input, "checked", "true");
                WebDriverUtils.fireChangeEvent(this.webDriver, input);
            }
        }
    }

    @Override
    public void checkAndWait(String elementLocator) {
        this.executeCommandAndWait(() -> this.check(elementLocator));
    }

    @Override
    public void click(String elementLocator) {
        this.checkElementLocator(elementLocator);
        WebDriverUtils.assumeOkOnAlertOrConfirm(this.webDriver);
        WebElement e = this.finder.findElement(this.webDriver, elementLocator);
        if (WebDriverUtils.isClickable(this.webDriver, e)) {
            e.click();
        } else {
            WebDriverUtils.fireClickEvent(this.webDriver, e);
        }
    }

    @Override
    public void clickAndWait(String elementLocator) {
        this.executeCommandAndWait(() -> this.click(elementLocator));
    }

    @Override
    public void close() {
        this.webDriver.close();
    }

    @Override
    public void contextMenu(String elementLocator) {
        this.checkElementLocator(elementLocator);
        WebDriverUtils.assumeOkOnAlertOrConfirm(this.webDriver);
        WebElement element = this.finder.findElement(this.webDriver, elementLocator);
        this.checkIsTrue("Cannot interact with invisible elements", element.isDisplayed());
        new Actions(this.webDriver).contextClick(element).build().perform();
    }

    @Override
    public void contextMenuAt(String elementLocator, String coordinates) {
        int[] offset = ReplayUtils.parseCoordinates(coordinates);
        this.checkIsTrue("Invalid coordinates: " + coordinates, offset != null);
        this.contextMenuAt(elementLocator, offset[0], offset[1]);
    }

    @Override
    public void contextMenuAt(String elementLocator, int coordX, int coordY) {
        this.checkElementLocator(elementLocator);
        WebDriverUtils.assumeOkOnAlertOrConfirm(this.webDriver);
        WebElement element = this.finder.findElement(this.webDriver, elementLocator);
        this.checkIsTrue("Cannot interact with invisible elements", element.isDisplayed());
        new Actions(this.webDriver).moveToElement(element, coordX, coordY).contextClick().build().perform();
    }

    @Override
    public void createCookie(String cookie) {
        this.createCookie(cookie, "");
    }

    @Override
    public void createCookie(String cookie, String options) {
        Matcher m = CookieConstants.NAME_VALUE_PAIR_PATTERN.matcher(cookie);
        this.checkIsTrue("Invalid cookie string: " + cookie, m.matches());
        String cookieName = m.group(1);
        String cookieValue = m.group(2);
        Matcher maxAgeMatcher = CookieConstants.MAX_AGE_PATTERN.matcher(options);
        Date maxAge = maxAgeMatcher.find() ? new Date(System.currentTimeMillis() + (long)(Integer.parseInt(maxAgeMatcher.group(1)) * 1000)) : null;
        String path = null;
        Matcher pathMatcher = CookieConstants.PATH_PATTERN.matcher(options);
        if (pathMatcher.find()) {
            path = pathMatcher.group(1);
            try {
                if (path.startsWith("http")) {
                    path = new URL(path).getPath();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        Cookie cookie2 = new Cookie(cookieName, cookieValue, path, maxAge);
        this.webDriver.manage().addCookie(cookie2);
    }

    @Override
    public void deleteAllVisibleCookies() {
        this.webDriver.manage().deleteAllCookies();
    }

    @Override
    public void deleteCookie(String name) {
        this.deleteCookie(name, null);
    }

    @Override
    public void deleteCookie(String name, String options) {
        this.checkIsTrue("Invalid cookie name: " + name, CookieConstants.NAME_PATTERN.matcher(name).find());
        this.webDriver.manage().deleteCookieNamed(name);
    }

    @Override
    public void doubleClick(String elementLocator) {
        this.checkIsTrue("Current webdriver has no input devices: cannot double-click", this.webDriver instanceof Interactive);
        this.checkElementLocator(elementLocator);
        WebDriverUtils.assumeOkOnAlertOrConfirm(this.webDriver);
        WebElement e = this.finder.findElement(this.webDriver, elementLocator);
        this.checkIsTrue("Cannot double-click on element '" + elementLocator + "' since it is not locatable", e instanceof Locatable);
        new Actions(this.webDriver).doubleClick(e).perform();
    }

    @Override
    public void doubleClickAndWait(String elementLocator) {
        this.executeCommandAndWait(() -> this.doubleClick(elementLocator));
    }

    @Override
    public void mouseDown(String elementLocator) {
        this.checkElementLocator(elementLocator);
        WebElement element = this.finder.findElement(this.webDriver, elementLocator);
        this.checkIsTrue("Cannot interact with invisible elements", element.isDisplayed());
        new Actions(this.webDriver).clickAndHold(element).build().perform();
    }

    @Override
    public void mouseDownAt(String elementLocator, String coordinates) {
        int[] offset = ReplayUtils.parseCoordinates(coordinates);
        this.checkIsTrue("Invalid coordinates: " + coordinates, offset != null);
        this.mouseDownAt(elementLocator, offset[0], offset[1]);
    }

    @Override
    public void mouseDownAt(String elementLocator, int coordX, int coordY) {
        this.checkElementLocator(elementLocator);
        WebElement element = this.finder.findElement(this.webDriver, elementLocator);
        this.checkIsTrue("Cannot interact with invisible elements", element.isDisplayed());
        new Actions(this.webDriver).moveToElement(element, coordX, coordY).clickAndHold().build().perform();
    }

    @Override
    public void mouseMove(String elementLocator) {
        this.checkElementLocator(elementLocator);
        WebElement element = this.finder.findElement(this.webDriver, elementLocator);
        this.checkIsTrue("Cannot interact with invisible elements", element.isDisplayed());
        new Actions(this.webDriver).moveToElement(element).build().perform();
    }

    @Override
    public void mouseMoveAt(String elementLocator, String coordinates) {
        int[] offset = ReplayUtils.parseCoordinates(coordinates);
        this.checkIsTrue("Invalid coordinates: " + coordinates, offset != null);
        this.mouseMoveAt(elementLocator, offset[0], offset[1]);
    }

    @Override
    public void mouseMoveAt(String elementLocator, int coordX, int coordY) {
        this.checkElementLocator(elementLocator);
        WebElement element = this.finder.findElement(this.webDriver, elementLocator);
        this.checkIsTrue("Cannot interact with invisible elements", element.isDisplayed());
        new Actions(this.webDriver).moveToElement(element, coordX, coordY).build().perform();
    }

    @Override
    public void mouseOut(String elementLocator) {
        this.checkElementLocator(elementLocator);
        WebElement element = this.finder.findElement(this.webDriver, elementLocator);
        this.checkIsTrue("Cannot interact with invisible elements", element.isDisplayed());
        this.mouseOver("xpath=/html/body");
    }

    @Override
    public void mouseOver(String elementLocator) {
        this.checkElementLocator(elementLocator);
        WebElement element = this.finder.findElement(this.webDriver, elementLocator);
        this.checkIsTrue("Cannot interact with invisible elements", element.isDisplayed());
        new Actions(this.webDriver).moveToElement(element).build().perform();
    }

    @Override
    public void mouseUp(String elementLocator) {
        this.checkElementLocator(elementLocator);
        WebElement element = this.finder.findElement(this.webDriver, elementLocator);
        this.checkIsTrue("Cannot interact with invisible elements", element.isDisplayed());
        new Actions(this.webDriver).release(element).build().perform();
    }

    @Override
    public void mouseUpAt(String elementLocator, String coordinates) {
        int[] offset = ReplayUtils.parseCoordinates(coordinates);
        this.checkIsTrue("Invalid coordinates: " + coordinates, offset != null);
        this.mouseUpAt(elementLocator, offset[0], offset[1]);
    }

    @Override
    public void mouseUpAt(String elementLocator, int coordX, int coordY) {
        this.checkElementLocator(elementLocator);
        WebElement element = this.finder.findElement(this.webDriver, elementLocator);
        this.checkIsTrue("Cannot interact with invisible elements", element.isDisplayed());
        new Actions(this.webDriver).moveToElement(element, coordX, coordY).release().build().perform();
    }

    @Override
    public void open(String url) {
        this.executeCommandAndWait(() -> {
            String urlString = this.baseUrl != null ? UrlUtils.resolveUrl(this.baseUrl, url) : url;
            this.webDriver.get(this.rewriteUrl(urlString).toString());
        });
    }

    @Override
    public void open(URL url) {
        this.open(url.toString());
    }

    @Override
    public void pause(long waitingTime) {
        try {
            Thread.sleep(waitingTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void pause(String waitingTime) {
        this.pause(Long.parseLong(waitingTime));
    }

    @Override
    public void removeSelection(String selectLocator, String optionLocator) {
        this.checkElementLocator(selectLocator);
        WebElement select = this.finder.findElement(this.webDriver, selectLocator);
        this.checkIsEqual("Element '" + selectLocator + "' is not a HTML select element", "select", select.getTagName());
        this.checkIsTrue("Select '" + selectLocator + "' does not support multiple selection", this.isMultipleSelect(select));
        this.checkIsTrue("Select '" + selectLocator + "' is disabled", select.isEnabled());
        List<WebElement> options = this.finder.findOptions(select, optionLocator);
        for (WebElement option : options) {
            this.setUnselected(select, option);
        }
    }

    @Override
    public void select(String selectLocator, String optionLocator) {
        this.checkElementLocator(selectLocator);
        WebDriverUtils.assumeOkOnAlertOrConfirm(this.webDriver);
        WebElement select = this.finder.findElement(this.webDriver, selectLocator);
        this.checkIsEqual("Element '" + selectLocator + "' is not a HTML select element", "select", select.getTagName());
        this.checkIsTrue("Select '" + selectLocator + "' is disabled", select.isEnabled());
        if (this.isMultipleSelect(select)) {
            for (WebElement o : select.findElements(By.tagName((String)"option"))) {
                this.setUnselected(select, o);
            }
            List<WebElement> options = this.finder.findOptions(select, optionLocator);
            for (WebElement option : options) {
                this.setSelected(select, option);
            }
        } else {
            WebElement option = this.finder.findOption(select, optionLocator);
            if (WebDriverUtils.isClickable(this.webDriver, option)) {
                if (!option.isSelected()) {
                    option.click();
                }
            } else if (!option.isSelected() && option.isEnabled()) {
                WebDriverUtils.setAttribute(this.webDriver, option, "selected", "false");
                WebDriverUtils.executeJavaScriptIfPossible(this.webDriver, "arguments[0].selectedIndex = arguments[1].index;", select, option);
                WebDriverUtils.fireChangeEvent(this.webDriver, select);
            }
        }
    }

    @Override
    public void selectAndWait(String selectLocator, String optionLocator) {
        this.executeCommandAndWait(() -> this.select(selectLocator, optionLocator));
    }

    @Override
    public void selectFrame(String frameLocator) {
        this.checkIsTrue("Frame locator is empty", StringUtils.isNotBlank((CharSequence)frameLocator));
        if (frameLocator.startsWith("index=")) {
            this.checkIsTrue("Invalid frame locator: " + frameLocator, FRAME_INDEX_PATTERN.matcher(frameLocator).matches());
            String frameID = StringUtils.substring((String)frameLocator, (int)6);
            this.webDriver.switchTo().frame(Integer.parseInt(frameID));
        } else if (FRAME_NAME_LOCATOR_PATTERN.matcher(frameLocator).matches()) {
            String frameID = StringUtils.substring((String)frameLocator, (int)4);
            Matcher m = FRAME_NAME_PATTERN.matcher(frameID);
            while (m.find()) {
                this.webDriver.switchTo().frame(m.group(2));
            }
        } else if (frameLocator.equals("relative=top")) {
            this.webDriver.switchTo().defaultContent();
        } else if (frameLocator.equals("relative=parent")) {
            JavascriptExecutor exec = (JavascriptExecutor)this.webDriver;
            Boolean isParent = (Boolean)exec.executeScript("return (window.parent == window.top);", new Object[0]);
            if (isParent != null && isParent.booleanValue()) {
                this.webDriver.switchTo().defaultContent();
            } else if (!this.switchToParentByNameOrId()) {
                this.switchToParentByIndex();
            }
        } else {
            WebElement frame = this.finder.findElement(this.webDriver, frameLocator);
            this.webDriver.switchTo().frame(frame);
        }
    }

    @Override
    public void selectWindow() {
        this.selectWindow(null);
    }

    @Override
    public void selectWindow(String windowLocator) {
        if (StringUtils.isBlank((CharSequence)windowLocator) || windowLocator.equals("null")) {
            this.webDriver.switchTo().window(this.originalWindowHandle);
        } else {
            String windowhandle = this.finder.findWindow(this.webDriver, windowLocator, false);
            this.webDriver.switchTo().window(windowhandle);
        }
    }

    @Override
    public void setTimeout(long timeout) {
        super.setTimeout(timeout);
        if (this.pageLoadTimeoutAtDriverEnabled) {
            this.webDriver.manage().timeouts().pageLoadTimeout(Duration.ofMillis(timeout));
            this.webDriver.manage().timeouts().scriptTimeout(Duration.ofMillis(timeout));
        }
    }

    @Override
    public void submit(String formLocator) {
        this.checkElementLocator(formLocator);
        WebElement form = this.finder.findElement(this.webDriver, formLocator);
        this.checkIsEqual("Element '" + String.valueOf(form) + "' is not a HTML form element", "form", form.getTagName());
        form.submit();
    }

    @Override
    public void submitAndWait(String formLocator) {
        this.executeCommandAndWait(() -> this.submit(formLocator));
    }

    @Override
    public void type(String elementLocator, String text) {
        this.checkElementLocator(elementLocator);
        this.checkIsTrue("Text is null", text != null);
        WebDriverUtils.assumeOkOnAlertOrConfirm(this.webDriver);
        WebElement element = this.finder.findElement(this.webDriver, elementLocator);
        boolean isDisplayed = element.isDisplayed();
        if (isDisplayed && WebDriverUtils.isEditable(this.webDriver, element, false)) {
            element.clear();
        }
        if (!isDisplayed || !WebDriverUtils.isClickable(this.webDriver, element, false)) {
            this.typeKeys(element, text);
        } else if (text.length() > 0) {
            element.sendKeys(new CharSequence[]{text});
        } else {
            element.sendKeys(new CharSequence[]{" \b"});
        }
    }

    @Override
    public void typeAndWait(String elementLocator, String text) {
        this.executeCommandAndWait(() -> this.type(elementLocator, text + String.valueOf(Keys.ENTER)));
    }

    @Override
    public void uncheck(String elementLocator) {
        this.checkElementLocator(elementLocator);
        WebDriverUtils.assumeOkOnAlertOrConfirm(this.webDriver);
        WebElement input = this.finder.findElement(this.webDriver, elementLocator);
        this.checkIsEqual("Element '" + elementLocator + "' is not a HTML input element", "input", input.getTagName());
        String typeAttribute = input.getAttribute("type");
        this.checkIsTrue("Only check boxes can be unchecked", typeAttribute.equals("checkbox"));
        this.checkIsTrue("Checkbox '" + elementLocator + "' is disabled", input.isEnabled());
        if (input.isSelected()) {
            if (WebDriverUtils.isClickable(this.webDriver, input)) {
                input.click();
            } else {
                WebDriverUtils.setAttribute(this.webDriver, input, "checked", "false");
                WebDriverUtils.fireChangeEvent(this.webDriver, input);
            }
        }
    }

    @Override
    public void uncheckAndWait(String elementLocator) {
        this.executeCommandAndWait(() -> this.uncheck(elementLocator));
    }

    @Override
    public void waitForAttribute(String attributeLocator, String textPattern) {
        this.waitForCondition(this.attributeMatches(attributeLocator, textPattern, true));
    }

    @Override
    public void waitForAttribute(String elementLocator, String attributeName, String textPattern) {
        this.waitForCondition(this.attributeMatches(elementLocator, attributeName, textPattern, true));
    }

    @Override
    public void waitForChecked(String elementLocator) {
        this.waitForCondition(this.elementChecked(elementLocator, true));
    }

    @Override
    public void waitForClass(String elementLocator, String clazzString) {
        this.waitForCondition(this.classMatches(elementLocator, clazzString, true));
    }

    @Override
    public void waitForElementCount(String elementLocator, int count) {
        this.executeRunnable(count == 0, () -> this.waitForCondition(this.elementCountEqual(elementLocator, count, true)));
    }

    @Override
    public void waitForElementCount(String elementLocator, String count) {
        this.waitForElementCount(elementLocator, Integer.parseInt(count));
    }

    @Override
    public void waitForElementPresent(String elementLocator) {
        this.waitForCondition(this.elementPresent(elementLocator, true));
    }

    @Override
    public void waitForEval(String expression, String textPattern) {
        this.waitForCondition(this.evalMatches(expression, textPattern, true));
    }

    @Override
    public void waitForNotAttribute(String attributeLocator, String textPattern) {
        this.waitForCondition(this.attributeMatches(attributeLocator, textPattern, false));
    }

    @Override
    public void waitForNotAttribute(String elementLocator, String attributeName, String textPattern) {
        this.waitForCondition(this.attributeMatches(elementLocator, attributeName, textPattern, false));
    }

    @Override
    public void waitForNotChecked(String elementLocator) {
        this.waitForCondition(this.elementChecked(elementLocator, false));
    }

    @Override
    public void waitForNotClass(String elementLocator, String clazzString) {
        this.waitForCondition(this.classMatches(elementLocator, clazzString, false));
    }

    @Override
    public void waitForNotElementCount(String elementLocator, int count) {
        this.executeRunnable(count != 0, () -> this.waitForCondition(this.elementCountEqual(elementLocator, count, false)));
    }

    @Override
    public void waitForNotElementCount(String elementLocator, String count) {
        this.waitForNotElementCount(elementLocator, Integer.parseInt(count));
    }

    @Override
    public void waitForNotElementPresent(String elementLocator) {
        this.executeRunnable(true, () -> this.waitForCondition(this.elementPresent(elementLocator, false)));
    }

    @Override
    public void waitForNotEval(String expression, String textPattern) {
        this.waitForCondition(this.evalMatches(expression, textPattern, false));
    }

    @Override
    public void waitForNotText(String elementLocator, String textPattern) {
        this.waitForCondition(this.textMatches(elementLocator, textPattern, false));
    }

    @Override
    public void waitForNotTextPresent(String textPattern) {
        this.waitForCondition(this.pageTextMatches(textPattern, false));
    }

    @Override
    public void waitForNotTitle(String titlePattern) {
        this.waitForCondition(this.titleMatches(titlePattern, false));
    }

    @Override
    public void waitForNotXpathCount(String xpath, int count) {
        this.executeRunnable(count != 0, () -> this.waitForCondition(this.xpathCountEqual(xpath, count, false)));
    }

    @Override
    public void waitForNotXpathCount(String xpath, String count) {
        this.waitForNotXpathCount(xpath, Integer.parseInt(count));
    }

    @Override
    public void waitForPageToLoad() {
        if (!(this.webDriver instanceof JavascriptExecutor)) {
            return;
        }
        String loadListenerScript = "return (function(scope) {\n  function XltLoadListener() {\n    this._loadDetected = false;\n    this._initialized = false;\n    this.init();\n  }\n  XltLoadListener.prototype = {\n    init: function() {\n      if (this._initialized) return;\n      this._initialized = true;\n      scope.addEventListener(\"load\", this._handleLoadEvent.bind(this));\n    },\n    _handleLoadEvent: function(event) {\n      if (event.target.defaultView === event.target.defaultView.top) {\n        this._loadDetected = true;\n      }\n    },\n    get loadDetected() {\n      return this._loadDetected;\n    }\n  };\n  return (scope._xll = scope._xll || new XltLoadListener()).loadDetected;\n})(window)";
        String desc = "PAGE LOADED";
        Condition condition = new Condition("PAGE LOADED"){

            @Override
            protected boolean evaluate() {
                boolean ready = (Boolean)WebDriverUtils.executeJavaScript(WebDriverCommandAdapter.this.webDriver, "return (function(scope) {\n  function XltLoadListener() {\n    this._loadDetected = false;\n    this._initialized = false;\n    this.init();\n  }\n  XltLoadListener.prototype = {\n    init: function() {\n      if (this._initialized) return;\n      this._initialized = true;\n      scope.addEventListener(\"load\", this._handleLoadEvent.bind(this));\n    },\n    _handleLoadEvent: function(event) {\n      if (event.target.defaultView === event.target.defaultView.top) {\n        this._loadDetected = true;\n      }\n    },\n    get loadDetected() {\n      return this._loadDetected;\n    }\n  };\n  return (scope._xll = scope._xll || new XltLoadListener()).loadDetected;\n})(window)", new Object[0]);
                this.setReason(ready ? "Page loaded" : "Page did not load");
                return ready;
            }
        };
        try {
            this.waitForCondition(condition);
        }
        catch (TimeoutException e) {
            throw new PageLoadTimeoutException(e.getMessage(), e);
        }
        finally {
            WebDriverUtils.executeJavaScriptIfPossible(this.webDriver, "delete window._xll", new Object[0]);
        }
    }

    @Override
    public void waitForPopUp() {
        this.waitForCondition(new Condition("POPUP LOADED"){

            @Override
            protected boolean evaluate() {
                Set handles = WebDriverCommandAdapter.this.webDriver.getWindowHandles();
                boolean found = handles != null && handles.size() > 1;
                this.setReason((found ? "At least one" : "No") + " window found");
                return found;
            }
        });
    }

    @Override
    public void waitForPopUp(String windowID) {
        this.waitForPopUp(windowID, TestContext.getCurrent().getTimeout());
    }

    @Override
    public void waitForPopUp(final String windowID, long maxWaitingTime) {
        boolean isCurrentWindowOpen = false;
        try {
            this.webDriver.getWindowHandle();
            isCurrentWindowOpen = true;
        }
        catch (NoSuchWindowException noSuchWindowException) {
            // empty catch block
        }
        final boolean switchBackToCurrentWindow = isCurrentWindowOpen;
        this.waitForCondition(new Condition("WINDOW PRESENT"){

            @Override
            protected boolean evaluate() {
                try {
                    WebDriverCommandAdapter.this.finder.findWindow(WebDriverCommandAdapter.this.webDriver, windowID, switchBackToCurrentWindow);
                    this.setReason("At least one window found");
                    return true;
                }
                catch (NoSuchWindowException e) {
                    this.setReason("No such window found");
                    return false;
                }
            }
        }, maxWaitingTime);
    }

    @Override
    public void waitForPopUp(String windowID, String maxWaitingTime) {
        this.waitForPopUp(windowID, Long.parseLong(maxWaitingTime));
    }

    @Override
    public void waitForText(String elementLocator, String textPattern) {
        this.waitForCondition(this.textMatches(elementLocator, textPattern, true));
    }

    @Override
    public void waitForTextPresent(String textPattern) {
        this.waitForCondition(this.pageTextMatches(textPattern, true));
    }

    @Override
    public void waitForValue(String elementLocator, String valuePattern) {
        this.waitForCondition(this.valueMatches(elementLocator, valuePattern, true));
    }

    @Override
    public void waitForNotValue(String elementLocator, String valuePattern) {
        this.waitForCondition(this.valueMatches(elementLocator, valuePattern, false));
    }

    @Override
    public void waitForTitle(String titlePattern) {
        this.waitForCondition(this.titleMatches(titlePattern, true));
    }

    @Override
    public void waitForXpathCount(String xpath, int count) {
        this.executeRunnable(count == 0, () -> this.waitForCondition(this.xpathCountEqual(xpath, count, true)));
    }

    @Override
    public void waitForXpathCount(String xpath, String count) {
        this.waitForXpathCount(xpath, Integer.parseInt(count));
    }

    @Override
    protected String _getText(String elementLocator) {
        String type;
        String tagName;
        WebElement element = this.finder.findElement(this.webDriver, elementLocator, false);
        String elementText = element.isDisplayed() ? ("input".equals(tagName = element.getTagName()) ? ((type = element.getAttribute("type")) == null || type.equals("radio") || type.equals("checkbox") ? "" : this.getElementValue(element)) : ("textarea".equals(tagName) ? this.getElementValue(element) : element.getText())) : "";
        return elementText;
    }

    @Override
    protected String _getValue(String elementLocator) {
        WebElement element = this.finder.findElement(this.webDriver, elementLocator, false);
        return this.getElementValue(element);
    }

    private String getElementValue(WebElement element) {
        String value = element.getAttribute("value");
        String elementValue = value == null ? "" : value;
        return elementValue;
    }

    @Override
    public String getPageText() {
        WebElement body = this.webDriver.findElement(By.tagName((String)"body"));
        String pageText = body.getText();
        return pageText == null ? "" : pageText;
    }

    @Override
    public String getTitle() {
        return this.webDriver.getTitle();
    }

    @Override
    protected int _getXpathCount(String xpath) {
        return this.webDriver.findElements(By.xpath((String)xpath)).size();
    }

    @Override
    protected boolean _isElementPresent(String elementLocator) {
        return this.finder.isElementPresent(this.webDriver, elementLocator);
    }

    @Override
    protected String _evaluate(String expression) {
        return (String)WebDriverUtils.executeJavaScriptIfPossible(this.webDriver, EVAL_SCRIPT, expression);
    }

    @Override
    protected boolean _isChecked(String elementLocator) {
        WebElement checkboxOrRadio = this.finder.findElement(this.webDriver, elementLocator);
        this.checkIsEqual(String.format("Element '%s' is not a HTML input element", elementLocator), "input", checkboxOrRadio.getTagName());
        String inputType = checkboxOrRadio.getAttribute("type");
        this.checkIsTrue(String.format("Input '%s' is neither a checkbox nor a radio button", elementLocator), "radio".equals(inputType) || "checkbox".equals(inputType));
        return checkboxOrRadio.isSelected();
    }

    @Override
    protected boolean _isEnabled(String elementLocator) {
        return this.finder.findElement(this.webDriver, elementLocator).isEnabled();
    }

    private boolean isMultipleSelect(WebElement select) {
        String value = select.getAttribute("multiple");
        return value != null && !value.equals("false");
    }

    private void setUnselected(WebElement selectElement, WebElement element) {
        this.doSelect(selectElement, element, false);
    }

    private void setSelected(WebElement selectElement, WebElement element) {
        this.doSelect(selectElement, element, true);
    }

    private void doSelect(WebElement selectElement, WebElement element, boolean selected) {
        if (element.isSelected() != selected && element.isEnabled()) {
            if (WebDriverUtils.isClickable(this.webDriver, element)) {
                if (this.webDriver instanceof XltDriver || this.webDriver instanceof HtmlUnitDriver) {
                    new Actions(this.webDriver).keyDown((CharSequence)Keys.CONTROL).click(element).keyUp((CharSequence)Keys.CONTROL).perform();
                } else {
                    element.click();
                }
            } else {
                WebDriverUtils.setAttribute(this.webDriver, element, "selected", Boolean.toString(selected));
                WebDriverUtils.fireChangeEvent(this.webDriver, selectElement);
            }
        }
    }

    private void typeKeys(WebElement element, String text) {
        String typeAttribute = element.getAttribute("type");
        boolean adjustValue = element.getTagName().equalsIgnoreCase("input") && (typeAttribute.equalsIgnoreCase("hidden") || typeAttribute.equalsIgnoreCase("text"));
        StringBuilder sb = new StringBuilder(text.length());
        for (char c : text.toCharArray()) {
            sb.append(c);
            if (adjustValue) {
                WebDriverUtils.setAttribute(this.webDriver, element, "value", "'" + sb.toString() + "'");
            }
            WebDriverUtils.fireKeyDownEvent(this.webDriver, element, c);
            WebDriverUtils.fireKeyPressEvent(this.webDriver, element, c);
            WebDriverUtils.fireKeyUpEvent(this.webDriver, element, c);
        }
    }

    private boolean switchToParentByNameOrId() {
        String javaScript = "var parentWindow = window.parent; var winStack = []; while(parentWindow != parentWindow.top) {winStack.unshift(parentWindow.id||parentWindow.name||parentWindow.title); parentWindow = parentWindow.parent;} return winStack.join(',');";
        return this.switchToParent("var parentWindow = window.parent; var winStack = []; while(parentWindow != parentWindow.top) {winStack.unshift(parentWindow.id||parentWindow.name||parentWindow.title); parentWindow = parentWindow.parent;} return winStack.join(',');", false);
    }

    private boolean switchToParentByIndex() {
        String javaScript = "var frameWindow = window.parent; var parentWindow = frameWindow.parent;  var indexStack = [];  while(frameWindow != parentWindow) { var frameSize = parentWindow.frames.length; for(var i=0; i<frameSize; i++) { if(parentWindow.frames[i] == frameWindow) { indexStack.unshift(i); break; } } frameWindow = parentWindow; parentWindow = frameWindow.parent; } return indexStack.join(',');";
        return this.switchToParent("var frameWindow = window.parent; var parentWindow = frameWindow.parent;  var indexStack = [];  while(frameWindow != parentWindow) { var frameSize = parentWindow.frames.length; for(var i=0; i<frameSize; i++) { if(parentWindow.frames[i] == frameWindow) { indexStack.unshift(i); break; } } frameWindow = parentWindow; parentWindow = frameWindow.parent; } return indexStack.join(',');", true);
    }

    private boolean switchToParent(String javaScript, boolean isById) {
        JavascriptExecutor exec = (JavascriptExecutor)this.webDriver;
        String frameLocatorsRAW = (String)exec.executeScript(javaScript, new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)frameLocatorsRAW) && frameLocatorsRAW.length() > 1) {
            String[] frameLocators = frameLocatorsRAW.split(",");
            this.webDriver.switchTo().defaultContent();
            for (String frameLocator : frameLocators) {
                if (isById) {
                    this.webDriver.switchTo().frame(Integer.valueOf(frameLocator).intValue());
                    continue;
                }
                this.webDriver.switchTo().frame(frameLocator);
            }
            return true;
        }
        return false;
    }

    @Override
    public void waitForSelectedId(String selectLocator, String idPattern) {
        this.waitForCondition(this.idSelected(selectLocator, idPattern, true));
    }

    @Override
    public void waitForNotSelectedId(String selectLocator, String idPattern) {
        this.waitForCondition(this.idSelected(selectLocator, idPattern, false));
    }

    @Override
    public void waitForSelectedIndex(String selectLocator, String indexPattern) {
        this.waitForCondition(this.indexSelected(selectLocator, indexPattern, true));
    }

    @Override
    public void waitForNotSelectedIndex(String selectLocator, String indexPattern) {
        this.waitForCondition(this.indexSelected(selectLocator, indexPattern, false));
    }

    @Override
    public void waitForSelectedLabel(String selectLocator, String labelPattern) {
        this.waitForCondition(this.labelSelected(selectLocator, labelPattern, true));
    }

    @Override
    public void waitForNotSelectedLabel(String selectLocator, String labelPattern) {
        this.waitForCondition(this.labelSelected(selectLocator, labelPattern, false));
    }

    @Override
    public void waitForSelectedValue(String selectLocator, String valuePattern) {
        this.waitForCondition(this.valueSelected(selectLocator, valuePattern, true));
    }

    @Override
    public void waitForNotSelectedValue(String selectLocator, String valuePattern) {
        this.waitForCondition(this.valueSelected(selectLocator, valuePattern, false));
    }

    @Override
    public void waitForVisible(String elementLocator) {
        this.waitForCondition(this.elementVisible(elementLocator, true));
    }

    @Override
    public void waitForNotVisible(String elementLocator) {
        this.waitForCondition(this.elementVisible(elementLocator, false));
    }

    @Override
    public void waitForStyle(String elementLocator, String styleText) {
        this.waitForCondition(this.styleMatches(elementLocator, styleText, true));
    }

    @Override
    public void waitForNotStyle(String elementLocator, String styleText) {
        this.waitForCondition(this.styleMatches(elementLocator, styleText, false));
    }

    @Override
    protected List<String> getSelectedIds(String elementLocator) {
        WebElement selectElement = this.finder.findElement(this.webDriver, elementLocator);
        this.checkIsEqual("Element '" + elementLocator + "' is not a HTML select element", "select", selectElement.getTagName());
        List options = selectElement.findElements(By.xpath((String)"./option"));
        this.checkIsTrue(String.format("Select '%s' does not contain any option", elementLocator), !options.isEmpty());
        ArrayList<String> ids = new ArrayList<String>();
        for (WebElement option : selectElement.findElements(By.xpath((String)"./option"))) {
            if (!option.isSelected()) continue;
            ids.add(option.getAttribute("id"));
        }
        if (ids.isEmpty()) {
            ids.add(((WebElement)options.get(0)).getAttribute("id"));
        }
        return ids;
    }

    @Override
    protected List<Integer> getSelectedIndices(String elementLocator) {
        WebElement selectElement = this.finder.findElement(this.webDriver, elementLocator);
        this.checkIsEqual("Element '" + elementLocator + "' is not a HTML select element", "select", selectElement.getTagName());
        List options = selectElement.findElements(By.xpath((String)"./option"));
        this.checkIsTrue(String.format("Select '%s' does not contain any option", elementLocator), !options.isEmpty());
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < options.size(); ++i) {
            if (!((WebElement)options.get(i)).isSelected()) continue;
            indices.add(i);
        }
        if (indices.isEmpty()) {
            indices.add(0);
        }
        return indices;
    }

    @Override
    protected List<String> getSelectedLabels(String elementLocator) {
        WebElement selectElement = this.finder.findElement(this.webDriver, elementLocator);
        this.checkIsEqual("Element '" + elementLocator + "' is not a HTML select element", "select", selectElement.getTagName());
        List options = selectElement.findElements(By.xpath((String)"./option"));
        this.checkIsTrue(String.format("Select '%s' does not contain any option", elementLocator), !options.isEmpty());
        ArrayList<String> labels = new ArrayList<String>();
        for (WebElement option : options) {
            if (!option.isSelected()) continue;
            labels.add(option.isDisplayed() ? option.getText() : "");
        }
        if (labels.isEmpty()) {
            WebElement firstOption = (WebElement)options.get(0);
            labels.add(firstOption.isDisplayed() ? firstOption.getText() : "");
        }
        return labels;
    }

    @Override
    protected List<String> getSelectedValues(String elementLocator) {
        WebElement selectElement = this.finder.findElement(this.webDriver, elementLocator);
        this.checkIsEqual("Element '" + elementLocator + "' is not a HTML select element", "select", selectElement.getTagName());
        List options = selectElement.findElements(By.xpath((String)"./option"));
        this.checkIsTrue(String.format("Select '%s' does not contain any option", elementLocator), !options.isEmpty());
        ArrayList<String> values = new ArrayList<String>();
        for (WebElement option : options) {
            if (!option.isSelected()) continue;
            values.add(option.getAttribute("value"));
        }
        if (values.isEmpty()) {
            values.add(((WebElement)options.get(0)).getAttribute("value"));
        }
        return values;
    }

    @Override
    protected boolean _isVisible(String elementLocator) {
        return this.finder.findElement(this.webDriver, elementLocator).isDisplayed();
    }

    @Override
    protected String _getAttribute(String elementLocator, String attributeName) {
        WebElement element = this.finder.findElement(this.webDriver, elementLocator);
        return element.getAttribute(attributeName);
    }

    @Override
    protected String _getEffectiveStyle(String elementLocator, String propertyName) {
        this.checkIsTrue("CSS property name is blank", StringUtils.isNotBlank((CharSequence)propertyName));
        WebElement element = this.finder.findElement(this.webDriver, elementLocator);
        return WebDriverUtils.getEffectiveStyle(this.webDriver, element, propertyName);
    }

    @Override
    protected int _getElementCount(String elementLocator) {
        return this.finder.findElements(this.webDriver, elementLocator).size();
    }

    @Override
    protected long disableImplicitWaitTimeout() {
        long timeout = super.disableImplicitWaitTimeout();
        this.webDriver.manage().timeouts().implicitlyWait(Duration.ofMillis(0L));
        return timeout;
    }

    @Override
    protected void enableImplicitWaitTimeout(long timeout) {
        super.enableImplicitWaitTimeout(timeout);
        this.webDriver.manage().timeouts().implicitlyWait(Duration.ofMillis(timeout));
    }

    private static boolean isDriverWaitingForPageLoad(WebDriver webDriver) {
        Object pageLoadStrategy;
        Capabilities caps;
        return !(webDriver instanceof HasCapabilities) || (caps = ((HasCapabilities)webDriver).getCapabilities()) == null || (pageLoadStrategy = caps.getCapability("pageLoadStrategy")) == null || !"none".equalsIgnoreCase(pageLoadStrategy.toString()) && !"eager".equalsIgnoreCase(pageLoadStrategy.toString());
    }

    private void executeCommandAndWait(Runnable command) {
        if (this.driverWaitsForPageLoad) {
            TestContext.getCurrent().callAndWait(() -> {
                command.run();
                return null;
            });
        } else {
            command.run();
            this.waitForPageToLoad();
        }
    }
}

