/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting;

import com.xceptance.xlt.engine.XltExecutionContext;
import com.xceptance.xlt.engine.scripting.AbstractScriptInterpreter;
import com.xceptance.xlt.engine.scripting.Action;
import com.xceptance.xlt.engine.scripting.CallCondition;
import com.xceptance.xlt.engine.scripting.CodeComment;
import com.xceptance.xlt.engine.scripting.Command;
import com.xceptance.xlt.engine.scripting.CommandScript;
import com.xceptance.xlt.engine.scripting.JavaModule;
import com.xceptance.xlt.engine.scripting.ModuleCall;
import com.xceptance.xlt.engine.scripting.Script;
import com.xceptance.xlt.engine.scripting.ScriptElement;
import com.xceptance.xlt.engine.scripting.ScriptModule;
import com.xceptance.xlt.engine.scripting.TestCase;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XlteniumScriptInterpreter
extends AbstractScriptInterpreter {
    private static final String LINE_NUMBER = "lineNumber";
    private static final Logger LOG = LoggerFactory.getLogger(XlteniumScriptInterpreter.class);
    public static final File SCRIPTS_DIRECTORY;

    private static File findScriptFile(String scriptName) throws IOException {
        String scriptPath = scriptName.replace('.', '/') + ".xml";
        File scriptFile = new File(SCRIPTS_DIRECTORY, scriptPath);
        if (!scriptFile.isFile()) {
            throw new FileNotFoundException("No script file found for script named: " + scriptName);
        }
        return scriptFile;
    }

    public static File findTestCaseScriptFile(String scriptName) throws IOException {
        return XlteniumScriptInterpreter.findScriptFile(scriptName);
    }

    public XlteniumScriptInterpreter(WebDriver webDriver) {
        super(webDriver);
    }

    private Script parseJavaModule(Element rootElement, File scriptFile) throws Exception {
        String className = rootElement.getAttribute("class");
        ArrayList<String> parameterNames = new ArrayList<String>();
        NodeList childNodes = rootElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element element;
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element) || !(element = (Element)childNode).getTagName().equals("parameter")) continue;
            parameterNames.add(element.getAttribute("name"));
        }
        return new JavaModule(scriptFile, parameterNames, className);
    }

    private Script parseScriptFile(String scriptName) throws Exception {
        Element rootElement;
        File scriptFile = XlteniumScriptInterpreter.findScriptFile(scriptName);
        LOG.info("Parsing script file: " + String.valueOf(scriptFile));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(this.getClass().getResource("xlt-script.xsd"));
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setNamespaceAware(true);
        saxFactory.setSchema(schema);
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        final Document document = docBuilderFactory.newDocumentBuilder().newDocument();
        final XmlErrorHandler errorHandler = new XmlErrorHandler();
        final Stack elementStack = new Stack();
        final StringBuilder textBuffer = new StringBuilder();
        DefaultHandler handler = new DefaultHandler(this){
            private Locator locator;

            @Override
            public void setDocumentLocator(Locator locator) {
                this.locator = locator;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                this.addTextIfNeeded();
                Element element = document.createElement(qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    element.setAttribute(attributes.getQName(i), attributes.getValue(i));
                }
                element.setUserData(XlteniumScriptInterpreter.LINE_NUMBER, this.locator.getLineNumber(), null);
                elementStack.push(element);
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                this.addTextIfNeeded();
                Element closedElement = (Element)elementStack.pop();
                if (elementStack.isEmpty()) {
                    document.appendChild(closedElement);
                } else {
                    Element parentElement = (Element)elementStack.peek();
                    parentElement.appendChild(closedElement);
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                textBuffer.append(ch, start, length);
            }

            private void addTextIfNeeded() {
                if (textBuffer.length() > 0) {
                    Element element = (Element)elementStack.peek();
                    Text textNode = document.createTextNode(textBuffer.toString());
                    element.appendChild(textNode);
                    textBuffer.delete(0, textBuffer.length());
                }
            }

            @Override
            public void warning(SAXParseException e) throws SAXException {
                errorHandler.warning(e);
            }

            @Override
            public void error(SAXParseException e) throws SAXException {
                errorHandler.error(e);
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                errorHandler.fatalError(e);
            }
        };
        SAXParser saxParser = saxFactory.newSAXParser();
        saxParser.parse(scriptFile, handler);
        if (errorHandler.errors > 0) {
            throw new SAXException(String.format("Parsing the script file '%s' produced %d error(s) and %d warning(s)", scriptFile.toString(), errorHandler.errors, errorHandler.warnings));
        }
        if (errorHandler.warnings > 0 && LOG.isWarnEnabled()) {
            LOG.warn(String.format("Parsing the script file '%s' produced %d warning(s)", scriptFile.toString(), errorHandler.warnings));
        }
        Script script = "javamodule".equals((rootElement = document.getDocumentElement()).getTagName()) ? this.parseJavaModule(rootElement, scriptFile) : this.parseTestCaseOrScriptModule(rootElement, scriptFile);
        return script;
    }

    private Script parseTestCaseOrScriptModule(Element rootElement, File scriptFile) throws Exception {
        boolean isTestCase = "testcase".equals(rootElement.getTagName());
        ArrayList<ScriptElement> scriptElements = new ArrayList<ScriptElement>();
        ArrayList<ScriptElement> postSteps = isTestCase ? new ArrayList<ScriptElement>() : null;
        ArrayList<String> scriptParameters = isTestCase ? null : new ArrayList<String>();
        String pathToScriptFile = scriptFile.getAbsolutePath();
        NodeList childNodes = rootElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element)) continue;
            Element element = (Element)childNode;
            String tagName = element.getTagName();
            ScriptElement scriptElement = this.parseElement(element, pathToScriptFile);
            if (scriptElement != null) {
                scriptElements.add(scriptElement);
                continue;
            }
            if (isTestCase) {
                if (!"postSteps".equals(tagName)) continue;
                NodeList postStepItems = element.getChildNodes();
                for (int j = 0; j < postStepItems.getLength(); ++j) {
                    ScriptElement postStep;
                    Node postStepItem = postStepItems.item(j);
                    if (!(postStepItem instanceof Element) || (postStep = this.parseElement((Element)postStepItem, pathToScriptFile)) == null) continue;
                    postSteps.add(postStep);
                }
                continue;
            }
            if (!"parameter".equals(tagName)) continue;
            scriptParameters.add(element.getAttribute("name"));
        }
        CommandScript script = isTestCase ? new TestCase(scriptFile, scriptElements, postSteps, rootElement.getAttribute("baseURL"), rootElement.getAttribute("disabled")) : new ScriptModule(scriptFile, scriptElements, scriptParameters);
        return script;
    }

    private ScriptElement parseElement(Element element, String scriptFilename) throws Exception {
        ScriptElement scriptElement;
        String name = element.getAttribute("name");
        boolean disabled = Boolean.valueOf(element.getAttribute("disabled"));
        int lineNumber = (Integer)element.getUserData(LINE_NUMBER);
        String tagName = element.getTagName();
        if (tagName.equals("command")) {
            NodeList valueElements;
            String value;
            NodeList targetElements;
            String target = element.getAttribute("target");
            if (target.length() == 0 && (targetElements = element.getElementsByTagName("target")).getLength() > 0) {
                target = targetElements.item(0).getTextContent();
            }
            if ((value = element.getAttribute("value")).length() == 0 && (valueElements = element.getElementsByTagName("value")).getLength() > 0) {
                value = valueElements.item(0).getTextContent();
            }
            scriptElement = new Command(name, disabled, target, value, lineNumber);
        } else if (tagName.equals("module")) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            NodeList moduleChildNodes = element.getChildNodes();
            CallCondition condition = null;
            for (int j = 0; j < moduleChildNodes.getLength(); ++j) {
                Node moduleChildNode = moduleChildNodes.item(j);
                if (!(moduleChildNode instanceof Element)) continue;
                Element moduleChildElement = (Element)moduleChildNode;
                String childTagName = moduleChildElement.getTagName();
                if (childTagName.equals("parameter")) {
                    parameters.put(moduleChildElement.getAttribute("name"), moduleChildElement.getAttribute("value"));
                    continue;
                }
                if (!childTagName.equals("condition")) continue;
                if (condition != null && LOG.isErrorEnabled()) {
                    LOG.error(String.format("More than one condition found for module call '%s' in script '%s' at line %d", name, scriptFilename, lineNumber));
                }
                condition = new CallCondition(Boolean.valueOf(moduleChildElement.getAttribute("disabled")), moduleChildElement.getTextContent());
            }
            scriptElement = new ModuleCall(name, disabled, condition, parameters, lineNumber);
        } else {
            scriptElement = tagName.equals("action") ? new Action(name, disabled, lineNumber) : (tagName.equals("codecomment") ? new CodeComment(element.getTextContent(), lineNumber) : null);
        }
        return scriptElement;
    }

    @Override
    protected Script parseModuleScriptFile(String scriptName) throws Exception {
        return this.parseScriptFile(scriptName);
    }

    @Override
    protected Script parseTestCaseScriptFile(String scriptName) throws Exception {
        return this.parseScriptFile(scriptName);
    }

    @Override
    protected File getScriptsDirectory() {
        return SCRIPTS_DIRECTORY;
    }

    static {
        File testSuiteDir = XltExecutionContext.getCurrent().getTestSuiteHomeDirAsFile();
        SCRIPTS_DIRECTORY = new File(testSuiteDir, "scripts");
    }

    private static class XmlErrorHandler
    implements ErrorHandler {
        int errors;
        int warnings;

        private XmlErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            LOG.error(this.report(exception));
            ++this.errors;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            LOG.error(this.report(exception));
            ++this.errors;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            if (LOG.isWarnEnabled()) {
                LOG.warn(this.report(exception));
            }
            ++this.warnings;
        }

        private String report(SAXParseException exception) {
            return String.format("### %d:%d - %s\n", exception.getLineNumber(), exception.getColumnNumber(), exception.getMessage());
        }
    }
}

