/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting;

import com.xceptance.xlt.api.engine.scripting.ScriptCommands;
import com.xceptance.xlt.engine.scripting.TestContext;
import com.xceptance.xlt.engine.scripting.webdriver.WebDriverCommandAdapter;
import com.xceptance.xlt.engine.scripting.webdriver.WebDriverScriptCommands;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;

public class WebDriverCommandProcessor {
    private final WebDriverScriptCommands commands;
    private static final HashMap<String, Method[]> methodMap = new HashMap();
    private static final String[] notInterpretedMethods = new String[]{"startAction"};

    public WebDriverCommandProcessor(WebDriver driver) {
        String baseUrl = TestContext.getCurrent().getBaseUrl();
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        this.commands = WebDriverCommandAdapter.createInstance(driver, baseUrl);
    }

    public void close() {
    }

    public WebDriver getUnderlyingWebDriver() {
        return this.commands.getUnderlyingWebDriver();
    }

    public void doCommand(String commandName, String param1, String param2) throws Throwable {
        Method method = WebDriverCommandProcessor.getMethod(commandName, param1, param2);
        Object[] args = WebDriverCommandProcessor.castArgumentsIfNecessary(method, new String[]{param1, param2});
        try {
            method.invoke((Object)this.commands, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new UnsupportedOperationException("Unknown command: " + commandName);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private static void prepareMethodMap() {
        Method[] scMethods;
        for (Method method : scMethods = ScriptCommands.class.getDeclaredMethods()) {
            boolean skip = false;
            for (String s : notInterpretedMethods) {
                if (s.compareTo(method.getName()) != 0) continue;
                skip = true;
                break;
            }
            if (skip || method.getParameterCount() > 2) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            String currentName = method.getName();
            try {
                Method adapterMethod = WebDriverScriptCommands.class.getMethod(currentName, parameterTypes);
                Method[] methods = methodMap.get(currentName);
                if (methods != null) {
                    Method[] clone = new Method[methods.length + 1];
                    System.arraycopy(methods, 0, clone, 1, methods.length);
                    methods = clone;
                } else {
                    methods = new Method[]{adapterMethod};
                }
                methodMap.put(currentName, methods);
            }
            catch (NoSuchMethodException nsme) {
                throw new RuntimeException(String.format("Could not find declared method '%s' in class '%s'", currentName, WebDriverCommandAdapter.class.getName()), nsme);
            }
        }
    }

    private static Object[] castArgumentsIfNecessary(Method method, String[] params) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] args = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> clazz = parameterTypes[i];
            if (clazz.equals(Integer.TYPE)) {
                args[i] = Integer.parseInt(params[i]);
                continue;
            }
            if (clazz.equals(Long.TYPE)) {
                args[i] = Long.parseLong(params[i]);
                continue;
            }
            if (clazz.equals(String.class)) {
                args[i] = params[i];
                continue;
            }
            throw new IllegalArgumentException("Unsupported parameter type: " + clazz.getCanonicalName());
        }
        return args;
    }

    private static Method getMethod(String commandName, String param1, String param2) {
        Method[] methods = methodMap.get(commandName);
        if (methods != null) {
            if (methods.length == 1) {
                return methods[0];
            }
            int nbParams = WebDriverCommandProcessor.getParamCount(param1, param2);
            for (Method method : methods) {
                if (method.getParameterTypes().length != nbParams) continue;
                return method;
            }
        }
        throw new UnsupportedOperationException("Unknown command: " + commandName);
    }

    private static int getParamCount(String param1, String param2) {
        int nbParams = 0;
        if (StringUtils.isNotBlank((CharSequence)param1)) {
            ++nbParams;
            if (StringUtils.isNotBlank((CharSequence)param2)) {
                ++nbParams;
            }
        }
        return nbParams;
    }

    WebDriverScriptCommands getAdapter() {
        return this.commands;
    }

    static {
        WebDriverCommandProcessor.prepareMethodMap();
    }
}

