/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting;

import com.xceptance.xlt.engine.scripting.CallCondition;
import com.xceptance.xlt.engine.scripting.Command;
import com.xceptance.xlt.engine.scripting.ModuleCall;
import com.xceptance.xlt.engine.scripting.Script;
import com.xceptance.xlt.engine.scripting.ScriptElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class CommandScript
extends Script {
    private static final Pattern MODULE_PARAMETER_PATTERN = Pattern.compile("(?sm)@@|@\\{[^\\s{}]+\\}");
    private final List<ScriptElement> scriptElements;
    private final List<String> parameters;

    public CommandScript(File scriptFile, List<ScriptElement> scriptElements, List<String> parameters) {
        super(scriptFile);
        this.scriptElements = Collections.unmodifiableList(scriptElements);
        this.parameters = parameters;
    }

    public List<ScriptElement> getScriptElements(Map<String, String> arguments) {
        if (arguments == null || arguments.isEmpty()) {
            return this.scriptElements;
        }
        ArrayList<ScriptElement> scriptElements = new ArrayList<ScriptElement>();
        for (ScriptElement e : this.scriptElements) {
            scriptElements.add(this.resolve(e, arguments));
        }
        return scriptElements;
    }

    public List<ScriptElement> getScriptElements() {
        return this.getScriptElements(null);
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    private ScriptElement resolve(ScriptElement element, Map<String, String> arguments) {
        if (element instanceof Command) {
            Command command = (Command)element;
            return new Command(command.getName(), command.isDisabled(), this.resolve(command.getTarget(), arguments), this.resolve(command.getValue(), arguments), element.getLineNumber());
        }
        if (element instanceof ModuleCall) {
            ModuleCall call = (ModuleCall)element;
            HashMap<String, String> resolvedParameters = new HashMap<String, String>();
            CallCondition cond = call.getCondition();
            for (Map.Entry<String, String> parameter : call.getParameters().entrySet()) {
                resolvedParameters.put(parameter.getKey(), this.resolve(parameter.getValue(), arguments));
            }
            return new ModuleCall(call.getName(), call.isDisabled(), cond != null ? new CallCondition(cond.isDisabled(), this.resolve(cond.getConditionExpression(), arguments)) : null, resolvedParameters, element.getLineNumber());
        }
        return element;
    }

    private String resolve(String nameOrValue, Map<String, String> arguments) {
        String s = nameOrValue;
        if (StringUtils.isNotBlank((CharSequence)s)) {
            Matcher m = MODULE_PARAMETER_PATTERN.matcher(s);
            StringBuilder sb = new StringBuilder(nameOrValue);
            int offset = 0;
            while (m.find()) {
                String argValue;
                String match = m.group();
                String value = match.length() == 2 && match.charAt(0) == match.charAt(1) ? "@" : ((argValue = arguments.get(match.substring(2, match.length() - 1))) == null ? match : argValue);
                sb.replace(m.start() + offset, m.end() + offset, value);
                offset += value.length() - match.length();
            }
            s = sb.toString();
        }
        return s;
    }
}

