/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.resultbrowser;

import com.xceptance.xlt.api.engine.RequestData;
import java.util.ArrayList;
import java.util.List;
import org.htmlunit.util.NameValuePair;

public class RequestInfo
implements Comparable<RequestInfo> {
    public String fileName;
    public long startTime;
    public long loadTime;
    public String mimeType;
    public String name;
    public final List<NameValuePair> requestHeaders = new ArrayList<NameValuePair>();
    public String requestMethod;
    public final List<NameValuePair> requestParameters = new ArrayList<NameValuePair>();
    public int responseCode;
    public final List<NameValuePair> responseHeaders = new ArrayList<NameValuePair>();
    public String status;
    public String url;
    public String requestBodyRaw;
    public String protocol;
    public String formDataEncoding;
    public transient TimingInfo timings;

    public void setTimings(RequestData request) {
        TimingInfo timing = null;
        if (request != null) {
            timing = new TimingInfo();
            timing.bytesReceived = request.getBytesReceived();
            timing.bytesSent = request.getBytesSent();
            timing.connectTime = request.getConnectTime();
            timing.dnsTime = request.getDnsTime();
            timing.receiveTime = request.getReceiveTime();
            timing.sendTime = request.getSendTime();
            timing.serverBusyTime = request.getServerBusyTime();
            timing.timeToFirstByte = request.getTimeToFirstBytes();
            timing.timeToLastByte = request.getTimeToLastBytes();
        }
        this.timings = timing;
    }

    @Override
    public int compareTo(RequestInfo other) {
        int result = Long.compare(this.startTime, other.startTime);
        if (result == 0) {
            result = Long.compare(this.loadTime, other.loadTime);
        }
        return result;
    }

    public static class TimingInfo {
        public int bytesSent = -1;
        public int bytesReceived = -1;
        public int connectTime = -1;
        public int receiveTime = -1;
        public int sendTime = -1;
        public int serverBusyTime = -1;
        public int dnsTime = -1;
        public int timeToFirstByte = -1;
        public int timeToLastByte = -1;

        TimingInfo() {
        }
    }
}

