/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.metrics.otel;

import com.xceptance.xlt.agent.JvmResourceUsageData;
import com.xceptance.xlt.api.engine.ActionData;
import com.xceptance.xlt.api.engine.CustomData;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.EventData;
import com.xceptance.xlt.api.engine.PageLoadTimingData;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.engine.TimerData;
import com.xceptance.xlt.api.engine.TransactionData;
import com.xceptance.xlt.engine.metrics.MetricsReporter;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.logs.LogRecordBuilder;
import io.opentelemetry.api.logs.Logger;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.api.metrics.Meter;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;

public class OtelMetricsReporter
implements MetricsReporter {
    static final String INSTRUMENT_NAME_PREFIX = "xlt.";
    private static final String LOG_TYPE_ERROR = "error";
    private static final String LOG_TYPE_EVENT = "event";
    private static final String INSTRUMENTATION_SCOPE_NAME = OtelMetricsReporter.class.getName();
    private final OpenTelemetry _otel;
    private final Map<String, Object> instruments = new ConcurrentHashMap<String, Object>();

    public OtelMetricsReporter(OpenTelemetry otel) {
        this._otel = otel;
    }

    @Override
    public void reportMetrics(Data data) {
        if (data instanceof EventData) {
            this.reportEvent((EventData)data);
        } else if (data instanceof TransactionData) {
            this.reportTransaction((TransactionData)data);
        } else if (data instanceof ActionData) {
            this.reportAction((ActionData)data);
        } else if (data instanceof RequestData) {
            this.reportRequest((RequestData)data);
        } else if (data instanceof CustomData) {
            this.reportCustom((CustomData)data);
        } else if (data instanceof PageLoadTimingData) {
            this.reportPageLoadTiming((PageLoadTimingData)data);
        } else if (data instanceof JvmResourceUsageData) {
            this.reportJvmResourceUsage((JvmResourceUsageData)data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getOrCreateInstrument(String name, Function<String, T> instrumentCreator) {
        String nameSanitized = OtelMetricsReporter.sanitizeInstrumentName(INSTRUMENT_NAME_PREFIX + name);
        Object t = this.instruments.get(nameSanitized);
        if (t == null) {
            OtelMetricsReporter otelMetricsReporter = this;
            synchronized (otelMetricsReporter) {
                t = this.instruments.computeIfAbsent(nameSanitized, instrumentCreator);
            }
        }
        return (T)t;
    }

    private void reportEvent(EventData eventData) {
        this.logRecord(record -> {
            record.setObservedTimestamp(Instant.now());
            record.setTimestamp(Instant.ofEpochMilli(eventData.getTime()));
            record.setSeverity(Severity.WARN);
            record.setBody(eventData.getMessage());
            record.setAttribute(LogRecordAttributes.LOG_TYPE, (Object)LOG_TYPE_EVENT);
            record.setAttribute(LogRecordAttributes.EVENT_NAME, (Object)eventData.getName());
            record.setAttribute(LogRecordAttributes.EVENT_SCENARIO, (Object)eventData.getTestCaseName());
            record.setAttribute(LogRecordAttributes.EVENT_USER, (Object)Session.getCurrent().getUserNumber());
        });
        this.getOrCreateInstrument("events_total.count", name -> this.getMeter().counterBuilder(name).setUnit(OtelMetricsReporter.sanitizeInstrumentUnit("{event}")).build()).add(1L);
    }

    private void reportTransaction(TransactionData txnData) {
        if (txnData.hasFailed()) {
            this.logRecord(record -> {
                record.setObservedTimestamp(Instant.now());
                record.setTimestamp(Instant.ofEpochMilli(txnData.getEndTime()));
                record.setSeverity(Severity.ERROR);
                record.setBody(txnData.getFailureStackTrace());
                record.setAttribute(LogRecordAttributes.LOG_TYPE, (Object)LOG_TYPE_ERROR);
                record.setAttribute(LogRecordAttributes.ERROR_ACTION, (Object)txnData.getFailedActionName());
                record.setAttribute(LogRecordAttributes.ERROR_MESSAGE, (Object)txnData.getFailureMessage());
                record.setAttribute(LogRecordAttributes.ERROR_USER, (Object)Long.valueOf(txnData.getTestUserNumber()));
                record.setAttribute(LogRecordAttributes.ERROR_SCENARIO, (Object)txnData.getName());
            });
        }
        this.updateTimerMetricInstruments("transaction", "transactions_total", txnData, "{transaction}", OtelMetricsReporter.transactionRuntimeBuckets(), this.getTransactionAttributes(txnData));
    }

    private void reportAction(ActionData axnData) {
        this.updateTimerMetricInstruments("action", "actions_total", axnData, "{action}", OtelMetricsReporter.actionRuntimeBuckets(), this.getActionAttributes(axnData));
    }

    private void reportRequest(RequestData reqData) {
        String totalMetricsNamePrefix = "requests_total";
        this.updateTimerMetricInstruments("request", "requests_total", reqData, "{request}", OtelMetricsReporter.requestRuntimeBuckets(), this.getRequestAttributes(reqData));
        this.getOrCreateInstrument("requests_total.bytes_sent", name -> this.getMeter().counterBuilder(name).setUnit(OtelMetricsReporter.sanitizeInstrumentUnit("By")).build()).add((long)reqData.getBytesSent());
        this.getOrCreateInstrument("requests_total.bytes_received", name -> this.getMeter().counterBuilder(name).setUnit(OtelMetricsReporter.sanitizeInstrumentUnit("By")).build()).add((long)reqData.getBytesReceived());
    }

    private void reportCustom(CustomData customData) {
        this.updateTimerMetricInstruments("custom_timer", "custom_timers_total", customData, "{customTimer}", OtelMetricsReporter.customTimerRuntimeBuckets(), this.getCustomAttributes(customData));
    }

    private void reportPageLoadTiming(PageLoadTimingData pageLoadTimingData) {
        this.updateTimerMetricInstruments("page_load", "page_loads_total", pageLoadTimingData, "{pageLoad}", OtelMetricsReporter.pageLoadTimingRuntimeBuckets(), this.getPageLoadAttributes(pageLoadTimingData));
    }

    private void updateTimerMetricInstruments(String instrumentNamePrefix, String totalsInstrumentNamePrefix, TimerData data, String countUnitName, List<Double> runtimeBuckets, Attributes attributes) {
        boolean timerFailed = data.hasFailed();
        double timerRuntime = (double)data.getRunTime() / 1000.0;
        this.doUpdateTimerMetricInstruments(totalsInstrumentNamePrefix, timerFailed, timerRuntime, countUnitName, runtimeBuckets, null);
        this.doUpdateTimerMetricInstruments(instrumentNamePrefix, timerFailed, timerRuntime, countUnitName, runtimeBuckets, attributes);
    }

    private void doUpdateTimerMetricInstruments(String prefix, boolean hasFailed, double runtime, String countUnitName, List<Double> runtimeBuckets, Attributes attributes) {
        Attributes atts = Objects.requireNonNullElseGet(attributes, Attributes::empty);
        this.getOrCreateInstrument(prefix + ".count", name -> this.getMeter().counterBuilder(name).setUnit(OtelMetricsReporter.sanitizeInstrumentUnit(countUnitName)).build()).add(1L, atts);
        this.getOrCreateInstrument(prefix + ".errors", name -> this.getMeter().counterBuilder(name).setUnit(OtelMetricsReporter.sanitizeInstrumentUnit("{error}")).build()).add(hasFailed ? 1L : 0L, atts);
        this.getOrCreateInstrument(prefix + ".runtime", name -> this.getMeter().gaugeBuilder(name).setUnit(OtelMetricsReporter.sanitizeInstrumentUnit("s")).build()).set(runtime, atts);
        this.getOrCreateInstrument(prefix + ".runtime_histo", name -> this.getMeter().histogramBuilder(name).setUnit(OtelMetricsReporter.sanitizeInstrumentUnit("s")).setExplicitBucketBoundariesAdvice(runtimeBuckets).build()).record(runtime, atts);
    }

    private void reportJvmResourceUsage(JvmResourceUsageData jvmResourceUsageData) {
        this.getOrCreateInstrument("jvm.memory.usage", name -> this.getMeter().gaugeBuilder(name).build()).set(jvmResourceUsageData.getHeapUsage());
        this.getOrCreateInstrument("jvm.memory.usage_histo", name -> this.getMeter().histogramBuilder(name).setExplicitBucketBoundariesAdvice(OtelMetricsReporter.resourceUsageBuckets()).build()).record(jvmResourceUsageData.getHeapUsage());
        this.getOrCreateInstrument("jvm.cpu.usage", name -> this.getMeter().gaugeBuilder(name).build()).set(jvmResourceUsageData.getCpuUsage());
        this.getOrCreateInstrument("jvm.cpu.usage_histo", name -> this.getMeter().histogramBuilder(name).setExplicitBucketBoundariesAdvice(OtelMetricsReporter.resourceUsageBuckets()).build()).record(jvmResourceUsageData.getCpuUsage());
    }

    private static List<Double> resourceUsageBuckets() {
        return List.of(Double.valueOf(10.0), Double.valueOf(25.0), Double.valueOf(50.0), Double.valueOf(75.0), Double.valueOf(100.0));
    }

    private static List<Double> transactionRuntimeBuckets() {
        return List.of(Double.valueOf(5.0), Double.valueOf(10.0), Double.valueOf(15.0), Double.valueOf(30.0), Double.valueOf(60.0));
    }

    private static List<Double> actionRuntimeBuckets() {
        return List.of(Double.valueOf(5.0), Double.valueOf(10.0), Double.valueOf(15.0), Double.valueOf(30.0));
    }

    private static List<Double> requestRuntimeBuckets() {
        return List.of(Double.valueOf(0.5), Double.valueOf(1.0), Double.valueOf(3.0), Double.valueOf(5.0));
    }

    private static List<Double> customTimerRuntimeBuckets() {
        return OtelMetricsReporter.actionRuntimeBuckets();
    }

    private static List<Double> pageLoadTimingRuntimeBuckets() {
        return OtelMetricsReporter.requestRuntimeBuckets();
    }

    private void logRecord(Consumer<LogRecordBuilder> logRecordConfigurator) {
        logRecordConfigurator.andThen(LogRecordBuilder::emit).accept(this.getLogger().logRecordBuilder());
    }

    private Logger getLogger() {
        return this._otel.getLogsBridge().get(INSTRUMENTATION_SCOPE_NAME);
    }

    private Meter getMeter() {
        return this._otel.getMeterProvider().get(INSTRUMENTATION_SCOPE_NAME);
    }

    private Attributes getTransactionAttributes(TransactionData txnData) {
        return this.getCommonAttributes(txnData);
    }

    private Attributes getActionAttributes(ActionData axnData) {
        return this.getCommonAttributes(axnData);
    }

    private Attributes getRequestAttributes(RequestData reqData) {
        String requestName = StringUtils.substringBefore((String)reqData.getName(), (String)".");
        AttributesBuilder builder = Attributes.builder();
        builder.put(MetricDataAttributes.TIMER_NAME, (Object)requestName);
        if (reqData.getHost() != null) {
            builder.put(MetricDataAttributes.REQUEST_HOST, (Object)reqData.getHost().toString());
        }
        if (reqData.getHttpMethod() != null) {
            builder.put(MetricDataAttributes.REQUEST_METHOD, (Object)reqData.getHttpMethod().toString());
        }
        builder.put(MetricDataAttributes.REQUEST_STATUS_CODE, reqData.getResponseCode());
        if (reqData.getIpAddresses() != null) {
            builder.put(MetricDataAttributes.REQUEST_IPS, (Object[])reqData.getIpAddresses());
        }
        return builder.build();
    }

    private Attributes getCustomAttributes(CustomData customData) {
        return this.getCommonAttributes(customData);
    }

    private Attributes getPageLoadAttributes(PageLoadTimingData pageLoadTimingData) {
        return this.getCommonAttributes(pageLoadTimingData);
    }

    private Attributes getCommonAttributes(Data data) {
        return Attributes.of(MetricDataAttributes.TIMER_NAME, (Object)data.getName());
    }

    private static String sanitizeInstrumentName(String namePart) {
        if (namePart == null || namePart.trim().length() == 0) {
            throw new IllegalArgumentException("Instrument names must neither be null nor empty or blank");
        }
        String nameLC = namePart.toLowerCase().trim();
        if (nameLC.length() > 255) {
            throw new IllegalArgumentException("Instrument names must not exceed the maximum length of 255 characters");
        }
        char[] chars = nameLC.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            boolean valid;
            char c = chars[i];
            if (i == 0) {
                if (CharUtils.isAsciiAlpha((char)c)) continue;
                chars[i] = 120;
                continue;
            }
            boolean bl = valid = CharUtils.isAsciiAlphanumeric((char)c) || c == '-' || c == '.' || c == '/' || c == '_';
            if (valid) continue;
            chars[i] = 95;
        }
        return new String(chars);
    }

    private static String sanitizeInstrumentUnit(String unit) {
        if (unit == null || unit.trim().length() == 0) {
            return unit;
        }
        if (unit.length() > 63) {
            throw new IllegalArgumentException("Instrument units must not exceed the maximum length of 63 characters");
        }
        char[] chars = unit.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            boolean valid = CharUtils.isAscii((char)c);
            if (valid) continue;
            chars[i] = 63;
        }
        return new String(chars);
    }

    static final class MetricDataAttributes {
        static final AttributeKey<String> TIMER_NAME = AttributeKey.stringKey((String)"xlt.timer.name");
        static final AttributeKey<String> REQUEST_METHOD = AttributeKey.stringKey((String)"xlt.request.method");
        static final AttributeKey<Long> REQUEST_STATUS_CODE = AttributeKey.longKey((String)"xlt.request.status_code");
        static final AttributeKey<String> REQUEST_HOST = AttributeKey.stringKey((String)"xlt.request.target_host");
        static final AttributeKey<List<String>> REQUEST_IPS = AttributeKey.stringArrayKey((String)"xlt.request.target_ip_address");

        MetricDataAttributes() {
        }
    }

    static final class LogRecordAttributes {
        static final AttributeKey<String> LOG_TYPE = AttributeKey.stringKey((String)"xlt.log_type");
        static final AttributeKey<String> ERROR_ACTION = AttributeKey.stringKey((String)"xlt.error.action");
        static final AttributeKey<String> ERROR_MESSAGE = AttributeKey.stringKey((String)"xlt.error.message");
        static final AttributeKey<String> ERROR_SCENARIO = AttributeKey.stringKey((String)"xlt.error.scenario");
        static final AttributeKey<Long> ERROR_USER = AttributeKey.longKey((String)"xlt.error.user");
        static final AttributeKey<String> EVENT_NAME = AttributeKey.stringKey((String)"xlt.event.name");
        static final AttributeKey<String> EVENT_SCENARIO = AttributeKey.stringKey((String)"xlt.event.scenario");
        static final AttributeKey<Long> EVENT_USER = AttributeKey.longKey((String)"xlt.event.user");

        LogRecordAttributes() {
        }
    }
}

