/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.htmlunit.okhttp3;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import org.htmlunit.CookieManager;
import org.htmlunit.util.Cookie;

class CookieJarImpl
implements CookieJar {
    static final String ERROR_MSG_COOKIE_INVALID = "Cookie not valid for use with OkHttp";
    private final CookieManager cookieManager;

    public CookieJarImpl(CookieManager cookieManager) {
        this.cookieManager = cookieManager;
    }

    public void saveFromResponse(HttpUrl url, List<okhttp3.Cookie> okHttpCookies) {
        for (okhttp3.Cookie okHttpCookie : okHttpCookies) {
            this.cookieManager.addCookie(CookieJarImpl.toHtmlUnitCookie(okHttpCookie));
        }
    }

    public List<okhttp3.Cookie> loadForRequest(HttpUrl url) {
        this.cookieManager.clearExpired(new Date());
        return this.cookieManager.getCookies().stream().map(CookieJarImpl::toOkHttpCookie).filter(okHttpCookie -> okHttpCookie.matches(url)).collect(Collectors.toList());
    }

    private static Cookie toHtmlUnitCookie(okhttp3.Cookie okHttpCookie) {
        Object domain = okHttpCookie.hostOnly() ? okHttpCookie.domain() : "." + okHttpCookie.domain();
        return new Cookie((String)domain, okHttpCookie.name(), okHttpCookie.value(), okHttpCookie.path(), new Date(okHttpCookie.expiresAt()), okHttpCookie.secure(), okHttpCookie.httpOnly());
    }

    static okhttp3.Cookie toOkHttpCookie(Cookie htmlUnitCookie) {
        try {
            Date expires;
            Cookie.Builder builder = new Cookie.Builder();
            builder.name(htmlUnitCookie.getName());
            builder.value(htmlUnitCookie.getValue());
            String domain = htmlUnitCookie.getDomain();
            if (domain.startsWith(".")) {
                builder.domain(domain.substring(1));
            } else {
                builder.hostOnlyDomain(domain);
            }
            String path = htmlUnitCookie.getPath();
            if (path != null) {
                builder.path(path);
            }
            if ((expires = htmlUnitCookie.getExpires()) != null) {
                builder.expiresAt(expires.getTime());
            }
            if (htmlUnitCookie.isSecure()) {
                builder.secure();
            }
            if (htmlUnitCookie.isHttpOnly()) {
                builder.httpOnly();
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cookie not valid for use with OkHttp: '" + String.valueOf(htmlUnitCookie) + "'", e);
        }
    }
}

