/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.htmlunit.okhttp3;

import com.xceptance.xlt.engine.htmlunit.okhttp3.AuthenticatorImpl;
import java.io.IOException;
import java.net.Proxy;
import java.util.function.Supplier;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

class AuthorizationHeaderInterceptor
implements Interceptor {
    private final AuthenticatorImpl authenticatorImpl;

    AuthorizationHeaderInterceptor(AuthenticatorImpl authenticatorImpl) {
        this.authenticatorImpl = authenticatorImpl;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request originalRequest;
        Request request = originalRequest = chain.request();
        request = this.addAuthorizationHeaderIfNeeded(request, "Authorization", () -> this.authenticatorImpl.getCachedAuthHeaderValue(originalRequest));
        Route route = chain.connection().route();
        if (route.proxy().type() != Proxy.Type.DIRECT) {
            request = this.addAuthorizationHeaderIfNeeded(request, "Proxy-Authorization", () -> this.authenticatorImpl.getCachedAuthHeaderValue(route));
        }
        return chain.proceed(request);
    }

    private Request addAuthorizationHeaderIfNeeded(Request request, String authHeaderName, Supplier<String> headerValueSupplier) {
        String authHeaderValue;
        if (request.header(authHeaderName) == null && (authHeaderValue = headerValueSupplier.get()) != null) {
            request = request.newBuilder().header(authHeaderName, authHeaderValue).build();
        }
        return request;
    }
}

