/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.htmlunit.okhttp3;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import okhttp3.Authenticator;
import okhttp3.Challenge;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.CredentialsProvider;

class AuthenticatorImpl
implements Authenticator {
    private final Map<String, AuthResult> authenticationCache = new ConcurrentHashMap<String, AuthResult>();
    private final CredentialsProvider credentialsProvider;

    public AuthenticatorImpl(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    @Nullable
    public Request authenticate(@Nullable Route route, Response response) throws IOException {
        boolean isProxyAuth = response.code() == 407;
        String authHeaderName = AuthenticatorImpl.getAuthHeaderName(isProxyAuth);
        if (response.request().header(authHeaderName) != null) {
            return null;
        }
        for (Challenge challenge : response.challenges()) {
            if (challenge.scheme().equalsIgnoreCase("OkHttp-Preemptive")) {
                return this.createBasicAuthRequest(challenge, route, response.request(), true, false);
            }
            if (!challenge.scheme().equalsIgnoreCase("Basic")) continue;
            return this.createBasicAuthRequest(challenge, route, response.request(), isProxyAuth, true);
        }
        return null;
    }

    private AuthScope createAuthScope(Challenge challenge, @Nullable Route route, boolean isProxyAuth) {
        int port;
        String host;
        if (route == null) {
            host = AuthScope.ANY_HOST;
            port = -1;
        } else if (isProxyAuth) {
            InetSocketAddress socketAddress = route.socketAddress();
            host = socketAddress.getHostString();
            port = socketAddress.getPort();
        } else {
            HttpUrl httpUrl = route.address().url();
            host = httpUrl.host();
            port = httpUrl.port();
        }
        return new AuthScope(host, port, challenge.realm(), challenge.scheme());
    }

    @Nullable
    private Request createBasicAuthRequest(Challenge challenge, Route route, Request request, boolean isProxyAuth, boolean cacheAuthHeaderValue) {
        AuthScope authScope = this.createAuthScope(challenge, route, isProxyAuth);
        org.apache.http.auth.Credentials credentials = this.credentialsProvider.getCredentials(authScope);
        if (credentials != null) {
            String basicAuthHeaderName = AuthenticatorImpl.getAuthHeaderName(isProxyAuth);
            String basicAuthHeaderValue = Credentials.basic((String)credentials.getUserPrincipal().getName(), (String)credentials.getPassword());
            if (cacheAuthHeaderValue) {
                String cacheKey = isProxyAuth ? AuthenticatorImpl.getCacheKey(route) : AuthenticatorImpl.getCacheKey(request);
                this.authenticationCache.put(cacheKey, new AuthResult(authScope, basicAuthHeaderValue));
            }
            return request.newBuilder().header(basicAuthHeaderName, basicAuthHeaderValue).build();
        }
        return null;
    }

    String getCachedAuthHeaderValue(Request request) {
        return this.getCachedAuthHeaderValue(AuthenticatorImpl.getCacheKey(request));
    }

    String getCachedAuthHeaderValue(Route route) {
        return this.getCachedAuthHeaderValue(AuthenticatorImpl.getCacheKey(route));
    }

    private String getCachedAuthHeaderValue(String hostAndPort) {
        AuthResult authResult = this.authenticationCache.get(hostAndPort);
        if (authResult == null) {
            return null;
        }
        org.apache.http.auth.Credentials credentials = this.credentialsProvider.getCredentials(authResult.authScope);
        if (credentials == null) {
            this.authenticationCache.remove(hostAndPort);
            return null;
        }
        return authResult.headerValue;
    }

    private static String getCacheKey(Request request) {
        return AuthenticatorImpl.getCacheKey(request.url().host(), request.url().port());
    }

    private static String getCacheKey(Route route) {
        return AuthenticatorImpl.getCacheKey(route.socketAddress().getHostString(), route.socketAddress().getPort());
    }

    private static String getCacheKey(String host, int port) {
        return host + ":" + port;
    }

    private static String getAuthHeaderName(boolean isProxyAuth) {
        return isProxyAuth ? "Proxy-Authorization" : "Authorization";
    }

    record AuthResult(AuthScope authScope, String headerValue) {
    }
}

