/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.htmlunit.apache;

import com.xceptance.xlt.api.engine.Session;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;

public class XltHttpRequestRetryHandler
extends StandardHttpRequestRetryHandler {
    public XltHttpRequestRetryHandler(int retryCount, boolean requestSentRetryEnabled) {
        super(retryCount, requestSentRetryEnabled);
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)exception);
        IOException exceptionToCheck = rootCause instanceof IOException ? (IOException)rootCause : exception;
        boolean retry = super.retryRequest(exceptionToCheck, executionCount, context);
        if (retry) {
            String eventName = "Request retried (attempt #" + executionCount + ")";
            String eventMessage = "Host: " + this.getHostName(context) + ", Reason: " + exceptionToCheck.toString();
            Session.logEvent(eventName, eventMessage);
        }
        return retry;
    }

    private String getHostName(HttpContext context) {
        URI uri;
        String hostName = null;
        HttpRequest request = HttpClientContext.adapt((HttpContext)context).getRequest();
        if (request instanceof HttpRequestWrapper) {
            request = ((HttpRequestWrapper)request).getOriginal();
        }
        if (request instanceof HttpUriRequest && (uri = ((HttpUriRequest)request).getURI()) != null) {
            hostName = uri.getHost();
        }
        return (String)StringUtils.defaultIfBlank(hostName, (CharSequence)"<unknown>");
    }
}

