/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.har;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xceptance.xlt.engine.har.model.HarBrowser;
import com.xceptance.xlt.engine.har.model.HarCreator;
import com.xceptance.xlt.engine.har.model.HarEntry;
import com.xceptance.xlt.engine.har.model.HarPage;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class HarStreamWriter {
    private final JsonGenerator jsonGenerator;

    private HarStreamWriter(File harFile, String version, HarCreator creator, HarBrowser browser, List<HarPage> pages, String comment, boolean usePrettyPrint) throws IOException {
        this.jsonGenerator = new JsonFactory().createGenerator(harFile, JsonEncoding.UTF8);
        ObjectMapper objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.jsonGenerator.setCodec((ObjectCodec)objectMapper);
        if (usePrettyPrint) {
            this.jsonGenerator.useDefaultPrettyPrinter();
        }
        this.jsonGenerator.writeStartObject();
        this.writeHarLogFields(version, creator, browser, pages, comment);
        this.jsonGenerator.writeFieldName("entries");
        this.jsonGenerator.writeStartArray();
    }

    private void writeHarLogFields(String version, HarCreator creator, HarBrowser browser, List<HarPage> pages, String comment) throws IOException {
        this.jsonGenerator.writeFieldName("log");
        this.jsonGenerator.writeStartObject();
        if (comment != null) {
            this.jsonGenerator.writeFieldName("comment");
            this.jsonGenerator.writeObject((Object)comment);
        }
        if (browser != null) {
            this.jsonGenerator.writeFieldName("browser");
            this.jsonGenerator.writeObject((Object)browser);
        }
        if (pages != null) {
            this.jsonGenerator.writeFieldName("pages");
            this.jsonGenerator.writeObject(pages);
        }
        this.jsonGenerator.writeFieldName("creator");
        this.jsonGenerator.writeObject((Object)creator);
        this.jsonGenerator.writeFieldName("version");
        this.jsonGenerator.writeObject((Object)version);
    }

    public void addEntry(HarEntry harEntry) throws IOException {
        this.jsonGenerator.writeObject((Object)harEntry);
        this.jsonGenerator.flush();
    }

    public void closeHar() throws IOException {
        this.jsonGenerator.writeEndArray();
        this.jsonGenerator.writeEndObject();
        this.jsonGenerator.close();
    }
}

