/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.dns;

import com.xceptance.xlt.api.util.XltException;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.api.util.XltRandom;
import com.xceptance.xlt.engine.RequestExecutionContext;
import com.xceptance.xlt.engine.dns.DnsJavaHostNameResolver;
import com.xceptance.xlt.engine.dns.DnsMonitor;
import com.xceptance.xlt.engine.dns.DnsOverrideResolver;
import com.xceptance.xlt.engine.dns.HostNameResolver;
import com.xceptance.xlt.engine.dns.PlatformHostNameResolver;
import com.xceptance.xlt.engine.socket.SocketMonitor;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XltDnsResolver
implements HostNameResolver {
    static final String PROP_PREFIX_DNS = "xlt.dns.";
    static final String PROP_PREFIX_DNS_PROVIDERS = "xlt.dns.providers.";
    private static final String PROP_PROVIDER = "xlt.dns.provider";
    private static final String PROP_SHUFFLE_ADDRESSES = "xlt.dns.shuffleAddresses";
    static final String PROP_PICK_ONE_ADDRESS_RANDOMLY = "xlt.dns.pickOneAddressRandomly";
    static final String PROP_CACHE_ADDRESSES = "xlt.dns.cacheAddresses";
    static final String PROP_RECORD_ADDRESSES = "xlt.dns.recordAddresses";
    static final String PROP_IGNORE_IPV4_ADDRESSES = "xlt.dns.ignoreIPv4Addresses";
    static final String PROP_IGNORE_IPV6_ADDRESSES = "xlt.dns.ignoreIPv6Addresses";
    private static final Logger LOG = LoggerFactory.getLogger(XltDnsResolver.class);
    private final boolean recordAddresses;
    private final boolean shuffleAddresses;
    private final boolean pickOneAddressRandomly;
    private final boolean cacheAddresses;
    private final boolean ignoreIPv4Addresses;
    private final boolean ignoreIPv6Addresses;
    private final Map<String, InetAddress[]> addressesByHostName;
    private final DnsOverrideResolver resolver;

    public XltDnsResolver() {
        XltProperties props = XltProperties.getInstance();
        this.recordAddresses = props.getProperty(PROP_RECORD_ADDRESSES, false);
        this.shuffleAddresses = props.getProperty(PROP_SHUFFLE_ADDRESSES, false);
        this.pickOneAddressRandomly = props.getProperty(PROP_PICK_ONE_ADDRESS_RANDOMLY, false);
        this.ignoreIPv4Addresses = props.getProperty(PROP_IGNORE_IPV4_ADDRESSES, false);
        this.ignoreIPv6Addresses = props.getProperty(PROP_IGNORE_IPV6_ADDRESSES, false);
        if (this.ignoreIPv4Addresses && this.ignoreIPv6Addresses) {
            LOG.warn(String.format("Both properties '%s' and '%s' are set to true at the same time. This effectively disables host name resolution!", PROP_IGNORE_IPV4_ADDRESSES, PROP_IGNORE_IPV6_ADDRESSES));
        }
        this.cacheAddresses = props.getProperty(PROP_CACHE_ADDRESSES, false);
        this.addressesByHostName = this.cacheAddresses ? new HashMap() : null;
        String providerName = (String)StringUtils.defaultIfBlank((CharSequence)props.getProperty(PROP_PROVIDER), (CharSequence)"platform");
        this.resolver = new DnsOverrideResolver(XltDnsResolver.createResolver(providerName));
    }

    private static HostNameResolver createResolver(String providerName) {
        HostNameResolver resolver;
        if (providerName.equals("platform")) {
            resolver = new PlatformHostNameResolver();
        } else if (providerName.equals("dnsjava")) {
            resolver = new DnsJavaHostNameResolver();
        } else {
            throw new XltException("Unknown DNS provider configured: " + providerName);
        }
        return resolver;
    }

    @Override
    public InetAddress[] resolve(String host) throws UnknownHostException {
        InetAddress[] addresses = null;
        if (this.cacheAddresses) {
            addresses = this.addressesByHostName.get(host);
        }
        if (addresses == null) {
            addresses = this.doResolve(host, this.resolver);
            if ((addresses = this.removeIgnoredAddresses(addresses)).length == 0) {
                throw new UnknownHostException(host);
            }
            if (addresses.length > 1) {
                if (this.pickOneAddressRandomly) {
                    addresses = XltDnsResolver.pickRandomAddress(addresses);
                } else if (this.shuffleAddresses) {
                    XltDnsResolver.shuffleAddresses(addresses);
                }
            }
            if (this.cacheAddresses) {
                this.addressesByHostName.put(host, addresses);
            }
        }
        return addresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InetAddress[] doResolve(String host, HostNameResolver resolver) throws UnknownHostException {
        RequestExecutionContext requestExecutionContext = RequestExecutionContext.getCurrent();
        SocketMonitor socketMonitor = requestExecutionContext.getSocketMonitor();
        InetAddress[] inetAddresses = null;
        try {
            socketMonitor.dnsLookupStarted();
            inetAddresses = resolver.resolve(host);
        }
        finally {
            socketMonitor.dnsLookupDone();
        }
        if (this.recordAddresses) {
            String[] ipAddresses = XltDnsResolver.extractIpAddresses(inetAddresses);
            DnsMonitor dnsMonitor = requestExecutionContext.getDnsMonitor();
            dnsMonitor.dnsLookupDone(ipAddresses);
        }
        return inetAddresses;
    }

    private static String[] extractIpAddresses(InetAddress[] inetAddresses) {
        String[] ipAddresses;
        if (inetAddresses == null || inetAddresses.length == 0) {
            ipAddresses = ArrayUtils.EMPTY_STRING_ARRAY;
        } else {
            ipAddresses = new String[inetAddresses.length];
            for (int i = 0; i < inetAddresses.length; ++i) {
                ipAddresses[i] = inetAddresses[i].getHostAddress();
            }
        }
        return ipAddresses;
    }

    private InetAddress[] removeIgnoredAddresses(InetAddress[] addresses) {
        if (!this.ignoreIPv4Addresses && !this.ignoreIPv6Addresses) {
            return addresses;
        }
        ArrayList<InetAddress> remainingAddresses = new ArrayList<InetAddress>();
        for (InetAddress address : addresses) {
            if ((this.ignoreIPv4Addresses || !(address instanceof Inet4Address)) && (this.ignoreIPv6Addresses || !(address instanceof Inet6Address))) continue;
            remainingAddresses.add(address);
        }
        return remainingAddresses.toArray(new InetAddress[remainingAddresses.size()]);
    }

    private static InetAddress[] pickRandomAddress(InetAddress[] addresses) {
        return new InetAddress[]{addresses[XltRandom.nextInt(addresses.length)]};
    }

    private static void shuffleAddresses(InetAddress[] addresses) {
        ArrayUtils.shuffle((Object[])addresses);
    }
}

