/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.dns;

import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.common.util.ParseUtils;
import com.xceptance.xlt.api.util.XltException;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.dns.HostNameResolver;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DnsOverrideResolver
implements HostNameResolver {
    static final String PROP_DNS_OVERRIDE_PREFIX = "xlt.dns.override";
    private final HostNameResolver fallbackResolver;
    private final Map<String, InetAddress[]> addressOverrides;

    public DnsOverrideResolver(HostNameResolver fallbackResolver) {
        ParameterCheckUtils.isNotNull(fallbackResolver, "fallbackResolver");
        this.fallbackResolver = fallbackResolver;
        this.addressOverrides = DnsOverrideResolver.readHostNameOverrides();
    }

    @Override
    public InetAddress[] resolve(String host) throws UnknownHostException {
        InetAddress[] overrideIps = this.addressOverrides.get(host);
        return overrideIps != null ? overrideIps : this.fallbackResolver.resolve(host);
    }

    static Map<String, InetAddress[]> readHostNameOverrides() {
        HashMap<String, InetAddress[]> overrides = new HashMap<String, InetAddress[]>();
        XltProperties.getInstance().getPropertiesForKey(PROP_DNS_OVERRIDE_PREFIX).forEach((hostName, ipString) -> {
            if (StringUtils.isNotBlank((CharSequence)hostName)) {
                try {
                    overrides.put((String)hostName, ParseUtils.parseIpAddresses(ipString));
                }
                catch (ParseException e) {
                    throw new XltException("Failed to parse IP override '" + ipString + "' for host '" + hostName + "'.", e);
                }
            }
        });
        return overrides;
    }
}

