/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine;

import com.xceptance.xlt.api.engine.CustomData;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.engine.XltBackgroundJavaScriptFactory;
import com.xceptance.xlt.engine.XltCache;
import com.xceptance.xlt.engine.XltContextFactory;
import com.xceptance.xlt.engine.XltScript;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.Cache;
import org.htmlunit.WebClient;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.NativeFunction;
import org.htmlunit.corejs.javascript.Script;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.debug.DebuggableScript;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.HtmlUnitContextFactory;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XltJavaScriptEngine
extends JavaScriptEngine {
    private static final Logger LOG = LoggerFactory.getLogger(XltJavaScriptEngine.class);
    private final HtmlUnitContextFactory contextFactory;
    private final boolean takeMeasurements;

    public XltJavaScriptEngine(WebClient webClient, int optimizationLevel, boolean takeMeasurements) {
        super(webClient);
        this.contextFactory = new XltContextFactory(webClient, optimizationLevel);
        this.takeMeasurements = takeMeasurements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object callFunction(HtmlPage htmlPage, Function function, Scriptable scope, Scriptable thisObject, Object[] args) {
        Object result;
        block5: {
            block4: {
                if (!this.takeMeasurements) break block4;
                String functionName = this.getFunctionName(function);
                CustomData customData = new CustomData("Executing function " + functionName);
                long start = System.nanoTime();
                try {
                    result = super.callFunction(htmlPage, function, scope, thisObject, args);
                }
                catch (Throwable throwable) {
                    long runTimeInNS = System.nanoTime() - start;
                    customData.setRunTime((int)(runTimeInNS / 1000000L));
                    Session.getCurrent().getDataManager().logDataRecord(customData);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Execution of function '%s' took %.2f ms", functionName, (double)runTimeInNS / 1000000.0));
                    }
                    throw throwable;
                }
                long runTimeInNS = System.nanoTime() - start;
                customData.setRunTime((int)(runTimeInNS / 1000000L));
                Session.getCurrent().getDataManager().logDataRecord(customData);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Execution of function '%s' took %.2f ms", functionName, (double)runTimeInNS / 1000000.0));
                }
                break block5;
            }
            result = super.callFunction(htmlPage, function, scope, thisObject, args);
        }
        return result;
    }

    @Override
    public Script compile(HtmlPage owningPage, Scriptable scope, String sourceCode, String sourceName, int startLine) {
        Script script;
        Cache cache = this.getWebClient().getCache();
        if (cache instanceof XltCache) {
            String sourceFileName;
            XltCache xltCache = (XltCache)cache;
            script = xltCache.getCachedScript(sourceCode);
            if (script == null && (script = this.compileScript(owningPage, scope, sourceCode, sourceName, startLine, sourceFileName = this.getSourceFileName(sourceName, sourceCode))) != null) {
                script = new XltScript(script, sourceFileName);
                xltCache.cache(sourceCode, script);
            }
        } else {
            String sourceFileName = this.getSourceFileName(sourceName, sourceCode);
            script = this.compileScript(owningPage, scope, sourceCode, sourceName, startLine, sourceFileName);
        }
        return script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(HtmlPage htmlPage, Scriptable scope, Script script) {
        Object result;
        block5: {
            block4: {
                if (!this.takeMeasurements) break block4;
                String sourceFileName = this.getSourceFileName(script);
                CustomData customData = new CustomData("Executing " + sourceFileName);
                long start = System.nanoTime();
                try {
                    result = super.execute(htmlPage, scope, script);
                }
                catch (Throwable throwable) {
                    long runTimeInNS = System.nanoTime() - start;
                    customData.setRunTime((int)(runTimeInNS / 1000000L));
                    Session.getCurrent().getDataManager().logDataRecord(customData);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Execution of script '%s' took %.2f ms", sourceFileName, (double)runTimeInNS / 1000000.0));
                    }
                    throw throwable;
                }
                long runTimeInNS = System.nanoTime() - start;
                customData.setRunTime((int)(runTimeInNS / 1000000L));
                Session.getCurrent().getDataManager().logDataRecord(customData);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Execution of script '%s' took %.2f ms", sourceFileName, (double)runTimeInNS / 1000000.0));
                }
                break block5;
            }
            result = super.execute(htmlPage, scope, script);
        }
        return result;
    }

    @Override
    public HtmlUnitContextFactory getContextFactory() {
        return this.contextFactory;
    }

    private Script compileScript(HtmlPage owningPage, Scriptable scope, String sourceCode, String sourceName, int startLine, String sourceFileName) {
        Script script;
        block7: {
            block6: {
                if (!this.takeMeasurements) break block6;
                CustomData customData = new CustomData();
                long start = System.nanoTime();
                try {
                    script = super.compile(owningPage, scope, sourceCode, sourceName, startLine);
                }
                catch (RuntimeException e) {
                    try {
                        customData.setFailed(true);
                        throw e;
                    }
                    catch (Throwable throwable) {
                        long runTimeInNS = System.nanoTime() - start;
                        customData.setName("Compiling " + sourceFileName);
                        customData.setRunTime((int)(runTimeInNS / 1000000L));
                        Session.getCurrent().getDataManager().logDataRecord(customData);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(String.format("Compilation of script '%s' took %.2f ms", sourceFileName, (double)runTimeInNS / 1000000.0));
                        }
                        throw throwable;
                    }
                }
                long runTimeInNS = System.nanoTime() - start;
                customData.setName("Compiling " + sourceFileName);
                customData.setRunTime((int)(runTimeInNS / 1000000L));
                Session.getCurrent().getDataManager().logDataRecord(customData);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Compilation of script '%s' took %.2f ms", sourceFileName, (double)runTimeInNS / 1000000.0));
                }
                break block7;
            }
            script = super.compile(owningPage, scope, sourceCode, sourceName, startLine);
        }
        return script;
    }

    private String getFunctionName(Function function) {
        Object functionName;
        if (function instanceof NativeFunction) {
            functionName = ((NativeFunction)function).getFunctionName();
            if (functionName == null || ((String)functionName).isEmpty()) {
                DebuggableScript debuggableScript = ((NativeFunction)function).getDebuggableView();
                int hashCode = debuggableScript == null ? function.getClass().getName().hashCode() : debuggableScript.hashCode();
                functionName = "anonymous@" + hashCode;
            }
        } else {
            functionName = "unknown@0";
        }
        return functionName;
    }

    private String getSourceFileName(Script script) {
        Object sourceFileName;
        if (script instanceof XltScript) {
            sourceFileName = ((XltScript)script).getSourceName();
        } else if (script instanceof NativeFunction) {
            DebuggableScript debuggableScript = ((NativeFunction)script).getDebuggableView();
            if (debuggableScript == null) {
                sourceFileName = script.getClass().getSimpleName();
                sourceFileName = StringUtils.substringBeforeLast((String)sourceFileName, (String)"_");
            } else {
                sourceFileName = debuggableScript.getSourceName();
                sourceFileName = StringUtils.substringAfterLast((String)sourceFileName, (String)"/");
                sourceFileName = StringUtils.substringBefore((String)sourceFileName, (String)"?");
            }
        } else {
            sourceFileName = "unknown_script@" + script.toString().hashCode();
        }
        return sourceFileName;
    }

    private String getSourceFileName(String sourceName, String sourceCode) {
        Object sourceFileName = sourceName.equals("injected script") ? sourceName + "@" + sourceCode.hashCode() : sourceName;
        return sourceFileName;
    }

    static {
        BackgroundJavaScriptFactory.setFactory(new XltBackgroundJavaScriptFactory());
    }
}

