/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine;

import com.xceptance.xlt.api.engine.GlobalClock;
import com.xceptance.xlt.api.engine.NetworkData;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.CachingHttpWebConnection;
import com.xceptance.xlt.engine.PageStatistics;
import com.xceptance.xlt.engine.RequestExecutionContext;
import com.xceptance.xlt.engine.RequestStack;
import com.xceptance.xlt.engine.SessionImpl;
import com.xceptance.xlt.engine.XltWebClient;
import com.xceptance.xlt.engine.dns.DnsInfo;
import com.xceptance.xlt.engine.socket.SocketStatistics;
import com.xceptance.xlt.engine.util.TimerUtils;
import com.xceptance.xlt.engine.util.URLCleaner;
import com.xceptance.xlt.engine.util.UrlUtils;
import com.xceptance.xlt.util.XltPropertiesImpl;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.htmlunit.FormEncodingType;
import org.htmlunit.HttpMethod;
import org.htmlunit.WebConnection;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;
import org.htmlunit.WebResponseData;
import org.htmlunit.util.NameValuePair;
import org.slf4j.Logger;

public class XltHttpWebConnection
extends CachingHttpWebConnection {
    private static final byte[] FAKE_RESPONSE_BODY = new byte[0];
    private static final List<NameValuePair> FAKE_RESPONSE_HEADER_LIST = new ArrayList<NameValuePair>();
    private static final boolean requestIdActive;
    private static final int requestIdLength;
    private static final String requestIdHeader;
    private static final boolean requestIdAppendToUserAgent;
    private static final boolean responseIdActive;
    private static final String responseIdHeader;
    private static final boolean logEventOnRequestFailure;
    private final XltWebClient webClient;

    public XltHttpWebConnection(XltWebClient webClient, WebConnection webConnection) {
        super(webConnection);
        this.webClient = webClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebResponse getResponse(WebRequest webRequest) throws IOException {
        URL url = webRequest.getUrl();
        RequestStack requestStack = RequestStack.getCurrent();
        requestStack.setTimerName(this.webClient.getTimerName());
        requestStack.pushRequest();
        try {
            WebResponse webResponse = null;
            if (this.webClient.isAcceptedUrl(url)) {
                webResponse = super.getResponse(webRequest);
                PageStatistics.getPageStatistics().addToTotalBytes(webResponse.getRawSize());
            } else {
                Logger logger = XltLogger.runTimeLogger;
                if (logger.isDebugEnabled()) {
                    logger.debug("Skipping download of URL: " + String.valueOf(url));
                }
                WebResponseData webResponseData = new WebResponseData(FAKE_RESPONSE_BODY, 200, EnglishReasonPhraseCatalog.INSTANCE.getReason(200, null), FAKE_RESPONSE_HEADER_LIST);
                webResponse = new WebResponse(webResponseData, url, webRequest.getHttpMethod(), 0L);
            }
            WebResponse webResponse2 = webResponse;
            return webResponse2;
        }
        finally {
            requestStack.popRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected WebResponse getResponse(WebRequest webRequest, String lastModifiedHeader, String etag) throws IOException {
        Map<String, String> originalRequestHeaders = webRequest.getAdditionalHeaders();
        RequestData requestData = null;
        WebResponse response = null;
        RequestStack requestStack = RequestStack.getCurrent();
        String timerName = requestStack.getHierarchicalTimerName();
        String requestName = requestStack.getHierarchicalRequestName(webRequest.getUrl());
        try {
            requestData = new RequestData(timerName);
            requestData.setUrl(URLCleaner.removeUserInfoIfNecessaryAsString(webRequest.getUrl()));
            requestData.setHttpMethod(webRequest.getHttpMethod().toString());
            XltHttpWebConnection.putAdditionalRequestData(requestData, webRequest);
            long startTime = TimerUtils.get().getStartTime();
            String requestId = null;
            if (requestIdActive) {
                requestId = RandomStringUtils.randomAlphanumeric((int)requestIdLength);
                webRequest.setAdditionalHeader(requestIdHeader, requestId);
                if (requestIdAppendToUserAgent) {
                    String currentUserAgent = webRequest.getAdditionalHeader("User-Agent");
                    if (currentUserAgent == null) {
                        currentUserAgent = this.webClient.getBrowserVersion().getUserAgent();
                    }
                    String newUserAgent = currentUserAgent + " " + requestId;
                    webRequest.setAdditionalHeader("User-Agent", newUserAgent);
                }
            }
            String responseId = null;
            requestData.setTime(GlobalClock.millis());
            try {
                RequestExecutionContext.getCurrent().reset();
                response = super.getResponse(webRequest, lastModifiedHeader, etag);
                if (responseIdActive) {
                    responseId = response.getResponseHeaderValue(responseIdHeader);
                }
            }
            catch (IOException e) {
                requestData.setFailed(true);
                throw e;
            }
            finally {
                long runTime = TimerUtils.get().getElapsedTime(startTime);
                requestData.setRunTime((int)runTime);
                requestData.setRequestId(requestId);
                requestData.setResponseId(responseId);
            }
            Logger logger = XltLogger.runTimeLogger;
            if (logger.isInfoEnabled()) {
                long runTime;
                logger.info(response.getWebRequest().getHttpMethod().name() + " - " + response.getStatusCode() + " - " + runTime + " ms - " + URLCleaner.removeUserInfoIfNecessaryAsString(response.getWebRequest().getUrl()) + " " + String.valueOf(response.getWebRequest().getRequestParameters()));
            }
            requestData.setResponseCode(response.getStatusCode());
            requestData.setFailed(response.getStatusCode() >= 500);
            requestData.setContentType(response.getContentType());
            WebResponse webResponse = response = this.webClient.processResponse(response);
            return webResponse;
        }
        finally {
            WebRequest clonedWebRequest = this.cloneWebRequest(webRequest);
            webRequest.setAdditionalHeaders(originalRequestHeaders);
            RequestExecutionContext requestExecutionContext = RequestExecutionContext.getCurrent();
            SocketStatistics socketStats = requestExecutionContext.getSocketMonitor().getSocketStatistics();
            requestData.setBytesSent(socketStats.getBytesSent());
            requestData.setBytesReceived(socketStats.getBytesReceived());
            requestData.setConnectTime(socketStats.getConnectTime());
            requestData.setSendTime(socketStats.getSendTime());
            requestData.setServerBusyTime(socketStats.getServerBusyTime());
            requestData.setReceiveTime(socketStats.getReceiveTime());
            requestData.setTimeToFirstBytes(socketStats.getTimeToFirstBytes());
            requestData.setTimeToLastBytes(socketStats.getTimeToLastBytes());
            requestData.setDnsTime(socketStats.getDnsLookupTime());
            DnsInfo dnsInfo = requestExecutionContext.getDnsMonitor().getDnsInfo();
            requestData.setIpAddresses(dnsInfo.getIpAddresses());
            requestData.setUsedIpAddress(requestExecutionContext.getTargetAddress());
            SessionImpl session = (SessionImpl)Session.getCurrent();
            session.getDataManager().logDataRecord(requestData);
            session.getRequestHistory().add(requestName, clonedWebRequest, response, requestData);
            session.getNetworkDataManager().addData(new NetworkData(clonedWebRequest, response));
            this.logEventIfNecessary(clonedWebRequest, response);
            PageStatistics.getPageStatistics().addToBytes(requestData.getBytesReceived());
            if (response != null) {
                response.setRawSize(requestData.getBytesReceived());
            }
        }
    }

    protected WebRequest cloneWebRequest(WebRequest webRequest) {
        WebRequest newWebRequestSettings = new WebRequest(URLCleaner.removeUserInfoIfNecessaryAsURL(webRequest.getUrl()));
        newWebRequestSettings.setAdditionalHeaders(XltHttpWebConnection.cleanHeaders(webRequest.getAdditionalHeaders()));
        newWebRequestSettings.setCharset(webRequest.getCharset());
        newWebRequestSettings.setCredentials(webRequest.getCredentials());
        newWebRequestSettings.setEncodingType(webRequest.getEncodingType());
        newWebRequestSettings.setHttpMethod(webRequest.getHttpMethod());
        newWebRequestSettings.setProxyHost(webRequest.getProxyHost());
        newWebRequestSettings.setProxyPort(webRequest.getProxyPort());
        newWebRequestSettings.setOriginalURL(URLCleaner.removeUserInfoIfNecessaryAsURL(webRequest.getOriginalURL()));
        if (webRequest.getRequestBody() != null) {
            newWebRequestSettings.setRequestBody(webRequest.getRequestBody());
        } else {
            newWebRequestSettings.setRequestParameters(webRequest.getRequestParameters());
        }
        return newWebRequestSettings;
    }

    protected void logEventIfNecessary(WebRequest request, WebResponse response) {
        URL url;
        int statusCode;
        if (!logEventOnRequestFailure) {
            return;
        }
        if (response == null) {
            statusCode = 0;
            url = request.getUrl();
        } else {
            statusCode = response.getStatusCode();
            url = response.getWebRequest().getUrl();
        }
        if (statusCode == 0 || statusCode >= 400) {
            String eventName = "Failed to download resource";
            String message = String.format("[%d] %s", statusCode, URLCleaner.removeUserInfoIfNecessaryAsString(url));
            Session.getCurrent().getDataManager().logEvent("Failed to download resource", message);
        }
    }

    protected static void putAdditionalRequestData(RequestData requestData, WebRequest webRequest) {
        if (XltPropertiesImpl.getInstance().collectAdditonalRequestData() && webRequest.getHttpMethod() == HttpMethod.POST) {
            FormEncodingType encodingType = webRequest.getEncodingType();
            requestData.setFormDataEncoding(encodingType.getName());
            if (encodingType == FormEncodingType.URL_ENCODED) {
                String formData = webRequest.getRequestBody();
                if (formData == null) {
                    formData = UrlUtils.getUrlEncodedParameters(webRequest.getRequestParameters());
                }
                requestData.setFormData(formData);
            }
        }
    }

    private static Map<String, String> cleanHeaders(Map<String, String> headers) {
        if (headers != null) {
            HashMap<String, String> cleanHeaders = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                if (StringUtils.equalsAny((CharSequence)name, (CharSequence[])new CharSequence[]{"Referer", "Origin"})) {
                    value = URLCleaner.removeUserInfoIfNecessaryAsString(value);
                }
                cleanHeaders.put(name, value);
            }
            return cleanHeaders;
        }
        return headers;
    }

    static {
        FAKE_RESPONSE_HEADER_LIST.add(new NameValuePair("Content-Type", "text/html; charset=UTF-8"));
        FAKE_RESPONSE_HEADER_LIST.add(new NameValuePair("X-XLT-REQUEST-TO-FILTERED-DOMAIN", "true"));
        XltProperties props = XltProperties.getInstance();
        String requestIdPropertyPrefix = "com.xceptance.xlt.http.requestId.";
        requestIdActive = props.getProperty("com.xceptance.xlt.http.requestId.enabled", false);
        requestIdLength = props.getProperty("com.xceptance.xlt.http.requestId.length", 15);
        requestIdHeader = props.getProperty("com.xceptance.xlt.http.requestId.headerName", "X-XLT-RequestId");
        requestIdAppendToUserAgent = props.getProperty("com.xceptance.xlt.http.requestId.appendToUserAgent", false);
        String responseIdPropertyPrefix = "com.xceptance.xlt.http.responseId.";
        responseIdActive = props.getProperty("com.xceptance.xlt.http.responseId.enabled", false);
        responseIdHeader = props.getProperty("com.xceptance.xlt.http.responseId.headerName", "X-XLT-ResponseId");
        logEventOnRequestFailure = props.getProperty("com.xceptance.xlt.http.requestFailure.logEvent", true);
    }
}

