/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.clientperformance;

import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.clientperformance.ClientPerformanceData;
import com.xceptance.xlt.clientperformance.ClientPerformanceExtensionConnector;
import com.xceptance.xlt.clientperformance.ClientPerformanceMetrics;
import com.xceptance.xlt.clientperformance.PerformanceDataTransformator;
import com.xceptance.xlt.engine.SessionImpl;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebExtConnectionHandler
implements ClientPerformanceExtensionConnector.ConnectionListener {
    private static final Logger LOG = LoggerFactory.getLogger(WebExtConnectionHandler.class);
    private static final String PROPERTY_STORAGE_TIMEOUT = "storage.timeout";
    private static final int STORAGE_TIMEOUT_DEFAULT = 60000;
    private static final int CONNECTION_TIMEOUT_DEFAULT = 5000;
    private final SessionImpl session = SessionImpl.getCurrent();
    private final ClientPerformanceExtensionConnector connector = new ClientPerformanceExtensionConnector(this);
    private final int connectionTimeout;
    private final int messageTimeout;
    private final int storageTimeout;
    private ClientPerformanceExtensionConnector.ClientPerformanceExtensionConnection currentConnection;

    public WebExtConnectionHandler(int aConnectionTimeout, int aMessageTimeout, int aStorageTimeout) {
        this.connectionTimeout = aConnectionTimeout;
        this.messageTimeout = aMessageTimeout;
        this.storageTimeout = aStorageTimeout;
    }

    public static WebExtConnectionHandler newInstance(String propertyDomain) {
        XltProperties props = XltProperties.getInstance();
        int storageTimeout = props.getProperty(propertyDomain + PROPERTY_STORAGE_TIMEOUT, 60000);
        int connectionTimeout = 5000;
        int messageTimeout = storageTimeout + 2000;
        return new WebExtConnectionHandler(5000, messageTimeout, storageTimeout);
    }

    public boolean isConnected() {
        return this.currentConnection != null && this.currentConnection.isOpen();
    }

    public void waitForConnect(long timeout) throws TimeoutException, ClientPerformanceExtensionConnector.CommunicationException, InterruptedException {
        if (!this.isConnected()) {
            this.connector.waitForNextConnection(timeout);
        }
    }

    @Override
    public void onConnect(ClientPerformanceExtensionConnector connector, ClientPerformanceExtensionConnector.ClientPerformanceExtensionConnection connection) {
        LOG.debug("Connected: " + String.valueOf(connection));
        if (this.currentConnection != null && this.currentConnection.isOpen()) {
            this.currentConnection.close();
        }
        this.currentConnection = connection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onMessage(ClientPerformanceExtensionConnector.ClientPerformanceExtensionConnection connection, JSONObject data, ClientPerformanceExtensionConnector.Responder responder) {
        String action = data.optString("action");
        LOG.debug("Message received for action: {}", (Object)action);
        try {
            if ("DUMP_PERFORMANCE_DATA".equals(action)) {
                this.dumpPerformanceData(data.optString("performanceData"));
                return;
            }
            if (!"KEEP_ALIVE_PING".equals(action)) return;
        }
        catch (Throwable t) {
            if (!LOG.isWarnEnabled()) return;
            LOG.warn("Failed to handle message: " + String.valueOf(data), t);
        }
    }

    @Override
    public void onError(ClientPerformanceExtensionConnector.ClientPerformanceExtensionConnection connection, ClientPerformanceExtensionConnector.CommunicationException throwable) {
        LOG.error("Error from connection: " + String.valueOf(connection), (Throwable)throwable);
    }

    @Override
    public void onClose(ClientPerformanceExtensionConnector.ClientPerformanceExtensionConnection connection) {
        LOG.debug("Extension connection closed: " + String.valueOf(connection));
    }

    private void dumpPerformanceData(String rawData) {
        try {
            List<ClientPerformanceData> performanceData = PerformanceDataTransformator.getTransformedPerformanceDataList(rawData);
            if (LOG.isDebugEnabled()) {
                int requestTimings = 0;
                int pageLoadTimings = 0;
                for (ClientPerformanceData clientPerformanceData : performanceData) {
                    requestTimings += clientPerformanceData.getRequestList().size();
                    pageLoadTimings += clientPerformanceData.getCustomDataList().size();
                }
                LOG.debug("Received client-performance metrics (requests: {}, page load timings: {})", (Object)requestTimings, (Object)pageLoadTimings);
            }
            ClientPerformanceMetrics.updatePerformanceData(this.session, performanceData);
        }
        catch (Throwable t) {
            LOG.warn("Failed to dump client performance data", t);
        }
    }

    private String fetchPerformanceData() throws JSONException, TimeoutException, ClientPerformanceExtensionConnector.CommunicationException, InterruptedException {
        ClientPerformanceExtensionConnector.ClientPerformanceExtensionConnection conn = this.currentConnection;
        if (conn == null || !conn.isOpen()) {
            conn = this.connector.waitForNextConnection(this.connectionTimeout);
        }
        JSONObject message = new JSONObject();
        message.put("action", (Object)"GET_DATA");
        message.put("storageTimeout", this.storageTimeout);
        return conn.sendRequest(message, this.messageTimeout).getString("data");
    }

    public void reportRemainingPerformanceData() {
        try {
            String performanceDataRaw = this.fetchPerformanceData();
            this.dumpPerformanceData(performanceDataRaw);
        }
        catch (Throwable t) {
            LOG.warn("Failed to update remaining client performance data", t);
        }
    }

    public void start() throws ClientPerformanceExtensionConnector.CommunicationException {
        this.connector.start();
    }

    public void stop() {
        this.connector.stop(5000);
    }

    public int getPort() {
        return this.connector.getPort();
    }

    public String getID() {
        return this.connector.getID();
    }
}

