/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.util;

import com.xceptance.common.lang.OpenStringBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class XltCharBuffer
implements CharSequence,
Comparable<XltCharBuffer> {
    private static final char[] EMPTY_ARRAY = new char[0];
    public static final XltCharBuffer EMPTY = new XltCharBuffer(EMPTY_ARRAY);
    private final char[] src;
    private final int from;
    private final int length;
    private int hashCode;

    public XltCharBuffer(char[] src) {
        this.src = src == null ? EMPTY_ARRAY : src;
        this.from = 0;
        this.length = this.src.length;
    }

    public XltCharBuffer(char[] src, int from, int length) {
        if (src != null) {
            this.src = src;
            this.from = from;
            this.length = length;
        } else {
            this.src = EMPTY_ARRAY;
            this.from = 0;
            this.length = 0;
        }
    }

    public static XltCharBuffer empty() {
        return EMPTY;
    }

    @Override
    public char charAt(int pos) {
        return this.src[this.from + pos];
    }

    public XltCharBuffer put(int pos, char c) {
        this.src[this.from + pos] = c;
        return this;
    }

    public List<XltCharBuffer> split(char splitChar) {
        ArrayList<XltCharBuffer> result = new ArrayList<XltCharBuffer>();
        int last = -1;
        for (int i = 0; i < this.length; ++i) {
            char c = this.charAt(i);
            if (c != splitChar) continue;
            result.add(this.substring(last + 1, i));
            last = i;
        }
        if (++last == 0 || last < this.length) {
            result.add(this.substring(last, this.length));
        } else {
            result.add(XltCharBuffer.empty());
        }
        return result;
    }

    public char peakAhead(int pos) {
        return pos < this.length ? this.charAt(pos) : (char)'\u0000';
    }

    public XltCharBuffer viewByLength(int from, int length) {
        return new XltCharBuffer(this.src, this.from + from, length);
    }

    public XltCharBuffer viewFromTo(int from, int to) {
        return new XltCharBuffer(this.src, this.from + from, to - from);
    }

    public XltCharBuffer substring(int from, int to) {
        return this.viewFromTo(from, to);
    }

    public XltCharBuffer substring(int from) {
        return this.viewByLength(from, this.length - from);
    }

    private static OpenStringBuilder append(OpenStringBuilder target, XltCharBuffer src) {
        target.append(src.src, src.from, src.length);
        return target;
    }

    public static XltCharBuffer valueOf(String s1, String s2) {
        OpenStringBuilder sb = new OpenStringBuilder(s1.length() + s2.length());
        sb.append(s1);
        sb.append(s2);
        return new XltCharBuffer(sb.getCharArray(), 0, sb.length());
    }

    public static XltCharBuffer valueOf(XltCharBuffer s1, XltCharBuffer s2) {
        OpenStringBuilder sb = new OpenStringBuilder(s1.length() + s2.length());
        XltCharBuffer.append(sb, s1);
        XltCharBuffer.append(sb, s2);
        return new XltCharBuffer(sb.getCharArray(), 0, sb.length());
    }

    public static XltCharBuffer valueOf(XltCharBuffer s1, char c) {
        OpenStringBuilder sb = new OpenStringBuilder(s1.length() + 1);
        XltCharBuffer.append(sb, s1);
        sb.append(c);
        return new XltCharBuffer(sb.getCharArray(), 0, sb.length());
    }

    public static XltCharBuffer valueOf(String s1, String s2, String s3) {
        OpenStringBuilder sb = new OpenStringBuilder(s1.length() + s2.length() + s3.length());
        sb.append(s1);
        sb.append(s2);
        sb.append(s3);
        return new XltCharBuffer(sb.getCharArray(), 0, sb.length());
    }

    public static XltCharBuffer valueOf(XltCharBuffer s1, XltCharBuffer s2, XltCharBuffer s3) {
        OpenStringBuilder sb = new OpenStringBuilder(s1.length() + s2.length() + s3.length());
        XltCharBuffer.append(sb, s1);
        XltCharBuffer.append(sb, s2);
        XltCharBuffer.append(sb, s3);
        return new XltCharBuffer(sb.getCharArray(), 0, sb.length());
    }

    public static XltCharBuffer valueOf(String s1, String s2, String s3, String ... more) {
        if (more == null || more.length == 0) {
            return XltCharBuffer.valueOf(s1, s2, s3);
        }
        int newSize = s1.length() + s2.length() + s3.length();
        for (int i = 0; i < more.length; ++i) {
            newSize += more[i].length();
        }
        OpenStringBuilder sb = new OpenStringBuilder(newSize);
        sb.append(s1);
        sb.append(s2);
        sb.append(s3);
        for (int i = 0; i < more.length; ++i) {
            sb.append(more[i]);
        }
        return new XltCharBuffer(sb.getCharArray(), 0, sb.length());
    }

    public static XltCharBuffer valueOf(char[] s) {
        return new XltCharBuffer(s);
    }

    public static XltCharBuffer valueOf(String s) {
        return s == null ? null : new XltCharBuffer(s.toCharArray());
    }

    @Override
    public String toString() {
        return String.valueOf(this.src, this.from, this.length);
    }

    public char[] toCharArray() {
        char[] target = new char[this.length];
        System.arraycopy(this.src, this.from, target, 0, this.length);
        return target;
    }

    private static int indexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public int indexOf(char c) {
        int end = this.length + this.from;
        for (int i = this.from; i < end; ++i) {
            if (this.src[i] != c) continue;
            return i - this.from;
        }
        return -1;
    }

    public int indexOf(XltCharBuffer s) {
        return XltCharBuffer.indexOf(this.src, this.from, this.length, s.src, s.from, s.length, 0);
    }

    public int indexOf(XltCharBuffer s, int fromIndex) {
        return XltCharBuffer.indexOf(this.src, this.from, this.length, s.src, s.from, s.length, fromIndex);
    }

    public boolean endsWith(XltCharBuffer s) {
        if (s.length > this.length) {
            return false;
        }
        return this.indexOf(s, this.length - s.length) > -1;
    }

    public boolean startsWith(XltCharBuffer s) {
        return this.indexOf(s, 0) == 0;
    }

    public int lastIndexOf(XltCharBuffer s) {
        return this.lastIndexOf(s, this.length);
    }

    public int lastIndexOf(XltCharBuffer s, int from) {
        if (s.length > this.length) {
            return -1;
        }
        if (from > this.length - s.length) {
            from = this.length - s.length;
        }
        block0: for (int i = from; i >= 0; --i) {
            for (int si = 0; si < s.length; ++si) {
                if (s.charAt(si) != this.charAt(i + si)) continue block0;
            }
            return i;
        }
        return -1;
    }

    @Override
    public int length() {
        return this.length;
    }

    public int hashCode() {
        int i;
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int h = 0;
        int l = this.length & 0xFFFFFFF8;
        int l2 = this.length + this.from;
        for (i = this.from; i < l; i += 8) {
            h = -1807454463 * h + 1742810335 * this.src[i + 0] + 887503681 * this.src[i + 1] + 28629151 * this.src[i + 2] + 923521 * this.src[i + 3] + 29791 * this.src[i + 4] + 961 * this.src[i + 5] + 31 * this.src[i + 6] + '\u0001' * this.src[i + 7];
        }
        while (i < l2) {
            h = 31 * h + this.src[i];
            ++i;
        }
        this.hashCode = h;
        return h;
    }

    public static XltCharBuffer emptyWhenNull(XltCharBuffer s) {
        return s == null ? XltCharBuffer.empty() : s;
    }

    public boolean equals(Object obj) {
        if (obj instanceof XltCharBuffer) {
            XltCharBuffer other = (XltCharBuffer)obj;
            return Arrays.equals(this.src, this.from, this.from + this.length, other.src, other.from, other.from + other.length);
        }
        return false;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public static int[] createShiftTable(XltCharBuffer needle) {
        int i;
        int[] shiftTable = new int[256];
        for (i = 0; i < 256; ++i) {
            shiftTable[i] = needle.length;
        }
        for (i = 0; i < needle.length - 1; ++i) {
            if (needle.charAt(i) >= shiftTable.length) continue;
            shiftTable[needle.charAt((int)i)] = needle.length - 1 - i;
        }
        return shiftTable;
    }

    public static boolean contains(XltCharBuffer haystack, XltCharBuffer needle, int[] shiftTable) {
        if (needle.length > haystack.length) {
            return false;
        }
        int i = 0;
        while (i <= haystack.length - needle.length) {
            int j;
            for (j = needle.length - 1; j >= 0 && haystack.charAt(i + j) == needle.charAt(j); --j) {
            }
            if (j < 0) {
                return true;
            }
            int nextCharIndex = i + needle.length - 1;
            if (shiftTable.length <= haystack.charAt(nextCharIndex)) {
                i += needle.length;
                continue;
            }
            i += shiftTable[haystack.charAt(nextCharIndex)];
        }
        return false;
    }

    @Override
    public int compareTo(XltCharBuffer other) {
        return Arrays.compare(this.src, this.from, this.from + this.length, other.src, other.from, other.from + other.length);
    }

    public String toDebugString() {
        return String.format("Base=%s\nCurrent=%s\nfrom=%d, length=%d", new String(this.src), this, this.from, this.length);
    }
}

