/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.data;

import com.xceptance.xlt.api.util.XltRandom;
import com.xceptance.xlt.util.ExclusiveUtils;
import com.xceptance.xlt.util.LineProvider;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class ExclusiveDataProvider<T> {
    private static final Map<Key, ExclusiveDataProvider<?>> EXCLUSIVE_DATA_PROVIDERS = new ConcurrentHashMap();
    public static final Parser<String> DEFAULT_PARSER = new Parser<String>(){

        @Override
        public List<String> parse(List<String> lines) {
            return lines;
        }
    };
    private final List<T> dataItems;

    public static ExclusiveDataProvider<String> getNewInstance(String fileName) throws FileNotFoundException, IOException {
        return ExclusiveDataProvider.getNewInstance(fileName, "UTF-8");
    }

    public static ExclusiveDataProvider<String> getNewInstance(String fileName, String encoding) throws FileNotFoundException, IOException {
        return new ExclusiveDataProvider<String>(fileName, encoding, false, ExclusiveDataProvider.getDefaultParser());
    }

    public ExclusiveDataProvider(String fileName, boolean filterLineComments, Parser<T> parser) throws FileNotFoundException, IOException {
        this(fileName, "UTF-8", filterLineComments, parser);
    }

    public ExclusiveDataProvider(String fileName, Parser<T> parser) throws FileNotFoundException, IOException {
        this(fileName, "UTF-8", false, parser);
    }

    public ExclusiveDataProvider(String fileName, String encoding, Parser<T> parser) throws FileNotFoundException, IOException {
        this(fileName, encoding, false, parser);
    }

    public ExclusiveDataProvider(String fileName, String encoding, boolean filterLineComments, Parser<T> parser) throws FileNotFoundException, IOException {
        List<T> lines = ExclusiveDataProvider.loadData(fileName, encoding, filterLineComments, parser);
        this.dataItems = new ArrayList<T>(lines);
    }

    protected static <T> List<T> loadData(String fileName, String encoding, boolean filterLineComments, Parser<T> parser) throws FileNotFoundException, IOException {
        LineProvider p = LineProvider.getInstance(fileName, encoding, filterLineComments);
        List<String> exclusiveLines = ExclusiveUtils.getExclusiveAgentPart(p.getLines());
        return ExclusiveDataProvider.parse(exclusiveLines, parser);
    }

    protected static <T> List<T> loadData(String fileName, String encoding, Parser<T> parser) throws FileNotFoundException, IOException {
        return ExclusiveDataProvider.loadData(fileName, encoding, false, parser);
    }

    protected static <T> List<T> parse(List<String> lines, Parser<T> parser) {
        return parser.parse(lines);
    }

    public static ExclusiveDataProvider<String> getInstance(String fileName) throws FileNotFoundException, IOException {
        return ExclusiveDataProvider.getInstance(fileName, false, ExclusiveDataProvider.getDefaultParser());
    }

    public static ExclusiveDataProvider<String> getInstance(String fileName, boolean filterLineComments) throws FileNotFoundException, IOException {
        return ExclusiveDataProvider.getInstance(fileName, filterLineComments, ExclusiveDataProvider.getDefaultParser());
    }

    public static ExclusiveDataProvider<String> getInstance(String fileName, String encoding) throws FileNotFoundException, IOException {
        return ExclusiveDataProvider.getInstance(fileName, encoding, false, ExclusiveDataProvider.getDefaultParser());
    }

    public static <T> ExclusiveDataProvider<T> getInstance(String fileName, String encoding, Parser<T> parser) throws FileNotFoundException, IOException {
        return ExclusiveDataProvider.getInstance(fileName, encoding, false, parser);
    }

    public static <T> ExclusiveDataProvider<T> getInstance(String fileName, boolean filterLineComments, Parser<T> parser) throws FileNotFoundException, IOException {
        return ExclusiveDataProvider.getInstance(fileName, "UTF-8", filterLineComments, parser);
    }

    public static <T> ExclusiveDataProvider<T> getInstance(String fileName, Parser<T> parser) throws FileNotFoundException, IOException {
        return ExclusiveDataProvider.getInstance(fileName, "UTF-8", false, parser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ExclusiveDataProvider<T> getInstance(String fileName, String encoding, boolean filterLineComments, Parser<T> parser) throws FileNotFoundException, IOException {
        Key key = new Key(fileName, parser);
        ExclusiveDataProvider<Object> edp = EXCLUSIVE_DATA_PROVIDERS.get(key);
        if (edp == null) {
            Map<Key, ExclusiveDataProvider<?>> map = EXCLUSIVE_DATA_PROVIDERS;
            synchronized (map) {
                edp = EXCLUSIVE_DATA_PROVIDERS.get(key);
                if (edp == null) {
                    edp = new ExclusiveDataProvider<T>(fileName, encoding, filterLineComments, parser);
                    EXCLUSIVE_DATA_PROVIDERS.put(key, edp);
                }
            }
        }
        return edp;
    }

    public synchronized T get() {
        if (!this.dataItems.isEmpty()) {
            return this.dataItems.remove(0);
        }
        return null;
    }

    public synchronized T getRandom() {
        int size = this.dataItems.size();
        if (size > 0) {
            return this.dataItems.remove(XltRandom.nextInt(size));
        }
        return null;
    }

    public synchronized void add(T item) {
        this.dataItems.add(item);
    }

    public synchronized int size() {
        return this.dataItems.size();
    }

    public static Parser<String> getDefaultParser() {
        return DEFAULT_PARSER;
    }

    public static abstract class Parser<T> {
        public abstract List<T> parse(List<String> var1);
    }

    private static final class Key {
        private final String fileName;
        private final Parser<?> parser;

        public Key(String fileName, Parser<?> parser) {
            if (StringUtils.isBlank((CharSequence)fileName) || parser == null) {
                throw new IllegalArgumentException("The file name must not be blank and parser must not be NULL.");
            }
            this.fileName = fileName;
            this.parser = parser;
        }

        public boolean equals(Object o) {
            if (o != null) {
                if (o == this) {
                    return true;
                }
                if (o.getClass() == this.getClass()) {
                    Key k = (Key)o;
                    if (k.fileName.equals(this.fileName) && k.parser == this.parser) {
                        return true;
                    }
                }
            }
            return false;
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 13 + this.fileName.hashCode();
            hash = hash * 39 + this.parser.hashCode();
            return hash;
        }
    }
}

