/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.data;

import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.api.util.XltRandom;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class DataProvider {
    public static final String DEFAULT = "default";
    public static final String DEFAULT_FILE_ENCODING = "UTF-8";
    public static final String DEFAULT_LINE_COMMENT_MARKER = "#";
    private static final Map<String, DataProvider> dataProviders = new ConcurrentHashMap<String, DataProvider>();
    private final List<String> dataRows;
    private final String lineCommentMarker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataProvider getInstance(String fileName) throws FileNotFoundException, IOException {
        DataProvider dataProvider = dataProviders.get(fileName);
        if (dataProvider == null) {
            Map<String, DataProvider> map = dataProviders;
            synchronized (map) {
                dataProvider = dataProviders.get(fileName);
                if (dataProvider == null) {
                    dataProvider = new DataProvider(fileName);
                    dataProviders.put(fileName, dataProvider);
                }
            }
        }
        return dataProvider;
    }

    public DataProvider(String fileName) throws IOException, FileNotFoundException {
        this(fileName, DEFAULT_FILE_ENCODING, DEFAULT_LINE_COMMENT_MARKER);
    }

    public DataProvider(String fileName, String encoding) throws IOException, FileNotFoundException {
        this(fileName, encoding, DEFAULT_LINE_COMMENT_MARKER);
    }

    public DataProvider(String fileName, String encoding, String lineCommentMarker) throws IOException, FileNotFoundException {
        ParameterCheckUtils.isNotNullOrEmpty(fileName, "fileName");
        ParameterCheckUtils.isNotNullOrEmpty(encoding, "encoding");
        this.lineCommentMarker = lineCommentMarker;
        File file = new File(XltProperties.getInstance().getDataDirectory().toFile(), fileName);
        this.dataRows = this.loadData(file, encoding);
    }

    public synchronized List<String> getAllRows() {
        return Collections.unmodifiableList(new ArrayList<String>(this.dataRows));
    }

    public String getRandomRow() {
        return this.getRandomRow(false);
    }

    public synchronized String getRandomRow(boolean removeWhitespace) {
        int r = XltRandom.nextInt(this.dataRows.size());
        return this.getRow(removeWhitespace, r);
    }

    public synchronized String getRow(boolean removeWhitespace, int rowNumber) {
        if (rowNumber < 0 || rowNumber >= this.dataRows.size()) {
            return null;
        }
        String s = this.dataRows.get(rowNumber);
        return removeWhitespace ? StringUtils.deleteWhitespace((String)s) : s;
    }

    public String getRow(int rowNumber) {
        return this.getRow(false, rowNumber);
    }

    public synchronized void addRow(int rowNumber, String row) {
        this.dataRows.add(rowNumber, row);
    }

    public synchronized void addRow(String row) {
        this.dataRows.add(row);
    }

    public synchronized String removeRow(int rowNumber) {
        if (rowNumber < 0 || rowNumber >= this.dataRows.size()) {
            return null;
        }
        return this.dataRows.remove(rowNumber);
    }

    public synchronized boolean removeRow(String row) {
        return this.dataRows.remove(row);
    }

    public int getSize() {
        return this.dataRows.size();
    }

    protected List<String> loadData(File file, String encoding) throws IOException, FileNotFoundException {
        if (XltLogger.runTimeLogger.isDebugEnabled()) {
            XltLogger.runTimeLogger.debug("Loading data from " + file.getAbsolutePath());
        }
        List lines = FileUtils.readLines((File)file, (String)encoding);
        return this.processLines(lines);
    }

    protected List<String> processLines(List<String> lines) {
        Iterator<String> iterator = lines.iterator();
        while (iterator.hasNext()) {
            String line = iterator.next();
            if (!this.isCommentLine(line)) continue;
            iterator.remove();
        }
        return lines;
    }

    private boolean isCommentLine(String line) {
        if (this.lineCommentMarker == null || this.lineCommentMarker.length() == 0) {
            return false;
        }
        return line.trim().startsWith(this.lineCommentMarker);
    }
}

