/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agentcontroller;

import com.xceptance.common.util.zip.ZipUtils;
import com.xceptance.xlt.agentcontroller.AgentManager;
import com.xceptance.xlt.util.FileReplicationIndex;
import com.xceptance.xlt.util.FileReplicationUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentFileManager {
    private static final Logger log = LoggerFactory.getLogger(AgentFileManager.class);
    private final File directory;

    public AgentFileManager(File directory) {
        this.directory = directory;
    }

    public void updateAgentFiles(File zipFile, List<File> filesToBeDeleted, Collection<AgentManager> agentManagers) {
        try {
            FileUtils.forceMkdir((File)this.directory);
            log.info("Deleting obsolete agent files");
            for (File file : filesToBeDeleted) {
                String relativePath = file.getPath().replace('\\', '/');
                File absoluteFile = new File(this.directory, relativePath);
                log.debug("Deleting file '" + String.valueOf(absoluteFile) + "' ...");
                if (com.xceptance.common.io.FileUtils.deleteDirectoryRelaxed(absoluteFile)) continue;
                log.warn("Unable to remove " + String.valueOf(absoluteFile.getAbsoluteFile()));
            }
            log.info("Installing new and updated agent files");
            log.debug("Unzipping agent archive '" + String.valueOf(zipFile) + "' to '" + String.valueOf(this.directory) + "' ...");
            ZipUtils.unzipFile(zipFile, this.directory);
            log.debug("Unzip finished.");
            for (AgentManager agentManager : agentManagers) {
                agentManager.updateAgentFiles(this.directory);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public FileReplicationIndex getAgentFilesIndex() {
        if (this.directory.exists()) {
            return FileReplicationUtils.getIndex(this.directory, (FileFilter)FileFilterUtils.makeSVNAware(null));
        }
        return null;
    }

    public void clear() throws IOException {
        if (this.directory.exists()) {
            FileUtils.deleteDirectory((File)this.directory);
        }
    }
}

