/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agentcontroller;

import com.caucho.hessian.client.HessianProxyFactory;
import com.xceptance.common.net.UrlConnectionFactory;
import com.xceptance.xlt.agentcontroller.AgentController;
import com.xceptance.xlt.agentcontroller.AgentControllerImpl;
import com.xceptance.xlt.agentcontroller.AgentControllerStatus;
import com.xceptance.xlt.agentcontroller.AgentManager;
import com.xceptance.xlt.agentcontroller.AgentStatus;
import com.xceptance.xlt.agentcontroller.FileManager;
import com.xceptance.xlt.agentcontroller.FileManagerProxy;
import com.xceptance.xlt.agentcontroller.TestResultAmount;
import com.xceptance.xlt.agentcontroller.TestUserConfiguration;
import com.xceptance.xlt.util.AgentControllerSystemInfo;
import com.xceptance.xlt.util.FileReplicationIndex;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentControllerProxy
extends AgentControllerImpl {
    private static final Logger log = LoggerFactory.getLogger(AgentControllerProxy.class);
    public static final long DEFAULT_DOWNLOAD_CHUNK_SIZE = 100000000L;
    public static final int DEFAULT_DOWNLOAD_MAX_RETRIES = 1;
    private AgentController agentController;
    private FileManager fileManager;
    private final HessianProxyFactory proxyFactory;
    private final UrlConnectionFactory urlConnectionFactory;
    private final long downloadChunkSize;
    private final int downloadMaxRetries;

    public AgentControllerProxy(Properties commandLineProperties, HessianProxyFactory proxyFactory, UrlConnectionFactory urlConnectionFactory) throws Exception {
        this(commandLineProperties, proxyFactory, urlConnectionFactory, 100000000L, 1);
    }

    public AgentControllerProxy(Properties commandLineProperties, HessianProxyFactory proxyFactory, UrlConnectionFactory urlConnectionFactory, long downloadChunkSize, int downloadMaxRetries) throws Exception {
        super(commandLineProperties);
        this.proxyFactory = proxyFactory;
        this.urlConnectionFactory = urlConnectionFactory;
        this.downloadChunkSize = downloadChunkSize;
        this.downloadMaxRetries = downloadMaxRetries;
    }

    @Override
    protected void prepare() throws IOException {
    }

    @Override
    protected void setupEnvironment(AgentManager agentManager) throws IOException {
    }

    @Override
    public void init(String name, URL url, int weight, int agentCount, int agentBaseNumber, boolean runsClientPerformanceTests) throws IOException {
        super.init(name, url, weight, agentCount, agentBaseNumber, runsClientPerformanceTests);
        this.setupAgentManagers();
        this.startProxy(this.getUrl());
    }

    @Override
    public void setTotalAgentCount(int totalAgentCount) {
        super.setTotalAgentCount(totalAgentCount);
        this.getAgentController().setTotalAgentCount(totalAgentCount);
    }

    public void startProxy(URL url) throws MalformedURLException {
        log.info("start proxy for " + this.getName());
        this.fileManager = new FileManagerProxy(url, this.urlConnectionFactory, this.downloadChunkSize, this.downloadMaxRetries);
        this.agentController = (AgentController)this.proxyFactory.create(AgentController.class, new URL(String.valueOf(url) + "/" + AgentController.class.getName()).toString());
    }

    @Override
    protected void startServlet() {
    }

    protected AgentController getAgentController() {
        return this.agentController;
    }

    @Override
    public FileManager getFileManager() {
        return this.fileManager;
    }

    @Override
    public String toString() {
        return "Agent Controller " + this.getName() + " <" + String.valueOf(this.getUrl()) + ">";
    }

    @Override
    public long getReferenceTimeDifference() {
        return this.getAgentController().getReferenceTimeDifference();
    }

    @Override
    public void setReferenceTime(long time) {
        this.getAgentController().setReferenceTime(time);
    }

    @Override
    public boolean hasRunningAgent() {
        return this.getAgentController().hasRunningAgent();
    }

    @Override
    public void stopAgents() {
        this.getAgentController().stopAgents();
    }

    @Override
    public List<TestUserConfiguration> getAgentLoadProfile(String agentID) {
        return this.getAgentController().getAgentLoadProfile(agentID);
    }

    @Override
    public void startAgents(Map<String, List<TestUserConfiguration>> loadProfiles) {
        this.getAgentController().startAgents(loadProfiles);
    }

    @Override
    @Deprecated
    public Set<AgentStatus> getAgentStatus() {
        return this.getAgentController().getAgentStatus();
    }

    @Override
    public AgentControllerStatus getStatus() {
        return this.getAgentController().getStatus();
    }

    @Override
    public void archiveAgentResults(TestResultAmount testResultAmount) {
        this.getAgentController().archiveAgentResults(testResultAmount);
    }

    @Override
    public Map<String, String> getAgentResultsArchives() {
        return this.getAgentController().getAgentResultsArchives();
    }

    @Override
    public boolean isArchiveAvailable() {
        return this.getAgentController().isArchiveAvailable();
    }

    @Override
    public void archiveDownloadDone() {
        this.getAgentController().archiveDownloadDone();
    }

    @Override
    public FileReplicationIndex getAgentFilesIndex() throws IOException {
        this.getAgentController().init(this.getName(), this.getUrl(), this.getWeight(), this.getAgentCount(), this.getAgentBaseNumber(), this.runsClientPerformanceTests());
        return this.getAgentController().getAgentFilesIndex();
    }

    @Override
    public void updateAgentFiles(String agentFilesZipFileName, List<File> filesToBeDeleted) throws IOException {
        this.getAgentController().updateAgentFiles(agentFilesZipFileName, filesToBeDeleted);
    }

    @Override
    public void setAgentStatus(AgentStatus agentStatus) {
        this.getAgentController().setAgentStatus(agentStatus);
    }

    @Override
    public void resetAgentsStatus() {
        this.getAgentController().resetAgentsStatus();
    }

    @Override
    public String archiveTestConfig() {
        return this.getAgentController().archiveTestConfig();
    }

    @Override
    public void ping() {
        this.getAgentController().ping();
    }

    @Override
    public AgentControllerSystemInfo info() {
        return this.getAgentController().info();
    }

    @Override
    public boolean isUpdateDone() throws Exception {
        return this.getAgentController().isUpdateDone();
    }

    @Override
    public void setUpdateAcknowledged() {
        this.getAgentController().setUpdateAcknowledged();
    }
}

