/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agent.unipro;

import com.xceptance.xlt.agent.unipro.AbstractFunction;
import com.xceptance.xlt.agent.unipro.ConstantFunction;
import com.xceptance.xlt.agent.unipro.Function;
import com.xceptance.xlt.agent.unipro.LinearFunction;
import java.util.ArrayList;
import java.util.List;

public class CompositeFunction
implements Function {
    private final List<AbstractFunction> functions = new ArrayList<AbstractFunction>();

    public CompositeFunction(int[][] timeValuePairs) {
        if (timeValuePairs == null || timeValuePairs.length == 0) {
            throw new IllegalArgumentException("At least one time/value pair must be given.");
        }
        if (timeValuePairs[0][0] > 0) {
            throw new IllegalArgumentException("The first time/value pair must have a time of 0.");
        }
        for (int i = 0; i < timeValuePairs.length - 1; ++i) {
            double x1 = timeValuePairs[i][0];
            double y1 = timeValuePairs[i][1];
            double x2 = timeValuePairs[i + 1][0];
            double y2 = timeValuePairs[i + 1][1];
            if (x1 > x2) {
                throw new IllegalArgumentException("The time/value pairs must be sorted in ascending order.");
            }
            AbstractFunction f = null;
            if (y1 == y2) {
                f = new ConstantFunction(x1, x2, y1);
            } else if (x1 != x2) {
                f = new LinearFunction(x1, y1, x2, y2);
            }
            if (f == null) continue;
            this.functions.add(f);
        }
        double x_last = timeValuePairs[timeValuePairs.length - 1][0];
        double y_last = timeValuePairs[timeValuePairs.length - 1][1];
        this.functions.add(new ConstantFunction(x_last, Double.MAX_VALUE, y_last));
    }

    @Override
    public double calculateY(double x) {
        AbstractFunction f = this.getResponsibleFunction(x);
        double y = f.calculateY(x);
        return y;
    }

    @Override
    public double calculateX2(double x, double area) {
        AbstractFunction f;
        double x1 = x;
        double x2 = 0.0;
        for (double remainingArea = area; remainingArea >= 0.001; remainingArea -= f.integrate(x1, x2)) {
            f = this.getResponsibleFunction(x1);
            x2 = f.calculateX2(x1, remainingArea);
            x1 = x2;
        }
        return x2;
    }

    @Override
    public double integrate(double x1, double x2) {
        double area = 0.0;
        double xi = x1;
        while (x2 - x1 >= 0.001) {
            AbstractFunction f = this.getResponsibleFunction(xi);
            double xMax = Math.min(x2, f.x2);
            area += f.integrate(xi, xMax);
            xi = xMax;
        }
        return area;
    }

    private AbstractFunction getResponsibleFunction(double x) {
        for (AbstractFunction f : this.functions) {
            if (!f.isResponsibleFor(x)) continue;
            return f;
        }
        throw new IllegalArgumentException("No responsible function found for x value: " + x);
    }

    public boolean isSpecialPoint(int x) {
        if (x > 0) {
            int lastIdx = this.functions.size() - 1;
            for (int i = 0; i < lastIdx; ++i) {
                AbstractFunction iFunc = this.functions.get(i);
                AbstractFunction i1Func = this.functions.get(i + 1);
                if (iFunc.x2 != (double)x || iFunc.y2 == i1Func.y1) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        Object erg = "";
        for (int i = 0; i < this.getSize(); ++i) {
            erg = (String)erg + this.functions.get(i).toString() + "\n";
        }
        return erg;
    }

    public int getSize() {
        return this.functions.size();
    }
}

