/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agent;

import com.xceptance.common.util.TimerUtils;
import com.xceptance.xlt.agent.AbstractExecutionTimer;
import com.xceptance.xlt.agent.AgentInfo;
import com.xceptance.xlt.agent.ExecutionTimerFactory;
import com.xceptance.xlt.agent.LoadTestRunner;
import com.xceptance.xlt.agentcontroller.AgentStatus;
import com.xceptance.xlt.agentcontroller.TestUserConfiguration;
import com.xceptance.xlt.api.util.XltProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;

public class LoadTest {
    private static final long DEFAULT_GRACE_PERIOD = 30000L;
    private static final long gracePeriod;
    private final List<LoadTestRunner> testRunners = new ArrayList<LoadTestRunner>();

    public LoadTest(List<TestUserConfiguration> configs, AgentStatus agentStatus, AgentInfo agentInfo) {
        long agentTimeout = this.determineLoadTestDuration(configs) + gracePeriod;
        TimerUtils.getTimer().schedule(new TimerTask(this){

            @Override
            public void run() {
                System.exit(0);
            }
        }, agentTimeout);
        for (TestUserConfiguration config : configs) {
            AbstractExecutionTimer timer = ExecutionTimerFactory.createTimer(config);
            LoadTestRunner runner = new LoadTestRunner(config, agentInfo, timer);
            runner.setDaemon(true);
            this.testRunners.add(runner);
            agentStatus.addTestUserStatus(runner.getTestUserStatus());
        }
    }

    public void abort() {
        for (LoadTestRunner testRunner : this.testRunners) {
            testRunner.setAborted();
        }
        for (AbstractExecutionTimer timer : ExecutionTimerFactory.getTimers()) {
            timer.stop();
        }
    }

    public void run() {
        for (LoadTestRunner testRunner : this.testRunners) {
            testRunner.start();
        }
        this.waitForCompletion(this.testRunners);
    }

    private void waitForCompletion(List<LoadTestRunner> runners) {
        for (LoadTestRunner runner : runners) {
            try {
                runner.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private long determineLoadTestDuration(List<TestUserConfiguration> testUserConfigurations) {
        long totalDuration = 0L;
        for (TestUserConfiguration userConfig : testUserConfigurations) {
            long durationOfTestUser = userConfig.getInitialDelay() + userConfig.getWarmUpPeriod() + userConfig.getMeasurementPeriod() + userConfig.getShutdownPeriod();
            totalDuration = Math.max(totalDuration, durationOfTestUser);
        }
        return totalDuration;
    }

    static {
        long v = XltProperties.getInstance().getProperty("com.xceptance.xlt.hangingUsersGracePeriod", 30000L);
        gracePeriod = v < 0L ? 30000L : v;
    }
}

