/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agent;

import com.xceptance.xlt.agent.AbstractExecutionTimer;
import com.xceptance.xlt.agent.PeriodicExecutionTimer;
import com.xceptance.xlt.agent.RandomExecutionTimer;
import com.xceptance.xlt.agentcontroller.TestUserConfiguration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class ExecutionTimerFactory {
    private static final Map<String, AbstractExecutionTimer> timers = new HashMap<String, AbstractExecutionTimer>();

    public static Collection<AbstractExecutionTimer> getTimers() {
        return Collections.unmodifiableCollection(timers.values());
    }

    public static synchronized AbstractExecutionTimer createTimer(TestUserConfiguration config) {
        String userTypeName = config.getUserName();
        AbstractExecutionTimer executionTimer = timers.get(userTypeName);
        if (executionTimer == null) {
            int[][] arrivalRates = config.getArrivalRates();
            int[][] users = config.getUsers();
            int shutdownPeriod = config.getShutdownPeriod();
            int agentIndex = config.getAgentIndex();
            int warmUpPeriod = config.getWarmUpPeriod();
            int measurementPeriod = config.getMeasurementPeriod();
            int initialDelay = config.getInitialDelay();
            int duration = warmUpPeriod + measurementPeriod;
            executionTimer = arrivalRates == null ? new RandomExecutionTimer(userTypeName, initialDelay, duration, shutdownPeriod, users, agentIndex) : new PeriodicExecutionTimer(userTypeName, initialDelay, duration, shutdownPeriod, arrivalRates, agentIndex, config.getWeightFunction());
            timers.put(userTypeName, executionTimer);
        }
        return executionTimer;
    }
}

