/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agent;

import com.xceptance.xlt.engine.SessionImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;

public abstract class AbstractExecutionTimer {
    private volatile boolean stopped;
    private final Collection<Thread> waitingThreads = new HashSet<Thread>();
    private final Collection<Thread> knownThreads = new HashSet<Thread>();

    protected AbstractExecutionTimer(String userTypeName, long initialDelay, long duration, int shutdownPeriod) {
        if (duration > 0L) {
            Timer timer = new Timer("AbstractExecutionTimer-" + userTypeName, true);
            if (shutdownPeriod > 0) {
                timer.schedule((TimerTask)new AutoStopTimerTask(), initialDelay + duration);
            }
            timer.schedule((TimerTask)new AutoStopRemainingTimerTask(), initialDelay + duration + (long)shutdownPeriod);
        }
    }

    protected abstract void executeWait() throws InterruptedException;

    public Collection<Thread> getThreads() {
        return this.knownThreads;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    private void registerCurrentThread() {
        Thread t = Thread.currentThread();
        this.waitingThreads.add(t);
        this.knownThreads.add(t);
    }

    private void unregisterCurrentThread() {
        this.waitingThreads.remove(Thread.currentThread());
    }

    public synchronized void stop() {
        this.stopped = true;
        this.stopThreads(this.knownThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForNextExecution() throws InterruptedException {
        AbstractExecutionTimer abstractExecutionTimer = this;
        synchronized (abstractExecutionTimer) {
            if (this.stopped) {
                throw new InterruptedException("User quits voluntarily as the measurement period is over");
            }
            this.registerCurrentThread();
        }
        try {
            this.executeWait();
        }
        finally {
            abstractExecutionTimer = this;
            synchronized (abstractExecutionTimer) {
                this.unregisterCurrentThread();
                if (this.stopped) {
                    throw new InterruptedException("User quits voluntarily as the measurement period is over");
                }
            }
        }
    }

    private synchronized void stopWaitingThreads() {
        this.stopped = true;
        this.stopThreads(this.waitingThreads);
    }

    private void stopThreads(Collection<Thread> threads) {
        for (Thread thread : threads) {
            this.stopThread(thread);
        }
    }

    synchronized void stopThread(Thread thread) {
        if (thread.isAlive()) {
            if (this.waitingThreads.contains(thread)) {
                thread.interrupt();
            } else {
                SessionImpl sessionImpl = SessionImpl.getSessionForThread(thread);
                if (sessionImpl != null) {
                    sessionImpl.markAsExpired();
                }
            }
        }
    }

    private class AutoStopTimerTask
    extends TimerTask {
        private AutoStopTimerTask() {
        }

        @Override
        public void run() {
            AbstractExecutionTimer.this.stopWaitingThreads();
        }
    }

    private class AutoStopRemainingTimerTask
    extends TimerTask {
        private AutoStopRemainingTimerTask() {
        }

        @Override
        public void run() {
            AbstractExecutionTimer.this.stop();
        }
    }
}

