/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.xml;

import com.xceptance.common.xml.XmlDomPrinter;
import com.xceptance.xlt.api.util.XltLogger;
import java.io.OutputStream;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class DomUtils {
    private static final XmlDomPrinter xmlDomPrinter = new XmlDomPrinter(4);

    private DomUtils() {
    }

    public static String prettyPrintNode(Node node) {
        return xmlDomPrinter.printNode(node);
    }

    public static void prettyPrintNode(Node node, OutputStream out) {
        xmlDomPrinter.printNode(node, out);
    }

    public static void prettyPrintNode(Node node, Writer out) {
        xmlDomPrinter.printNode(node, out);
    }

    public static void removeElementsByTagName(Document document, String tagName) {
        NodeList nodes = document.getElementsByTagName(tagName);
        while (nodes.getLength() > 0) {
            Node node = nodes.item(0);
            node.getParentNode().removeChild(node);
        }
    }

    public static Node cloneNode(Node node, Document document) {
        if (node instanceof Element) {
            return DomUtils.cloneElementNode((Element)node, document);
        }
        if (node instanceof CDATASection) {
            return DomUtils.cloneCDATA((CDATASection)node, document);
        }
        if (node instanceof Text) {
            return DomUtils.cloneText((Text)node, document);
        }
        if (node instanceof Comment) {
            return DomUtils.cloneComment((Comment)node, document);
        }
        XltLogger.runTimeLogger.warn("Don't know how to clone this node: " + String.valueOf(node.getClass()));
        return null;
    }

    private static Node cloneElementNode(Element node, Document document) {
        Element clone = document.createElement(node.getTagName());
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            clone.setAttribute(attribute.getName(), attribute.getValue());
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            clone.appendChild(DomUtils.cloneNode(child, document));
        }
        return clone;
    }

    private static Node cloneCDATA(CDATASection node, Document document) {
        return document.createCDATASection(node.getData());
    }

    private static Node cloneText(Text node, Document document) {
        return document.createTextNode(node.getData());
    }

    private static Node cloneComment(Comment node, Document document) {
        return document.createComment(node.getData());
    }
}

