/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.util;

import java.io.File;
import java.util.Arrays;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;

public final class ParameterCheckUtils {
    private ParameterCheckUtils() {
    }

    public static void isNotNull(Object parameter, String parameterName) {
        if (parameter == null) {
            ParameterCheckUtils.doThrow(parameterName, Reason.NULL, new String[0]);
        }
    }

    public static void isNotNullOrEmpty(String parameter, String parameterName) {
        ParameterCheckUtils.isNotNull(parameter, parameterName);
        if (parameter.trim().length() == 0) {
            ParameterCheckUtils.doThrow(parameterName, Reason.EMPTY, new String[0]);
        }
    }

    public static void isNotNullOrEmpty(String[] parameter, String parameterName) {
        ParameterCheckUtils.isNotNull(parameter, parameterName);
        ParameterCheckUtils.isGreaterThan(parameter.length, 0, parameterName);
    }

    public static void isReadableFile(File file, String parameterName) {
        ParameterCheckUtils.isNotNull(file, parameterName);
        Reason reason = null;
        if (!file.exists()) {
            reason = Reason.NON_EXISTENT;
        } else if (!file.isFile()) {
            reason = Reason.NOT_FILE;
        } else if (!file.canRead()) {
            reason = Reason.UNREADABLE;
        }
        if (reason != null) {
            ParameterCheckUtils.doThrow(parameterName, reason, file.getAbsolutePath());
        }
    }

    public static void isReadableFile(FileObject file, String parameterName) {
        ParameterCheckUtils.isNotNull(file, parameterName);
        Reason reason = null;
        try {
            if (!file.exists()) {
                reason = Reason.NON_EXISTENT;
            } else if (file.getType() != FileType.FILE) {
                reason = Reason.NOT_FILE;
            } else if (!file.isReadable()) {
                reason = Reason.UNREADABLE;
            }
        }
        catch (FileSystemException e) {
            reason = Reason.UNACCESSIBLE;
        }
        if (reason != null) {
            ParameterCheckUtils.doThrow(parameterName, reason, file.getName().getURI());
        }
    }

    public static void isWritableDirectory(File file, String parameterName) {
        ParameterCheckUtils.isNotNull(file, parameterName);
        Reason reason = null;
        if (!file.isDirectory()) {
            reason = Reason.NOT_DIRECTORY;
        } else if (!file.exists()) {
            reason = Reason.NON_EXISTENT;
        } else if (!file.canWrite()) {
            reason = Reason.UNWRITABLE;
        }
        if (reason != null) {
            ParameterCheckUtils.doThrow(parameterName, reason, file.getAbsolutePath());
        }
    }

    public static void isWritableFile(File file, String parameterName) {
        ParameterCheckUtils.isNotNull(file, parameterName);
        Reason reason = null;
        if (file.exists()) {
            if (!file.isFile()) {
                reason = Reason.NOT_FILE;
            } else if (!file.canWrite()) {
                reason = Reason.UNWRITABLE;
            }
        }
        if (reason != null) {
            ParameterCheckUtils.doThrow(parameterName, reason, file.getAbsolutePath());
        }
    }

    public static void isValidArray(Object arr, String parameterName) {
        ParameterCheckUtils.isNotNull(arr, parameterName);
        if (!Object[].class.isAssignableFrom(arr.getClass())) {
            ParameterCheckUtils.doThrow(parameterName, Reason.NOT_ARRAY, new String[0]);
        }
    }

    public static void isValidArrayOfMinSize(Object arr, int minSize, String parameterName) {
        ParameterCheckUtils.isValidArray(arr, parameterName);
        if (((Object[])arr).length < minSize) {
            ParameterCheckUtils.doThrow(parameterName, Reason.LESS, Integer.toString(minSize));
        }
    }

    public static void isNonEmptyString(String str, String parameterName) {
        ParameterCheckUtils.isNotNull(str, parameterName);
        if (str.trim().length() <= 0) {
            ParameterCheckUtils.doThrow(parameterName, Reason.EMPTY, new String[0]);
        }
    }

    public static void isGreaterThan(int value, int limit, String parameterName) {
        if (value <= limit) {
            ParameterCheckUtils.doThrow(parameterName, Reason.LESS, Integer.toString(limit + 1));
        }
    }

    public static void isLessThan(int value, int limit, String parameterName) {
        if (value >= limit) {
            ParameterCheckUtils.doThrow(parameterName, Reason.GREATER, Integer.toString(limit));
        }
    }

    public static void isNotNegative(int value, String parameterName) {
        if (value < 0) {
            ParameterCheckUtils.doThrow(parameterName, Reason.NEGATIVE, new String[0]);
        }
    }

    public static void isRelativePath(String path, String parameterName) {
        ParameterCheckUtils.isNonEmptyString(path, parameterName);
        if (path.charAt(0) == '/') {
            ParameterCheckUtils.doThrow(parameterName, Reason.ABSOLUTE, new String[0]);
        }
    }

    private static void doThrow(String parameterName, Reason reason, String ... arguments) {
        String s = "Parameter '" + parameterName + "' is invalid, because " + reason.toString();
        if (arguments != null && arguments.length > 0) {
            s = s + " -> " + Arrays.toString(arguments);
        }
        throw new IllegalArgumentException(s);
    }

    private static enum Reason {
        NULL,
        EMPTY,
        NEGATIVE,
        UNREADABLE("an unreadable file"),
        UNWRITABLE("an unwritable file"),
        ABSOLUTE("an absolute path"),
        LESS("less than"),
        GREATER("greater than"),
        NOT_ARRAY("not an array"),
        NOT_DIRECTORY("not a directory"),
        NON_EXISTENT("non-existent"),
        NOT_FILE("not a file"),
        UNACCESSIBLE("an unaccessible file");

        private final String message;

        private Reason(String reasonDesc) {
            this.message = reasonDesc;
        }

        private Reason() {
            this(null);
        }

        public String getMessage() {
            return this.message == null ? this.name().toLowerCase() : this.message;
        }

        public String toString() {
            return "its value is " + this.getMessage();
        }
    }
}

