/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.util;

import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberUtils {
    public static <T extends Number> T negateNumber(T number) {
        if (number instanceof Byte) {
            if (number.byteValue() == -128) {
                throw new IllegalArgumentException("Cannot negate 'Byte.MIN_VALUE'.");
            }
            return (T)Byte.valueOf(-number.byteValue());
        }
        if (number instanceof Short) {
            if (number.shortValue() == Short.MIN_VALUE) {
                throw new IllegalArgumentException("Cannot negate 'Short.MIN_VALUE'.");
            }
            return (T)Short.valueOf(-number.shortValue());
        }
        if (number instanceof Integer) {
            if (number.intValue() == Integer.MIN_VALUE) {
                throw new IllegalArgumentException("Cannot negate 'Integer.MIN_VALUE'.");
            }
            return (T)Integer.valueOf(-number.intValue());
        }
        if (number instanceof Long) {
            if (number.longValue() == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Cannot negate 'Long.MIN_VALUE'.");
            }
            return (T)Long.valueOf(-number.longValue());
        }
        if (number instanceof Float) {
            return (T)Float.valueOf(-number.floatValue());
        }
        if (number instanceof Double) {
            return (T)Double.valueOf(-number.doubleValue());
        }
        if (number instanceof BigInteger) {
            return (T)((BigInteger)number).negate();
        }
        if (number instanceof BigDecimal) {
            return (T)((BigDecimal)number).negate();
        }
        throw new UnsupportedOperationException("Cannot negate number of type '" + number.getClass().getSimpleName() + "'.");
    }
}

