/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.util;

import com.xceptance.common.util.ParameterCheckUtils;
import java.util.ArrayList;
import java.util.List;

public final class CsvUtils {
    public static final char COMMA = ',';
    private static final char QUOTE_CHAR = '\"';
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final String[] TYPE_STRING_ARRAY = new String[0];

    private CsvUtils() {
    }

    public static String[] decode(String s) {
        return CsvUtils.decode(s, ',').toArray(TYPE_STRING_ARRAY);
    }

    public static List<String> decodeToList(String s) {
        return CsvUtils.decode(s, ',');
    }

    public static String decodeField(String s) {
        if (s == null) {
            return s;
        }
        int length = s.length();
        if (length < 2) {
            return s;
        }
        int last = length - 1;
        if (s.charAt(0) != '\"' || s.charAt(last) != '\"') {
            return s;
        }
        char[] buffer = s.toCharArray();
        int target = 0;
        for (int src = 1; src < last; ++src) {
            char c = buffer[src];
            if (c == '\"' && (++src >= last || buffer[src] != '\"')) {
                throw new IllegalArgumentException("Parameter '" + s + "' is not properly CSV-encoded.");
            }
            buffer[target] = c;
            ++target;
        }
        return new String(buffer, 0, target);
    }

    public static StringBuilder encode(List<String> fields) {
        return CsvUtils.encode(fields, ',');
    }

    public static String encodeField(String s) {
        return CsvUtils.encodeField(s, ',');
    }

    public static String encodeField(String s, char fieldSeparator) {
        if (s == null) {
            return s;
        }
        int sourceLength = s.length();
        boolean needsQuoting = false;
        int quotesRead = 0;
        for (int i = 0; i < sourceLength; ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                ++quotesRead;
            }
            if (needsQuoting || !CsvUtils.needsQuote(c, fieldSeparator)) continue;
            needsQuoting = true;
        }
        if (!needsQuoting) {
            return s;
        }
        char[] targetChars = new char[sourceLength + quotesRead + 2];
        targetChars[0] = 34;
        int j = 1;
        int i = 0;
        while (i < sourceLength) {
            char c = s.charAt(i);
            if (c == '\"') {
                targetChars[j++] = c;
            }
            targetChars[j] = c;
            ++i;
            ++j;
        }
        targetChars[j] = 34;
        return new String(targetChars);
    }

    public static List<String> decode(String s, char fieldSeparator) {
        ParameterCheckUtils.isNotNull(s, "s");
        List<String> fields = CsvUtils.split(s, fieldSeparator);
        int length = fields.size();
        for (int i = 0; i < length; ++i) {
            fields.set(i, CsvUtils.decodeField(fields.get(i)));
        }
        return fields;
    }

    public static StringBuilder encode(List<String> fields, char fieldSeparator) {
        StringBuilder result = new StringBuilder(256);
        int length = fields.size();
        for (int i = 0; i < length; ++i) {
            String field = fields.get(i);
            if (field == null) {
                throw new IllegalArgumentException("Array entry must not be null.");
            }
            if (i != 0) {
                result.append(fieldSeparator);
            }
            result.append(CsvUtils.encodeField(field, fieldSeparator));
        }
        return result;
    }

    private static List<String> split(String s, char fieldSeparator) {
        int length = s.length();
        if (length == 0) {
            ArrayList<String> r = new ArrayList<String>();
            r.add("");
            return r;
        }
        ArrayList<String> fields = new ArrayList<String>(32);
        int beginIndex = 0;
        boolean insideQuotes = false;
        char[] chars = s.toCharArray();
        for (int i = 0; i < length; ++i) {
            char c = chars[i];
            if (c == fieldSeparator) {
                if (insideQuotes) continue;
                fields.add(s.substring(beginIndex, i));
                beginIndex = i + 1;
                continue;
            }
            if (c != '\"') continue;
            insideQuotes = !insideQuotes;
        }
        fields.add(s.substring(beginIndex));
        return fields;
    }

    private static boolean needsQuote(char c, char separatorChar) {
        return c == '\"' || c == '\n' || c == '\r' || c == separatorChar;
    }
}

