/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.util;

import com.xceptance.common.lang.ThreadUtils;
import com.xceptance.common.util.ParameterCheckUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class ConsoleUiUtils {
    private static final Set<EofHandler> EOF_HANDLERS = new LinkedHashSet<EofHandler>();
    private static BufferedReader STDIN_READER = new BufferedReader(new InputStreamReader(System.in));

    public static void addEofHandler(EofHandler eofHandler) {
        ParameterCheckUtils.isNotNull(eofHandler, "eofHandler");
        EOF_HANDLERS.add(eofHandler);
    }

    public static boolean confirm(String message) {
        String s;
        message = (String)message + " [y/n]";
        do {
            if (!"n".equalsIgnoreCase(s = ConsoleUiUtils.readLine((String)message))) continue;
            return false;
        } while (!"y".equalsIgnoreCase(s));
        return true;
    }

    public static <T> List<T> multiSelectItems(String header, List<String> displayNames, List<T> items, boolean allInsteadOfNone) {
        return ConsoleUiUtils.multiSelectItems(header, displayNames, items, allInsteadOfNone, null);
    }

    public static <T> List<T> multiSelectItems(String header, List<String> displayNames, List<T> items, boolean allInsteadOfNone, String allInsteadOfNothingLabel) {
        displayNames = new ArrayList<String>(displayNames);
        if (StringUtils.isNotBlank((CharSequence)allInsteadOfNothingLabel)) {
            displayNames.add(0, allInsteadOfNothingLabel);
        } else {
            displayNames.add(0, allInsteadOfNone ? "<all>" : "<none>");
        }
        int maxKeyLength = String.valueOf(displayNames.size()).length();
        System.out.println(header);
        for (int i = 0; i < displayNames.size(); ++i) {
            System.out.printf(" %s %s\n", StringUtils.leftPad((String)("(" + i + ")"), (int)(maxKeyLength + 2)), displayNames.get(i));
        }
        while (true) {
            String s;
            if (!StringUtils.isNotBlank((CharSequence)(s = ConsoleUiUtils.readLine()))) {
                continue;
            }
            try {
                String[] parts = StringUtils.split((String)s, (String)" ,;");
                LinkedHashSet<T> result = new LinkedHashSet<T>();
                for (int i = 0; i < parts.length; ++i) {
                    int n = Integer.parseInt(parts[i]);
                    if (n == 0) {
                        if (!allInsteadOfNone) continue;
                        result.addAll(items);
                        break;
                    }
                    result.add(items.get(n - 1));
                }
                return new ArrayList(result);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            break;
        }
    }

    public static int readInt(String message) {
        while (true) {
            String s = ConsoleUiUtils.readLine(message);
            try {
                int i = Integer.parseInt(s);
                if (i < 1) continue;
                return i;
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            break;
        }
    }

    public static String readLine() {
        return ConsoleUiUtils.readLine(null);
    }

    public static String readLine(String message) {
        StringBuilder prompt = new StringBuilder();
        if (!StringUtils.isBlank((CharSequence)message)) {
            prompt.append(message).append(' ');
        }
        prompt.append("=> ");
        System.out.print(prompt);
        try {
            String s = STDIN_READER.readLine();
            if (s == null) {
                System.out.println();
                ConsoleUiUtils.runEofHandlers();
                ThreadUtils.sleep();
            }
            return s;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read input from stdin", e);
        }
    }

    public static void removeEofHandler(EofHandler eofHandler) {
        ParameterCheckUtils.isNotNull(eofHandler, "eofHandler");
        EOF_HANDLERS.remove(eofHandler);
    }

    public static <T> T selectItem(String header, List<String> keys, List<String> displayNames, List<T> items) {
        if (keys == null) {
            keys = new ArrayList<String>();
            for (int i = 0; i < displayNames.size(); ++i) {
                keys.add(String.valueOf(i + 1));
            }
        }
        if (keys.size() != displayNames.size()) {
            throw new IllegalArgumentException("The count of display names and keys has to be equal!");
        }
        if (keys.size() != items.size()) {
            throw new IllegalArgumentException("The count of items and keys has to be equal!");
        }
        int maxKeyLength = 0;
        for (String key : keys) {
            maxKeyLength = Math.max(maxKeyLength, key.length());
        }
        System.out.println(header);
        for (int i = 0; i < displayNames.size(); ++i) {
            System.out.printf(" %s %s\n", StringUtils.leftPad((String)("(" + keys.get(i) + ")"), (int)(maxKeyLength + 2)), displayNames.get(i));
        }
        block3: while (true) {
            String key = ConsoleUiUtils.readLine();
            int i = 0;
            while (true) {
                if (i >= keys.size()) continue block3;
                if (keys.get(i).equals(key)) {
                    return items.get(i);
                }
                ++i;
            }
            break;
        }
    }

    public static <T> T selectItem(String header, List<String> displayNames, List<T> items) {
        if (displayNames.size() != items.size()) {
            throw new IllegalArgumentException("The count of display names and items has to be equal!");
        }
        return ConsoleUiUtils.selectItem(header, null, displayNames, items);
    }

    public static boolean wasEnterKeyPressed() {
        try {
            if (STDIN_READER.ready()) {
                STDIN_READER.readLine();
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read input from stdin", e);
        }
    }

    private static void runEofHandlers() {
        for (EofHandler eofHandler : EOF_HANDLERS) {
            eofHandler.onEof();
        }
    }

    private ConsoleUiUtils() {
    }

    public static interface EofHandler {
        public void onEof();
    }
}

