/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;

public class LRUClockMap<K, V> {
    private Wrapper<K, V>[] data;
    private int size;
    private final int maxSize;
    private int mask;
    private int clockHand = 0;

    public LRUClockMap(int maxSize) {
        if (maxSize < 4) {
            throw new IllegalArgumentException("MaxSize must be at least 4");
        }
        this.maxSize = maxSize;
        int capacity = LRUClockMap.arraySize(maxSize, 0.5f);
        this.mask = capacity - 1;
        this.data = new Wrapper[capacity];
    }

    private int mixHash(int h) {
        return h ^ h >>> 16;
    }

    public V getRaw(K key) {
        int ptr = this.mixHash(key.hashCode()) & this.mask;
        Wrapper<K, V> w;
        while ((w = this.data[ptr]) != null) {
            if (w.key.equals(key)) {
                return w.value;
            }
            ptr = ptr + 1 & this.mask;
        }
        return null;
    }

    public V get(K key) {
        int ptr = this.mixHash(key.hashCode()) & this.mask;
        Wrapper<K, V> w = this.data[ptr];
        if (w == null) {
            return null;
        }
        if (w.key.equals(key)) {
            if (!w.secondChance) {
                w.secondChance = true;
            }
            return w.value;
        }
        return this.expensiveGet(key, ptr);
    }

    private V expensiveGet(K key, int ptr) {
        Wrapper<K, V> w;
        do {
            if ((w = this.data[ptr = ptr + 1 & this.mask]) != null) continue;
            return null;
        } while (!w.key.equals(key));
        if (!w.secondChance) {
            w.secondChance = true;
        }
        return w.value;
    }

    public V put(K key, V value) {
        int ptr = this.mixHash(key.hashCode()) & this.mask;
        if (this.size == this.maxSize) {
            V oldValue = this.update(key, value, ptr);
            if (oldValue != null) {
                return oldValue;
            }
            this.evict();
        }
        return this.putInternal(key, value, ptr);
    }

    private V putInternal(K key, V value, int ptr) {
        while (true) {
            Wrapper<K, V> current;
            if ((current = this.data[ptr]) == null) {
                this.data[ptr] = new Wrapper<K, V>(key, value);
                ++this.size;
                return null;
            }
            if (current.key.equals(key)) {
                Object oldValue = current.value;
                current.value = value;
                current.secondChance = true;
                return oldValue;
            }
            ptr = ptr + 1 & this.mask;
        }
    }

    private V update(K key, V value, int ptr) {
        Wrapper<K, V> current;
        while ((current = this.data[ptr]) != null) {
            if (current.key.equals(key)) {
                Object oldValue = current.value;
                current.value = value;
                current.secondChance = true;
                return oldValue;
            }
            ptr = ptr + 1 & this.mask;
        }
        return null;
    }

    public V remove(K key) {
        int ptr = this.mixHash(key.hashCode()) & this.mask;
        Wrapper<K, V> w;
        while ((w = this.data[ptr]) != null) {
            if (w.key.equals(key)) {
                Object oldValue = w.value;
                this.freePositionAndAdjustArray(ptr);
                return oldValue;
            }
            ptr = ptr + 1 & this.mask;
        }
        return null;
    }

    private void evict() {
        while (true) {
            Wrapper<K, V> w;
            if ((w = this.data[this.clockHand]) != null) {
                if (!w.secondChance) {
                    this.freePositionAndAdjustArray(this.clockHand);
                    return;
                }
                w.secondChance = false;
            }
            this.clockHand = this.clockHand + 1 & this.mask;
        }
    }

    private void freePositionAndAdjustArray(int ptr) {
        Wrapper<K, V> w;
        this.data[ptr] = null;
        --this.size;
        int currentPtr = ptr;
        while ((w = this.data[currentPtr = currentPtr + 1 & this.mask]) != null) {
            this.data[currentPtr] = null;
            this.realign(w);
        }
    }

    private void realign(Wrapper<K, V> entry) {
        int ptr = this.mixHash(entry.key.hashCode()) & this.mask;
        while (true) {
            Wrapper<K, V> current;
            if ((current = this.data[ptr]) == null) {
                this.data[ptr] = entry;
                return;
            }
            ptr = ptr + 1 & this.mask;
        }
    }

    public int size() {
        return this.size;
    }

    public int occupiedSpace() {
        return this.data.length;
    }

    public int trueSize() {
        int count = 0;
        for (Wrapper<K, V> w : this.data) {
            if (w == null) continue;
            ++count;
        }
        return count;
    }

    public List<K> keys() {
        ArrayList result = new ArrayList();
        for (Wrapper<K, V> w : this.data) {
            if (w == null) continue;
            result.add(w.key);
        }
        return result;
    }

    public void clear() {
        Arrays.fill(this.data, null);
        this.size = 0;
    }

    private static long nextPowerOfTwo(long x) {
        if (x == 0L) {
            return 1L;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return (x | x >> 32) + 1L;
    }

    private static int arraySize(int expected, float f) {
        long s = Math.max(2L, LRUClockMap.nextPowerOfTwo((long)Math.ceil((float)expected / f)));
        if (s > 0x40000000L) {
            throw new IllegalArgumentException("Too large (" + expected + " expected elements with load factor " + f + ")");
        }
        return (int)s;
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(",\n", "LRUClockMap{\n", "\n}");
        int length = Math.min(this.data.length, 1024);
        for (int i = 0; i < length; ++i) {
            Wrapper<K, V> w = this.data[i];
            if (w == null) {
                sj.add(i + " FREE");
                continue;
            }
            sj.add(i + " " + new DebugWrapper<K, V>(w, i).toString());
        }
        sj.add("clockHand: " + this.clockHand);
        sj.add("size: " + this.size);
        sj.add("maxSize: " + this.maxSize);
        return sj.toString();
    }

    List<DebugWrapper<K, V>> getDebugData() {
        ArrayList<DebugWrapper<K, V>> result = new ArrayList<DebugWrapper<K, V>>(this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            Wrapper<K, V> w = this.data[i];
            if (w == null) {
                result.add(null);
                continue;
            }
            result.add(new DebugWrapper<K, V>(w, i));
        }
        return result;
    }

    private static class Wrapper<K, V> {
        final K key;
        V value;
        boolean secondChance;

        Wrapper(K key, V value) {
            this.key = key;
            this.value = value;
            this.secondChance = true;
        }

        public String toString() {
            return "[" + this.key.toString() + ", " + this.value.toString() + ", " + this.secondChance + "]";
        }
    }

    class DebugWrapper<DK, DV> {
        public final DK key;
        public final DV value;
        public final boolean secondChance;
        public final int currentPosition;
        public final int truePosition;

        DebugWrapper(Wrapper<DK, DV> wrapper, int currentPosition) {
            this.key = wrapper.key;
            this.value = wrapper.value;
            this.secondChance = wrapper.secondChance;
            this.currentPosition = currentPosition;
            this.truePosition = LRUClockMap.this.mixHash(wrapper.key.hashCode()) & LRUClockMap.this.mask;
        }

        public String toString() {
            return "[" + this.key.toString() + ", " + this.value.toString() + ", " + LRUClockMap.this.mixHash(this.key.hashCode()) + ", " + this.secondChance + ", " + this.truePosition + "]";
        }
    }
}

