/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.collection;

import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentLRUCache<K, V> {
    private volatile Cache<K, V> cache;
    private final int maxSize;
    public static final int MIN_SIZE = 10;

    public ConcurrentLRUCache(int maxSize) {
        if (maxSize < 10) {
            throw new IllegalArgumentException("Cache setting too small. Minimal cache size is 10");
        }
        this.maxSize = maxSize;
        this.cache = new Cache(this, maxSize);
    }

    public final V get(K key) {
        V value = this.getCacheEntry(key);
        if (value != null) {
            this.put(key, value);
        }
        return value;
    }

    private V getCacheEntry(K key) {
        Cache<K, V> localCache = this.cache;
        Object value = localCache.storage1.get(key);
        if (value == null && (value = localCache.storage2.get(key)) == null) {
            value = localCache.storage3.get(key);
        }
        return (V)value;
    }

    public final void put(K key, V value) {
        Cache<K, V> localCache = this.cache;
        if (localCache.storage1.size() >= localCache.storageSize) {
            this.cache = new Cache<K, V>(this, localCache);
            this.cache.storage1.put(key, value);
        } else {
            localCache.storage1.put(key, value);
        }
    }

    public final V remove(K key) {
        Cache<K, V> localCache = this.cache;
        Object value1 = localCache.storage1.remove(key);
        Object value2 = localCache.storage2.remove(key);
        Object value3 = localCache.storage3.remove(key);
        if (value1 != null) {
            return (V)value1;
        }
        if (value2 != null) {
            return (V)value2;
        }
        return (V)value3;
    }

    public final boolean contains(K key) {
        return this.getCacheEntry(key) != null;
    }

    public void clear() {
        this.cache = new Cache(this, this.maxSize);
    }

    public final int size() {
        return this.cache.size();
    }

    private class Cache<T, S> {
        private final int storageSize;
        private final ConcurrentHashMap<T, S> storage1;
        private final ConcurrentHashMap<T, S> storage2;
        private final ConcurrentHashMap<T, S> storage3;

        public Cache(ConcurrentLRUCache concurrentLRUCache, int maxSize) {
            int blockSize = 3;
            this.storageSize = maxSize / 3;
            this.storage1 = new ConcurrentHashMap(2 * this.storageSize + 1);
            this.storage2 = new ConcurrentHashMap(3);
            this.storage3 = new ConcurrentHashMap(3);
        }

        public Cache(ConcurrentLRUCache concurrentLRUCache, Cache<T, S> previousCache) {
            this.storageSize = previousCache.storageSize;
            this.storage1 = new ConcurrentHashMap(2 * this.storageSize + 1);
            this.storage2 = previousCache.storage1;
            this.storage3 = previousCache.storage2;
        }

        public int size() {
            return this.storage1.size() + this.storage2.size() + this.storage3.size();
        }
    }
}

