/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SubnetUtils {
    private static final String IP_ADDRESS = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
    private static final String PARSE_FAIL = "Could not parse [%s]";
    private static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;
    private final int netmask_;
    private final int address_;
    private final int network_;
    private final int broadcast_;

    public SubnetUtils(String address, String mask) {
        this.address_ = SubnetUtils.toInteger(address);
        this.netmask_ = SubnetUtils.toInteger(mask);
        if ((this.netmask_ & -this.netmask_) - 1 != ~this.netmask_) {
            throw new IllegalArgumentException(String.format(PARSE_FAIL, mask));
        }
        this.network_ = this.address_ & this.netmask_;
        this.broadcast_ = this.network_ | ~this.netmask_;
    }

    private static int matchAddress(Matcher matcher) {
        int addr = 0;
        for (int i = 1; i <= 4; ++i) {
            int n = SubnetUtils.rangeCheck(Integer.parseInt(matcher.group(i)), 0, 255);
            addr |= (n & 0xFF) << 8 * (4 - i);
        }
        return addr;
    }

    private static int rangeCheck(int value, int begin, int end) {
        if (value >= begin && value <= end) {
            return value;
        }
        throw new IllegalArgumentException("Value [" + value + "] not in range [" + begin + "," + end + "]");
    }

    private static int toInteger(String address) {
        Matcher matcher = ADDRESS_PATTERN.matcher(address);
        if (matcher.matches()) {
            return SubnetUtils.matchAddress(matcher);
        }
        throw new IllegalArgumentException(String.format(PARSE_FAIL, address));
    }

    private long broadcastLong() {
        return (long)this.broadcast_ & 0xFFFFFFFFL;
    }

    private int high() {
        return this.broadcastLong() - this.networkLong() > 1L ? this.broadcast_ - 1 : 0;
    }

    private int low() {
        return this.broadcastLong() - this.networkLong() > 1L ? this.network_ + 1 : 0;
    }

    private long networkLong() {
        return (long)this.network_ & 0xFFFFFFFFL;
    }

    private boolean isInRange(int address) {
        if (address == 0) {
            return false;
        }
        long addLong = (long)address & 0xFFFFFFFFL;
        long lowLong = (long)this.low() & 0xFFFFFFFFL;
        long highLong = (long)this.high() & 0xFFFFFFFFL;
        return addLong >= lowLong && addLong <= highLong;
    }

    public boolean isInRange(String address) {
        return this.isInRange(SubnetUtils.toInteger(address));
    }
}

