/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.util;

import java.util.Locale;
import org.htmlunit.cyberneko.util.FastHashMap;
import org.htmlunit.util.StringUtils;

public final class MimeType {
    public static final String TEXT_JAVASCRIPT = "text/javascript";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_XHTML = "application/xhtml+xml";
    public static final String APPLICATION_XML = "application/xml";
    public static final String TEXT_CSS = "text/css";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_XML = "text/xml";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String IMAGE_GIF = "image/gif";
    public static final String IMAGE_JPEG = "image/jpeg";
    public static final String IMAGE_PNG = "image/png";
    private static final FastHashMap<String, String> TYPE2EXTENSION = MimeType.buildMap();
    private static final FastHashMap<String, Boolean> LOOKUP_MAP = new FastHashMap(33, 0.7f);

    public static boolean isJavascriptMimeType(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        String mimeTypeLC = StringUtils.toRootLowerCase(mimeType);
        return TEXT_JAVASCRIPT.equals(mimeTypeLC) || "application/javascript".equals(mimeTypeLC) || "application/x-ecmascript".equals(mimeTypeLC) || "application/x-javascript".equals(mimeTypeLC) || "text/ecmascript".equals(mimeTypeLC) || "application/ecmascript".equals(mimeTypeLC) || "text/javascript1.0".equals(mimeTypeLC) || "text/javascript1.1".equals(mimeTypeLC) || "text/javascript1.2".equals(mimeTypeLC) || "text/javascript1.3".equals(mimeTypeLC) || "text/javascript1.4".equals(mimeTypeLC) || "text/javascript1.5".equals(mimeTypeLC) || "text/jscript".equals(mimeTypeLC) || "text/livescript".equals(mimeTypeLC) || "text/x-ecmascript".equals(mimeTypeLC) || "text/x-javascript".equals(mimeTypeLC);
    }

    public static boolean isObsoleteJavascriptMimeType(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        if (LOOKUP_MAP.get((Object)mimeType) != null) {
            return true;
        }
        String mimeTypeLC = mimeType.toLowerCase(Locale.ROOT);
        return "application/javascript".equals(mimeTypeLC) || "application/ecmascript".equals(mimeTypeLC) || "application/x-ecmascript".equals(mimeTypeLC) || "application/x-javascript".equals(mimeTypeLC) || "text/ecmascript".equals(mimeTypeLC) || "text/javascript1.0".equals(mimeTypeLC) || "text/javascript1.1".equals(mimeTypeLC) || "text/javascript1.2".equals(mimeTypeLC) || "text/javascript1.3".equals(mimeTypeLC) || "text/javascript1.4".equals(mimeTypeLC) || "text/javascript1.5".equals(mimeTypeLC) || "text/jscript".equals(mimeTypeLC) || "text/livescript".equals(mimeTypeLC) || "text/x-ecmascript".equals(mimeTypeLC) || "text/x-javascript".equals(mimeTypeLC);
    }

    private static FastHashMap<String, String> buildMap() {
        FastHashMap map = new FastHashMap(23, 0.7f);
        map.put((Object)"application/pdf", (Object)"pdf");
        map.put((Object)"application/x-javascript", (Object)"js");
        map.put((Object)IMAGE_GIF, (Object)"gif");
        map.put((Object)"image/jpg", (Object)"jpeg");
        map.put((Object)IMAGE_JPEG, (Object)"jpeg");
        map.put((Object)IMAGE_PNG, (Object)"png");
        map.put((Object)"image/svg+xml", (Object)"svg");
        map.put((Object)TEXT_CSS, (Object)"css");
        map.put((Object)TEXT_HTML, (Object)"html");
        map.put((Object)TEXT_PLAIN, (Object)"txt");
        map.put((Object)"image/x-icon", (Object)"ico");
        for (String k : map.keys()) {
            map.put((Object)k.toUpperCase(Locale.ROOT), (Object)((String)map.get((Object)k)));
        }
        return map;
    }

    private MimeType() {
    }

    public static String getFileExtension(String contentType) {
        if (contentType == null) {
            return "unknown";
        }
        String value = (String)TYPE2EXTENSION.get((Object)contentType);
        if (value == null) {
            String uppercased = contentType.toLowerCase(Locale.ROOT);
            value = (String)TYPE2EXTENSION.get((Object)uppercased);
        }
        return value == null ? "unknown" : value;
    }

    static {
        LOOKUP_MAP.put((Object)"application/javascript", (Object)true);
        LOOKUP_MAP.put((Object)"application/x-ecmascript", (Object)true);
        LOOKUP_MAP.put((Object)"application/x-javascript", (Object)true);
        LOOKUP_MAP.put((Object)"text/ecmascript", (Object)true);
        LOOKUP_MAP.put((Object)"application/ecmascript", (Object)true);
        LOOKUP_MAP.put((Object)"text/javascript1.0", (Object)true);
        LOOKUP_MAP.put((Object)"text/javascript1.1", (Object)true);
        LOOKUP_MAP.put((Object)"text/javascript1.2", (Object)true);
        LOOKUP_MAP.put((Object)"text/javascript1.3", (Object)true);
        LOOKUP_MAP.put((Object)"text/javascript1.4", (Object)true);
        LOOKUP_MAP.put((Object)"text/javascript1.5", (Object)true);
        LOOKUP_MAP.put((Object)"text/jscript", (Object)true);
        LOOKUP_MAP.put((Object)"text/livescript", (Object)true);
        LOOKUP_MAP.put((Object)"text/x-ecmascript", (Object)true);
        LOOKUP_MAP.put((Object)"text/x-javascript", (Object)true);
        for (String k : LOOKUP_MAP.keys()) {
            LOOKUP_MAP.put((Object)k.toUpperCase(Locale.ROOT), (Object)true);
        }
    }
}

