/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.platform;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.htmlunit.platform.XmlUtilsHelperAPI;
import org.htmlunit.platform.canvas.rendering.NoOpRenderingBackend;
import org.htmlunit.platform.canvas.rendering.RenderingBackend;
import org.htmlunit.platform.font.FontUtil;
import org.htmlunit.platform.font.NoOpFontUtil;
import org.htmlunit.platform.image.ImageData;
import org.htmlunit.platform.image.NoOpImageData;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class Platform {
    private static FontUtil FontUtil_;
    private static XmlUtilsHelperAPI HelperXerces_;
    private static XmlUtilsHelperAPI HelperSunXerces_;

    public static int getIndex(NamedNodeMap namedNodeMap, Map<Integer, List<String>> attributesOrderMap, Node element, int requiredIndex) {
        int result;
        if (HelperXerces_ != null && (result = HelperXerces_.getIndex(namedNodeMap, attributesOrderMap, element, requiredIndex)) != -1) {
            return result;
        }
        if (HelperSunXerces_ != null && (result = HelperSunXerces_.getIndex(namedNodeMap, attributesOrderMap, element, requiredIndex)) != -1) {
            return result;
        }
        return requiredIndex;
    }

    public static Map<Integer, List<String>> getAttributesOrderMap(Document document) {
        Map<Integer, List<String>> result;
        if (HelperXerces_ != null && (result = HelperXerces_.getAttributesOrderMap(document)) != null) {
            return result;
        }
        if (HelperSunXerces_ != null && (result = HelperSunXerces_.getAttributesOrderMap(document)) != null) {
            return result;
        }
        return new HashMap<Integer, List<String>>();
    }

    public static RenderingBackend getRenderingBackend(int imageWidth, int imageHeight) {
        try {
            Class<?> backendClass = Class.forName("org.htmlunit.platform.canvas.rendering.AwtRenderingBackend");
            return (RenderingBackend)ConstructorUtils.invokeConstructor(backendClass, (Object[])new Object[]{imageWidth, imageHeight});
        }
        catch (Throwable e) {
            return new NoOpRenderingBackend(imageWidth, imageHeight);
        }
    }

    public static FontUtil getFontUtil() {
        if (FontUtil_ != null) {
            return FontUtil_;
        }
        try {
            Class<?> backendClass = Class.forName("org.htmlunit.platform.font.AwtFontUtil");
            FontUtil_ = (FontUtil)ConstructorUtils.invokeConstructor(backendClass, (Object[])new Object[0]);
            return FontUtil_;
        }
        catch (Throwable e) {
            FontUtil_ = new NoOpFontUtil();
            return FontUtil_;
        }
    }

    public static ImageData buildImageData(InputStream inputStream) throws IOException {
        try {
            Class<?> backendClass = Class.forName("org.htmlunit.platform.image.ImageIOImageData");
            return (ImageData)ConstructorUtils.invokeConstructor(backendClass, (Object[])new Object[]{inputStream});
        }
        catch (InvocationTargetException ex) {
            Throwable targetEx = ex.getTargetException();
            if (targetEx instanceof IOException) {
                throw (IOException)targetEx;
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            return new NoOpImageData();
        }
    }

    private Platform() {
    }

    static {
        try {
            HelperSunXerces_ = (XmlUtilsHelperAPI)Class.forName("org.htmlunit.platform.util.XmlUtilsSunXercesHelper").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception | LinkageError throwable) {
            // empty catch block
        }
        try {
            HelperXerces_ = (XmlUtilsHelperAPI)Class.forName("org.htmlunit.platform.util.XmlUtilsXercesHelper").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception | LinkageError throwable) {
            // empty catch block
        }
    }
}

