/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.worker;

import java.net.URL;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.util.UrlUtils;

@JsxClass
public class WorkerLocation
extends HtmlUnitScriptable {
    private final URL url_;
    private final String origin_;

    public WorkerLocation() {
        this.url_ = null;
        this.origin_ = null;
    }

    WorkerLocation(URL url, String origin) {
        this.url_ = url;
        this.origin_ = origin;
    }

    @JsxConstructor
    public void jsConstructor() {
        throw JavaScriptEngine.typeErrorIllegalConstructor();
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (this.url_ != null && (hint == null || String.class.equals(hint))) {
            return this.getHref();
        }
        return super.getDefaultValue(hint);
    }

    @JsxGetter
    public String getHref() {
        Object s = this.url_.toExternalForm();
        if (((String)s).startsWith("file:/") && !((String)s).startsWith("file:///")) {
            s = "file:///" + ((String)s).substring("file:/".length());
        }
        return s;
    }

    @JsxGetter
    public String getProtocol() {
        return this.url_.getProtocol() + ":";
    }

    @JsxGetter
    public String getHost() {
        int port = this.url_.getPort();
        String host = this.url_.getHost();
        if (port == -1) {
            return host;
        }
        return host + ":" + port;
    }

    @JsxGetter
    public String getHostname() {
        return this.url_.getHost();
    }

    @JsxGetter
    public String getOrigin() {
        return this.origin_;
    }

    @JsxGetter
    public String getPort() {
        int port = this.url_.getPort();
        if (port == -1) {
            return "";
        }
        return Integer.toString(port);
    }

    @JsxGetter
    public String getPathname() {
        if (UrlUtils.URL_ABOUT_BLANK == this.url_) {
            return "blank";
        }
        return this.url_.getPath();
    }

    @JsxGetter
    public String getSearch() {
        String search = this.url_.getQuery();
        if (search == null) {
            return "";
        }
        return "?" + search;
    }

    @JsxGetter
    public String getHash() {
        String ref = this.url_.getRef();
        return ref == null ? "" : "#" + ref;
    }
}

